/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.marketplace;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.NlsRewrite;
import org.openrewrite.config.RecipeDescriptor;
import org.openrewrite.marketplace.RecipeListing;

public class RecipeMarketplace {
    static final String ROOT = "\u03b5";
    private final @NlsRewrite.DisplayName String displayName;
    private final @NlsRewrite.DisplayName String description;
    private final List<RecipeMarketplace> categories = new ArrayList<RecipeMarketplace>();
    private final List<RecipeListing> recipes = new ArrayList<RecipeListing>();

    public boolean isRoot() {
        return ROOT.equals(this.displayName);
    }

    public static RecipeMarketplace newEmpty() {
        return new RecipeMarketplace(ROOT, "");
    }

    public @Nullable RecipeDescriptor findRecipe(String name) {
        for (RecipeListing recipe : this.recipes) {
            if (!recipe.getName().equals(name)) continue;
            return recipe.describe();
        }
        for (RecipeMarketplace category : this.categories) {
            RecipeDescriptor rd = category.findRecipe(name);
            if (rd == null) continue;
            return rd;
        }
        return null;
    }

    public Set<RecipeListing> getAllRecipes() {
        LinkedHashMap<String, RecipeListing> recipesByName = new LinkedHashMap<String, RecipeListing>();
        this.collectAllRecipes(recipesByName);
        return new LinkedHashSet<RecipeListing>(recipesByName.values());
    }

    private void collectAllRecipes(Map<String, RecipeListing> recipesByName) {
        for (RecipeListing recipe : this.recipes) {
            recipesByName.putIfAbsent(recipe.getName(), recipe);
        }
        for (RecipeMarketplace category : this.categories) {
            category.collectAllRecipes(recipesByName);
        }
    }

    public void addRecipe(RecipeListing recipe, String ... categoryPath) {
        if (categoryPath.length == 0) {
            this.recipes.add(recipe);
            return;
        }
        String firstCategory = categoryPath[0];
        RecipeMarketplace targetCategory = this.findOrCreateCategory(firstCategory);
        String[] remainingPath = new String[categoryPath.length - 1];
        System.arraycopy(categoryPath, 1, remainingPath, 0, remainingPath.length);
        targetCategory.addRecipe(recipe, remainingPath);
    }

    public void merge(RecipeMarketplace other) {
        for (RecipeListing recipe : other.getRecipes()) {
            this.recipes.removeIf(existing -> existing.getName().equals(recipe.getName()));
            this.recipes.add(recipe);
        }
        for (RecipeMarketplace otherCategory : other.getCategories()) {
            RecipeMarketplace category = this.findOrCreateCategory(otherCategory.getDisplayName());
            category.merge(otherCategory);
        }
    }

    private RecipeMarketplace findOrCreateCategory(String categoryName) {
        for (RecipeMarketplace category : this.categories) {
            if (!category.getDisplayName().equals(categoryName)) continue;
            return category;
        }
        RecipeMarketplace newCategory = new RecipeMarketplace(categoryName, "");
        this.categories.add(newCategory);
        return newCategory;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public List<RecipeMarketplace> getCategories() {
        return this.categories;
    }

    @Generated
    public List<RecipeListing> getRecipes() {
        return this.recipes;
    }

    @Generated
    public RecipeMarketplace(String displayName, String description) {
        this.displayName = displayName;
        this.description = description;
    }
}

