/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.remote;

import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Objects;
import java.util.UUID;
import org.intellij.lang.annotations.Language;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Checksum;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.FileAttributes;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.marker.Markers;
import org.openrewrite.remote.RemoteArchive;
import org.openrewrite.remote.RemoteFile;
import org.openrewrite.remote.RemoteResource;
import org.openrewrite.remote.RemoteVisitor;

public interface Remote
extends SourceFile {
    public String getDescription();

    public <R extends Remote> R withDescription(String var1);

    @Override
    default public @Nullable Checksum getChecksum() {
        return null;
    }

    @Override
    default public <T extends SourceFile> T withChecksum(@Nullable Checksum checksum) {
        return (T)this;
    }

    public InputStream getInputStream(ExecutionContext var1);

    @Override
    default public <P> String printAll(P p) {
        ExecutionContext ctx = p instanceof ExecutionContext ? (ExecutionContext)p : new InMemoryExecutionContext();
        return StringUtils.readFully(this.getInputStream(ctx), StandardCharsets.UTF_8);
    }

    @Override
    default public <P> String printAllTrimmed(P p) {
        return StringUtils.trimIndentPreserveCRLF(this.printAll(p));
    }

    @Override
    default public <R extends Tree, P> R accept(TreeVisitor<R, P> v, P p) {
        return (R)v.adapt(RemoteVisitor.class).visitRemote(this, p);
    }

    @Override
    default public <P> boolean isAcceptable(TreeVisitor<?, P> v, P p) {
        return v.isAdaptableTo(RemoteVisitor.class);
    }

    public static Builder builder(SourceFile before) {
        return new Builder(before.getId(), before.getSourcePath(), before.getMarkers());
    }

    public static Builder builder(Path sourcePath) {
        return new Builder(Tree.randomId(), sourcePath, Markers.EMPTY);
    }

    @Override
    default public <P> TreeVisitor<?, PrintOutputCapture<P>> printer(Cursor cursor) {
        return new TreeVisitor<Tree, PrintOutputCapture<P>>(){

            @Override
            public Tree visit(@Nullable Tree tree, PrintOutputCapture<P> p) {
                SourceFile sourceFile = (SourceFile)Objects.requireNonNull(tree);
                ExecutionContext ctx = p.getContext() instanceof ExecutionContext ? (ExecutionContext)p.getContext() : new InMemoryExecutionContext();
                p.append(StringUtils.readFully(Remote.this.getInputStream(ctx), StandardCharsets.UTF_8));
                return sourceFile;
            }
        };
    }

    public static class Builder {
        protected final UUID id;
        protected final Path sourcePath;
        protected final Markers markers;
        @Language(value="markdown")
        protected @Nullable String description;
        protected @Nullable Checksum checksum;
        @Nullable Charset charset;
        boolean charsetBomMarked;
        @Nullable FileAttributes fileAttributes;

        Builder(UUID id, Path sourcePath, Markers markers) {
            this.id = id;
            this.sourcePath = sourcePath;
            this.markers = markers;
        }

        public Builder description(@Language(value="markdown") String description) {
            this.description = description;
            return this;
        }

        public Builder charset(Charset charset) {
            this.charset = charset;
            return this;
        }

        public Builder charsetBomMarked(boolean charsetBomMarked) {
            this.charsetBomMarked = charsetBomMarked;
            return this;
        }

        public Builder fileAttributes(FileAttributes fileAttributes) {
            this.fileAttributes = fileAttributes;
            return this;
        }

        public Builder checksum(Checksum checksum) {
            this.checksum = checksum;
            return this;
        }

        public RemoteResource build(InputStream inputStream) {
            return new RemoteResource(this.id, this.sourcePath, this.markers, inputStream, this.charset, this.charsetBomMarked, this.fileAttributes, this.description, this.checksum);
        }

        public RemoteFile build(URI uri) {
            return new RemoteFile(this.id, this.sourcePath, this.markers, uri, this.charset, this.charsetBomMarked, this.fileAttributes, this.description, this.checksum);
        }

        public RemoteArchive build(URI uri, Path path) {
            return new RemoteArchive(this.id, this.sourcePath, this.markers, uri, this.charset, this.charsetBomMarked, this.fileAttributes, this.description, Arrays.asList(path.toString().replace("/", "\\/").replace(".", "\\.").split("!")), this.checksum);
        }

        public RemoteArchive build(URI uri, String ... paths) {
            return new RemoteArchive(this.id, this.sourcePath, this.markers, uri, this.charset, this.charsetBomMarked, this.fileAttributes, this.description, Arrays.asList(paths), this.checksum);
        }
    }
}

