/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.config;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.net.URI;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import lombok.Generated;
import org.intellij.lang.annotations.Language;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Contributor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Maintainer;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.config.DataTableDescriptor;
import org.openrewrite.config.RecipeDescriptor;
import org.openrewrite.config.RecipeIntrospectionException;
import org.openrewrite.internal.lang.NonNull;

public class DeclarativeRecipe
extends ScanningRecipe<Accumulator> {
    private final String name;
    @Language(value="markdown")
    private final String displayName;
    @Language(value="markdown")
    private final @Nullable String description;
    private final Set<String> tags;
    private final @Nullable Duration estimatedEffortPerOccurrence;
    private final URI source;
    private final boolean causesAnotherCycle;
    private final List<Maintainer> maintainers;
    private final List<Recipe> uninitializedRecipes = new ArrayList<Recipe>();
    private List<Recipe> recipeList = new ArrayList<Recipe>();
    private final List<Recipe> uninitializedPreconditions = new ArrayList<Recipe>();
    private List<Recipe> preconditions = new ArrayList<Recipe>();
    @JsonIgnore
    private Validated<Object> validation = Validated.none();
    @JsonIgnore
    private Validated<Object> initValidation = Validated.none();
    @JsonIgnore
    private transient Accumulator accumulator;

    @Override
    public boolean causesAnotherCycle() {
        return this.causesAnotherCycle || super.causesAnotherCycle();
    }

    public void addPrecondition(Recipe recipe) {
        this.uninitializedPreconditions.add(recipe);
    }

    @Override
    public Duration getEstimatedEffortPerOccurrence() {
        return this.estimatedEffortPerOccurrence == null ? Duration.ofMinutes(0L) : this.estimatedEffortPerOccurrence;
    }

    public void initialize(Collection<Recipe> availableRecipes) {
        HashMap recipeMap = new HashMap();
        availableRecipes.forEach(r -> recipeMap.putIfAbsent(r.getName(), r));
        HashSet<String> initializingRecipes = new HashSet<String>();
        this.initialize(this.uninitializedRecipes, this.recipeList, recipeMap::get, initializingRecipes);
        this.initialize(this.uninitializedPreconditions, this.preconditions, recipeMap::get, initializingRecipes);
    }

    @Deprecated
    public void initialize(Collection<Recipe> availableRecipes, Map<String, List<Contributor>> recipeToContributors) {
        this.initialize(availableRecipes);
    }

    public void initialize(Function<String, @Nullable Recipe> availableRecipes) {
        HashSet<String> initializingRecipes = new HashSet<String>();
        this.initialize(this.uninitializedRecipes, this.recipeList, availableRecipes, initializingRecipes);
        this.initialize(this.uninitializedPreconditions, this.preconditions, availableRecipes, initializingRecipes);
    }

    @Deprecated
    public void initialize(Function<String, @Nullable Recipe> availableRecipes, Map<String, List<Contributor>> recipeToContributors) {
        this.initialize(availableRecipes);
    }

    private void initialize(List<Recipe> uninitialized, List<Recipe> initialized, Function<String, @Nullable Recipe> availableRecipes, Set<String> initializingRecipes) {
        initialized.clear();
        for (int i = 0; i < uninitialized.size(); ++i) {
            Recipe recipe = uninitialized.get(i);
            if (recipe instanceof LazyLoadedRecipe) {
                String recipeFqn = ((LazyLoadedRecipe)recipe).getRecipeFqn();
                Recipe subRecipe = availableRecipes.apply(recipeFqn);
                if (subRecipe != null) {
                    if (subRecipe instanceof DeclarativeRecipe) {
                        this.initializeDeclarativeRecipe((DeclarativeRecipe)subRecipe, recipeFqn, availableRecipes, initializingRecipes);
                    }
                    initialized.add(subRecipe);
                    continue;
                }
                this.initValidation = this.initValidation.and(Validated.invalid(this.name + ".recipeList[" + i + "] (in " + this.source + ")", recipeFqn, "recipe '" + recipeFqn + "' does not exist.", null));
                continue;
            }
            if (recipe instanceof DeclarativeRecipe) {
                this.initializeDeclarativeRecipe((DeclarativeRecipe)recipe, recipe.getName(), availableRecipes, initializingRecipes);
            }
            initialized.add(recipe);
        }
    }

    private void initializeDeclarativeRecipe(DeclarativeRecipe declarativeRecipe, String recipeIdentifier, Function<String, @Nullable Recipe> availableRecipes, Set<String> initializingRecipes) {
        String recipeName = declarativeRecipe.getName();
        if (initializingRecipes.contains(recipeName)) {
            String cycle = String.join((CharSequence)" -> ", initializingRecipes) + " -> " + recipeName;
            throw new RecipeIntrospectionException("Recipe '" + recipeIdentifier + "' creates a cycle: " + cycle);
        }
        initializingRecipes.add(recipeName);
        declarativeRecipe.initialize(declarativeRecipe.uninitializedRecipes, declarativeRecipe.recipeList, availableRecipes, initializingRecipes);
        declarativeRecipe.initialize(declarativeRecipe.uninitializedPreconditions, declarativeRecipe.preconditions, availableRecipes, initializingRecipes);
        initializingRecipes.remove(recipeName);
    }

    @Override
    public Accumulator getInitialValue(ExecutionContext ctx) {
        Accumulator acc = new Accumulator();
        for (Recipe precondition : this.preconditions) {
            if (!(precondition instanceof ScanningRecipe) || !DeclarativeRecipe.isScanningRequired(precondition)) continue;
            acc.recipeToAccumulator.put(precondition, ((ScanningRecipe)precondition).getInitialValue(ctx));
        }
        this.accumulator = acc;
        return acc;
    }

    @Override
    public TreeVisitor<?, ExecutionContext> getScanner(final Accumulator acc) {
        return new TreeVisitor<Tree, ExecutionContext>(){

            @Override
            public @Nullable Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                for (Recipe precondition : DeclarativeRecipe.this.preconditions) {
                    if (!(precondition instanceof ScanningRecipe) || !DeclarativeRecipe.isScanningRequired(precondition)) continue;
                    ScanningRecipe preconditionRecipe = (ScanningRecipe)precondition;
                    Object preconditionAcc = acc.recipeToAccumulator.get(precondition);
                    preconditionRecipe.getScanner(preconditionAcc).visit(tree, ctx);
                }
                return tree;
            }
        };
    }

    @Override
    public final List<Recipe> getRecipeList() {
        if (this.preconditions.isEmpty()) {
            return this.recipeList;
        }
        ArrayList<Supplier<TreeVisitor>> andPreconditions = new ArrayList<Supplier<TreeVisitor>>();
        for (Recipe precondition : this.preconditions) {
            andPreconditions.add(() -> this.orVisitors(precondition));
        }
        PreconditionBellwether bellwether = new PreconditionBellwether(Preconditions.and(andPreconditions.toArray(new Supplier[0])));
        ArrayList<Recipe> recipeListWithBellwether = new ArrayList<Recipe>(this.recipeList.size() + 1);
        recipeListWithBellwether.add(bellwether);
        recipeListWithBellwether.addAll(DeclarativeRecipe.decorateWithPreconditionBellwether(bellwether, this.recipeList));
        return recipeListWithBellwether;
    }

    private TreeVisitor<?, ExecutionContext> orVisitors(Recipe recipe) {
        ArrayList conditions = new ArrayList();
        if (recipe instanceof ScanningRecipe) {
            ScanningRecipe scanning = (ScanningRecipe)recipe;
            conditions.add(scanning.getVisitor(this.accumulator.recipeToAccumulator.get(scanning)));
        } else {
            conditions.add(recipe.getVisitor());
        }
        for (Recipe r : recipe.getRecipeList()) {
            conditions.add(this.orVisitors(r));
        }
        if (conditions.size() == 1) {
            return (TreeVisitor)conditions.get(0);
        }
        return Preconditions.or(conditions.toArray(new TreeVisitor[0]));
    }

    private static List<Recipe> decorateWithPreconditionBellwether(PreconditionBellwether bellwether, List<Recipe> recipeList) {
        ArrayList<Recipe> mappedRecipeList = new ArrayList<Recipe>(recipeList.size());
        for (Recipe recipe : recipeList) {
            if (recipe instanceof ScanningRecipe && DeclarativeRecipe.isScanningRequired(recipe)) {
                mappedRecipeList.add(new BellwetherDecoratedScanningRecipe(bellwether, (ScanningRecipe)recipe));
                continue;
            }
            mappedRecipeList.add(new BellwetherDecoratedRecipe(bellwether, recipe));
        }
        return mappedRecipeList;
    }

    private static boolean isScanningRequired(Recipe recipe) {
        if (recipe instanceof ScanningRecipe) {
            if (recipe instanceof DeclarativeRecipe) {
                for (Recipe precondition : ((DeclarativeRecipe)recipe).getPreconditions()) {
                    if (!DeclarativeRecipe.isScanningRequired(precondition)) continue;
                    return true;
                }
            } else {
                return true;
            }
        }
        for (Recipe r : recipe.getRecipeList()) {
            if (!DeclarativeRecipe.isScanningRequired(r)) continue;
            return true;
        }
        return false;
    }

    public void addUninitialized(Recipe recipe) {
        this.uninitializedRecipes.add(recipe);
    }

    public void addUninitialized(String recipeName) {
        this.uninitializedRecipes.add(new LazyLoadedRecipe(recipeName));
    }

    public void addUninitializedPrecondition(Recipe recipe) {
        this.uninitializedPreconditions.add(recipe);
    }

    public void addUninitializedPrecondition(String recipeName) {
        this.uninitializedPreconditions.add(new LazyLoadedRecipe(recipeName));
    }

    public void addValidation(Validated<Object> validated) {
        this.validation = this.validation.and(validated);
    }

    @Override
    public Validated<Object> validate() {
        Validated<Object> validated = Validated.none();
        if (!this.uninitializedRecipes.isEmpty() && this.uninitializedRecipes.size() != this.recipeList.size()) {
            validated = validated.and(Validated.invalid("initialization", this.recipeList, "DeclarativeRecipe must not contain uninitialized recipes. Be sure to call .initialize() on DeclarativeRecipe."));
        }
        if (!this.uninitializedPreconditions.isEmpty() && this.uninitializedPreconditions.size() != this.preconditions.size()) {
            validated = validated.and(Validated.invalid("initialization", this.preconditions, "DeclarativeRecipe must not contain uninitialized preconditions. Be sure to call .initialize() on DeclarativeRecipe."));
        }
        return validated.and(this.validation).and(this.initValidation == null ? Validated.none() : this.initValidation);
    }

    @Override
    protected RecipeDescriptor createRecipeDescriptor() {
        ArrayList<RecipeDescriptor> recipeList = new ArrayList<RecipeDescriptor>();
        for (Recipe childRecipe : this.getRecipeList()) {
            recipeList.add(childRecipe.getDescriptor());
        }
        return new RecipeDescriptor(this.getName(), this.getDisplayName(), this.getInstanceName(), this.getDescription() != null ? this.getDescription() : "", this.getTags(), this.getEstimatedEffortPerOccurrence(), Collections.emptyList(), recipeList, this.getDataTableDescriptors(), this.getMaintainers(), this.getContributors(), this.getExamples(), this.source);
    }

    @Override
    public List<Contributor> getContributors() {
        return Collections.emptyList();
    }

    @Override
    public List<DataTableDescriptor> getDataTableDescriptors() {
        List<DataTableDescriptor> dataTableDescriptors = null;
        for (Recipe recipe : this.getRecipeList()) {
            List<DataTableDescriptor> dtds = recipe.getDataTableDescriptors();
            if (dtds.isEmpty()) continue;
            if (dataTableDescriptors == null) {
                dataTableDescriptors = new ArrayList<DataTableDescriptor>();
            }
            for (DataTableDescriptor dtd : dtds) {
                if (dataTableDescriptors.contains(dtd)) continue;
                dataTableDescriptors.add(dtd);
            }
        }
        return dataTableDescriptors == null ? super.getDataTableDescriptors() : dataTableDescriptors;
    }

    @Generated
    public DeclarativeRecipe(String name, @Language(value="markdown") String displayName, @Language(value="markdown") @Nullable String description, Set<String> tags, @Nullable Duration estimatedEffortPerOccurrence, URI source, boolean causesAnotherCycle, List<Maintainer> maintainers) {
        this.name = name;
        this.displayName = displayName;
        this.description = description;
        this.tags = tags;
        this.estimatedEffortPerOccurrence = estimatedEffortPerOccurrence;
        this.source = source;
        this.causesAnotherCycle = causesAnotherCycle;
        this.maintainers = maintainers;
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }

    @Override
    @Language(value="markdown")
    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    @Language(value="markdown")
    @Generated
    public @Nullable String getDescription() {
        return this.description;
    }

    @Override
    @Generated
    public Set<String> getTags() {
        return this.tags;
    }

    @Override
    @Generated
    public List<Maintainer> getMaintainers() {
        return this.maintainers;
    }

    @Generated
    public void setRecipeList(List<Recipe> recipeList) {
        this.recipeList = recipeList;
    }

    @Generated
    public List<Recipe> getPreconditions() {
        return this.preconditions;
    }

    @Generated
    public void setPreconditions(List<Recipe> preconditions) {
        this.preconditions = preconditions;
    }

    static final class PreconditionBellwether
    extends Recipe {
        private final Supplier<TreeVisitor<?, ExecutionContext>> precondition;
        private transient boolean preconditionApplicable;

        @Override
        public String getDisplayName() {
            return "Precondition bellwether";
        }

        @Override
        public String getDescription() {
            return "Evaluates a precondition and makes that result available to the preconditions of other recipes. \"bellwether\", noun - One that serves as a leader or as a leading indicator of future trends.";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            return new TreeVisitor<Tree, ExecutionContext>(){
                final TreeVisitor<?, ExecutionContext> p;
                {
                    this.p = (TreeVisitor)precondition.get();
                }

                @Override
                public boolean isAcceptable(SourceFile sourceFile, ExecutionContext ctx) {
                    return this.p.isAcceptable(sourceFile, ctx);
                }

                @Override
                public @Nullable Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                    Object t = this.p.visit(tree, ctx);
                    preconditionApplicable = t != tree;
                    return tree;
                }
            };
        }

        @Generated
        public Supplier<TreeVisitor<?, ExecutionContext>> getPrecondition() {
            return this.precondition;
        }

        @Generated
        public boolean isPreconditionApplicable() {
            return this.preconditionApplicable;
        }

        @NonNull
        @Generated
        public String toString() {
            return "DeclarativeRecipe.PreconditionBellwether(precondition=" + this.getPrecondition() + ", preconditionApplicable=" + this.isPreconditionApplicable() + ")";
        }

        @Override
        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PreconditionBellwether)) {
                return false;
            }
            PreconditionBellwether other = (PreconditionBellwether)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Supplier<TreeVisitor<?, ExecutionContext>> this$precondition = this.getPrecondition();
            Supplier<TreeVisitor<?, ExecutionContext>> other$precondition = other.getPrecondition();
            return !(this$precondition == null ? other$precondition != null : !this$precondition.equals(other$precondition));
        }

        @Generated
        protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
            return other instanceof PreconditionBellwether;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Supplier<TreeVisitor<?, ExecutionContext>> $precondition = this.getPrecondition();
            result = result * 59 + ($precondition == null ? 43 : $precondition.hashCode());
            return result;
        }

        @Generated
        public PreconditionBellwether(Supplier<TreeVisitor<?, ExecutionContext>> precondition) {
            this.precondition = precondition;
        }
    }

    private static final class LazyLoadedRecipe
    extends Recipe {
        private final String recipeFqn;

        @Override
        public String getDisplayName() {
            return "Lazy loaded recipe";
        }

        @Override
        public String getDescription() {
            return "Recipe that is loaded lazily.";
        }

        @Generated
        public LazyLoadedRecipe(String recipeFqn) {
            this.recipeFqn = recipeFqn;
        }

        @Generated
        public String getRecipeFqn() {
            return this.recipeFqn;
        }

        @NonNull
        @Generated
        public String toString() {
            return "DeclarativeRecipe.LazyLoadedRecipe(recipeFqn=" + this.getRecipeFqn() + ")";
        }

        @Override
        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LazyLoadedRecipe)) {
                return false;
            }
            LazyLoadedRecipe other = (LazyLoadedRecipe)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$recipeFqn = this.getRecipeFqn();
            String other$recipeFqn = other.getRecipeFqn();
            return !(this$recipeFqn == null ? other$recipeFqn != null : !this$recipeFqn.equals(other$recipeFqn));
        }

        @Generated
        protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
            return other instanceof LazyLoadedRecipe;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $recipeFqn = this.getRecipeFqn();
            result = result * 59 + ($recipeFqn == null ? 43 : $recipeFqn.hashCode());
            return result;
        }
    }

    public static class Accumulator {
        Map<Recipe, Object> recipeToAccumulator = new HashMap<Recipe, Object>();
    }

    static final class BellwetherDecoratedScanningRecipe<T>
    extends ScanningRecipe<T>
    implements Recipe.DelegatingRecipe {
        private final PreconditionBellwether bellwether;
        private final ScanningRecipe<T> delegate;

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public String getDisplayName() {
            return this.delegate.getDisplayName();
        }

        @Override
        public String getDescription() {
            return this.delegate.getDescription();
        }

        @Override
        public T getInitialValue(ExecutionContext ctx) {
            return this.delegate.getInitialValue(ctx);
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getScanner(T acc) {
            return this.delegate.getScanner(acc);
        }

        @Override
        public Collection<? extends SourceFile> generate(T acc, ExecutionContext ctx) {
            return this.delegate.generate(acc, ctx);
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor(T acc) {
            return Preconditions.check(this.bellwether.isPreconditionApplicable(), this.delegate.getVisitor(acc));
        }

        @Override
        public boolean causesAnotherCycle() {
            return this.delegate.causesAnotherCycle();
        }

        @Override
        public List<Recipe> getRecipeList() {
            return DeclarativeRecipe.decorateWithPreconditionBellwether(this.bellwether, this.delegate.getRecipeList());
        }

        @Override
        public Validated<Object> validate() {
            return this.delegate.validate();
        }

        @Generated
        public BellwetherDecoratedScanningRecipe(PreconditionBellwether bellwether, ScanningRecipe<T> delegate) {
            this.bellwether = bellwether;
            this.delegate = delegate;
        }

        @Generated
        public PreconditionBellwether getBellwether() {
            return this.bellwether;
        }

        @Override
        @Generated
        public ScanningRecipe<T> getDelegate() {
            return this.delegate;
        }

        @NonNull
        @Generated
        public String toString() {
            return "DeclarativeRecipe.BellwetherDecoratedScanningRecipe(bellwether=" + this.getBellwether() + ", delegate=" + this.getDelegate() + ")";
        }

        @Override
        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BellwetherDecoratedScanningRecipe)) {
                return false;
            }
            BellwetherDecoratedScanningRecipe other = (BellwetherDecoratedScanningRecipe)o;
            if (!other.canEqual(this)) {
                return false;
            }
            PreconditionBellwether this$bellwether = this.getBellwether();
            PreconditionBellwether other$bellwether = other.getBellwether();
            if (this$bellwether == null ? other$bellwether != null : !((Object)this$bellwether).equals(other$bellwether)) {
                return false;
            }
            Recipe this$delegate = this.getDelegate();
            Recipe other$delegate = other.getDelegate();
            return !(this$delegate == null ? other$delegate != null : !((Object)this$delegate).equals(other$delegate));
        }

        @Generated
        protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
            return other instanceof BellwetherDecoratedScanningRecipe;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            PreconditionBellwether $bellwether = this.getBellwether();
            result = result * 59 + ($bellwether == null ? 43 : ((Object)$bellwether).hashCode());
            Recipe $delegate = this.getDelegate();
            result = result * 59 + ($delegate == null ? 43 : ((Object)$delegate).hashCode());
            return result;
        }
    }

    static final class BellwetherDecoratedRecipe
    extends Recipe
    implements Recipe.DelegatingRecipe {
        private final PreconditionBellwether bellwether;
        private final Recipe delegate;

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public String getDisplayName() {
            return this.delegate.getDisplayName();
        }

        @Override
        public String getDescription() {
            return this.delegate.getDescription();
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            return Preconditions.check(this.bellwether.isPreconditionApplicable(), this.delegate.getVisitor());
        }

        @Override
        public List<Recipe> getRecipeList() {
            return DeclarativeRecipe.decorateWithPreconditionBellwether(this.bellwether, this.delegate.getRecipeList());
        }

        @Override
        public boolean causesAnotherCycle() {
            return this.delegate.causesAnotherCycle();
        }

        @Override
        public Validated<Object> validate() {
            return this.delegate.validate();
        }

        @Generated
        public BellwetherDecoratedRecipe(PreconditionBellwether bellwether, Recipe delegate) {
            this.bellwether = bellwether;
            this.delegate = delegate;
        }

        @Generated
        public PreconditionBellwether getBellwether() {
            return this.bellwether;
        }

        @Override
        @Generated
        public Recipe getDelegate() {
            return this.delegate;
        }

        @NonNull
        @Generated
        public String toString() {
            return "DeclarativeRecipe.BellwetherDecoratedRecipe(bellwether=" + this.getBellwether() + ", delegate=" + this.getDelegate() + ")";
        }

        @Override
        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BellwetherDecoratedRecipe)) {
                return false;
            }
            BellwetherDecoratedRecipe other = (BellwetherDecoratedRecipe)o;
            if (!other.canEqual(this)) {
                return false;
            }
            PreconditionBellwether this$bellwether = this.getBellwether();
            PreconditionBellwether other$bellwether = other.getBellwether();
            if (this$bellwether == null ? other$bellwether != null : !((Object)this$bellwether).equals(other$bellwether)) {
                return false;
            }
            Recipe this$delegate = this.getDelegate();
            Recipe other$delegate = other.getDelegate();
            return !(this$delegate == null ? other$delegate != null : !((Object)this$delegate).equals(other$delegate));
        }

        @Generated
        protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
            return other instanceof BellwetherDecoratedRecipe;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            PreconditionBellwether $bellwether = this.getBellwether();
            result = result * 59 + ($bellwether == null ? 43 : ((Object)$bellwether).hashCode());
            Recipe $delegate = this.getDelegate();
            result = result * 59 + ($delegate == null ? 43 : ((Object)$delegate).hashCode());
            return result;
        }
    }
}

