/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.marketplace;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.openrewrite.Validated;
import org.openrewrite.marketplace.RecipeListing;
import org.openrewrite.marketplace.RecipeMarketplace;

public class RecipeMarketplaceContentValidator {
    public Validated<RecipeMarketplace> validate(RecipeMarketplace marketplace) {
        Validated.None<RecipeMarketplace> validation = Validated.none();
        ArrayList<String> categoryPath = new ArrayList<String>();
        return this.validate(marketplace.getRoot(), validation, categoryPath);
    }

    private Validated<RecipeMarketplace> validate(RecipeMarketplace.Category category, Validated<RecipeMarketplace> validation, List<String> categoryPath) {
        for (RecipeListing recipe : category.getRecipes()) {
            String value = recipe.getName() + (categoryPath.isEmpty() ? "" : categoryPath.stream().collect(Collectors.joining(" > ", "[", "]")));
            validation = validation.and(this.validateDisplayName(validation, recipe.getDisplayName(), value));
            validation = validation.and(this.validateDescription(validation, recipe.getDescription(), value));
        }
        for (RecipeMarketplace.Category child : category.getCategories()) {
            ArrayList<String> nextCategoryPath = new ArrayList<String>(categoryPath);
            nextCategoryPath.add(category.getDisplayName());
            validation = this.validate(child, validation, nextCategoryPath);
        }
        return validation;
    }

    private Validated<RecipeMarketplace> validateDisplayName(Validated<RecipeMarketplace> validation, String displayName, String recipe) {
        String property = recipe + ".displayName";
        if (displayName.isEmpty()) {
            validation = validation.and(Validated.invalid(property, displayName, "Display must not be empty"));
        }
        if (!Character.isUpperCase(displayName.charAt(0))) {
            validation = validation.and(Validated.invalid(property, displayName, "Display name must be sentence cased"));
        }
        if (displayName.endsWith(".")) {
            validation = validation.and(Validated.invalid(property, displayName, "Display name must not end with a period"));
        }
        return validation;
    }

    private Validated<RecipeMarketplace> validateDescription(Validated<RecipeMarketplace> validation, String description, String recipe) {
        if (description.isEmpty()) {
            return validation;
        }
        String property = recipe + ".description";
        if (!Character.isUpperCase(description.charAt(0))) {
            validation = validation.and(Validated.invalid(property, description, "Description must be sentence cased"));
        }
        if (!description.endsWith(".")) {
            validation = validation.and(Validated.invalid(property, description, "Description must end with a period."));
        }
        return validation;
    }
}

