/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.style;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.marker.Markers;
import org.openrewrite.style.NamedStyles;
import org.openrewrite.style.Style;

public class StyleHelper {
    private static final Set<Class<?>> primitiveWrapperClasses = new HashSet();

    private static boolean isPrimitiveOrWrapper(Object value) {
        Class<?> type = value.getClass();
        return type.isPrimitive() || primitiveWrapperClasses.contains(type);
    }

    private static boolean isEnum(Object value) {
        Class<?> type = value.getClass();
        return type.isEnum();
    }

    public static <T> T merge(T left, T right) {
        Class<?> styleClass = left.getClass();
        if (right.getClass() != styleClass) {
            throw new RuntimeException(left.getClass().getName() + " and " + right.getClass().getName() + " should match exactly.");
        }
        for (Field f : styleClass.getDeclaredFields()) {
            Method getter;
            Method wither;
            try {
                wither = styleClass.getMethod("with" + StringUtils.capitalize(f.getName()), f.getType());
                getter = styleClass.getMethod("get" + StringUtils.capitalize(f.getName()), new Class[0]);
            }
            catch (NoSuchMethodException e) {
                continue;
            }
            try {
                Object rightValue = getter.invoke(right, new Object[0]);
                if (rightValue == null) continue;
                if (!StyleHelper.isPrimitiveOrWrapper(rightValue) && !StyleHelper.isEnum(rightValue)) {
                    Object leftValue = getter.invoke(left, new Object[0]);
                    if (leftValue instanceof Collection) {
                        if (!((Collection)leftValue).isEmpty()) {
                            rightValue = StyleHelper.merge(leftValue, rightValue);
                        }
                    } else {
                        rightValue = StyleHelper.merge(leftValue, rightValue);
                    }
                }
                left = wither.invoke(left, rightValue);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return left;
    }

    public static <T extends SourceFile> T addStyleMarker(T t, List<NamedStyles> styles) {
        if (!styles.isEmpty()) {
            HashSet<NamedStyles> newNamedStyles = new HashSet<NamedStyles>(styles);
            boolean styleAlreadyPresent = false;
            for (NamedStyles namedStyle : t.getMarkers().findAll(NamedStyles.class)) {
                styleAlreadyPresent = !newNamedStyles.add(namedStyle) || styleAlreadyPresent;
            }
            if (!styleAlreadyPresent) {
                Markers markers = t.getMarkers().removeByType(NamedStyles.class);
                for (NamedStyles namedStyle : newNamedStyles) {
                    markers = markers.add(namedStyle);
                }
                return (T)((SourceFile)t.withMarkers(markers));
            }
        }
        return t;
    }

    public static <S extends Style> S getStyle(Class<S> styleClass, List<NamedStyles> styles, Supplier<S> defaultStyle) {
        S style = NamedStyles.merge(styleClass, styles);
        if (style != null) {
            return (S)StyleHelper.merge((Style)defaultStyle.get(), style);
        }
        return (S)((Style)defaultStyle.get());
    }

    public static <S extends Style, T extends SourceFile> @Nullable S getStyle(Class<S> styleClass, List<NamedStyles> styles, T sourceFile) {
        S projectStyle = Style.from(styleClass, sourceFile);
        S style = NamedStyles.merge(styleClass, styles);
        if (projectStyle == null) {
            return style;
        }
        if (style != null) {
            return (S)((Style)StyleHelper.merge(projectStyle, style));
        }
        return projectStyle;
    }

    public static <S extends Style, T extends SourceFile> S getStyle(Class<S> styleClass, List<NamedStyles> styles, T sourceFile, Supplier<S> defaultStyle) {
        S projectStyle = Style.from(styleClass, sourceFile, defaultStyle);
        S style = NamedStyles.merge(styleClass, styles);
        if (style != null) {
            return (S)((Style)StyleHelper.merge(projectStyle, style));
        }
        return projectStyle;
    }

    public static <S extends Style> @Nullable S getStyle(Class<S> styleClass, List<NamedStyles> styles) {
        S style = NamedStyles.merge(styleClass, styles);
        if (style != null) {
            return (S)style.applyDefaults();
        }
        return null;
    }

    public static NamedStyles fromStyles(Style ... styles) {
        return new NamedStyles(Tree.randomId(), "MergedStyles", "Merged styles", "Merged styles from " + Arrays.stream(styles).map(Object::getClass).map(Class::getSimpleName).collect(Collectors.joining(", ")), Collections.emptySet(), Arrays.asList(styles));
    }

    static {
        primitiveWrapperClasses.add(Double.class);
        primitiveWrapperClasses.add(Float.class);
        primitiveWrapperClasses.add(Long.class);
        primitiveWrapperClasses.add(Integer.class);
        primitiveWrapperClasses.add(Short.class);
        primitiveWrapperClasses.add(Character.class);
        primitiveWrapperClasses.add(Byte.class);
        primitiveWrapperClasses.add(Boolean.class);
    }
}

