/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.table;

import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Column;
import org.openrewrite.DataTable;
import org.openrewrite.Recipe;
import org.openrewrite.internal.lang.NonNull;

public class SearchResults
extends DataTable<Row> {
    public SearchResults(Recipe recipe) {
        super(recipe, "Source files that had search results", "Search results that were found during the recipe run.");
    }

    public static final class Row {
        @Column(displayName="Source path of search result before the run", description="The source path of the file with the search result markers present.")
        private final @Nullable String sourcePath;
        @Column(displayName="Source path of search result after run the run", description="A recipe may modify the source path. This is the path after the run. `null` when a source file was deleted during the run.")
        private final @Nullable String afterSourcePath;
        @Column(displayName="Result", description="The trimmed printed tree of the LST element that the marker is attached to.")
        private final String result;
        @Column(displayName="Description", description="The content of the description of the marker.")
        private final @Nullable String description;
        @Column(displayName="Recipe that added the search marker", description="The specific recipe that added the Search marker.")
        private final String recipe;

        @Generated
        public Row(@Nullable String sourcePath, @Nullable String afterSourcePath, String result, @Nullable String description, String recipe) {
            this.sourcePath = sourcePath;
            this.afterSourcePath = afterSourcePath;
            this.result = result;
            this.description = description;
            this.recipe = recipe;
        }

        @Generated
        public @Nullable String getSourcePath() {
            return this.sourcePath;
        }

        @Generated
        public @Nullable String getAfterSourcePath() {
            return this.afterSourcePath;
        }

        @Generated
        public String getResult() {
            return this.result;
        }

        @Generated
        public @Nullable String getDescription() {
            return this.description;
        }

        @Generated
        public String getRecipe() {
            return this.recipe;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Row)) {
                return false;
            }
            Row other = (Row)o;
            String this$sourcePath = this.getSourcePath();
            String other$sourcePath = other.getSourcePath();
            if (this$sourcePath == null ? other$sourcePath != null : !this$sourcePath.equals(other$sourcePath)) {
                return false;
            }
            String this$afterSourcePath = this.getAfterSourcePath();
            String other$afterSourcePath = other.getAfterSourcePath();
            if (this$afterSourcePath == null ? other$afterSourcePath != null : !this$afterSourcePath.equals(other$afterSourcePath)) {
                return false;
            }
            String this$result = this.getResult();
            String other$result = other.getResult();
            if (this$result == null ? other$result != null : !this$result.equals(other$result)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                return false;
            }
            String this$recipe = this.getRecipe();
            String other$recipe = other.getRecipe();
            return !(this$recipe == null ? other$recipe != null : !this$recipe.equals(other$recipe));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $sourcePath = this.getSourcePath();
            result = result * 59 + ($sourcePath == null ? 43 : $sourcePath.hashCode());
            String $afterSourcePath = this.getAfterSourcePath();
            result = result * 59 + ($afterSourcePath == null ? 43 : $afterSourcePath.hashCode());
            String $result = this.getResult();
            result = result * 59 + ($result == null ? 43 : $result.hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            String $recipe = this.getRecipe();
            result = result * 59 + ($recipe == null ? 43 : $recipe.hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "SearchResults.Row(sourcePath=" + this.getSourcePath() + ", afterSourcePath=" + this.getAfterSourcePath() + ", result=" + this.getResult() + ", description=" + this.getDescription() + ", recipe=" + this.getRecipe() + ")";
        }
    }
}

