/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.FindSourceFiles;
import org.openrewrite.Option;
import org.openrewrite.Parser;
import org.openrewrite.Preconditions;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.gradle.IsBuildGradle;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.properties.ChangePropertyValue;
import org.openrewrite.properties.PropertiesParser;

public final class AddProperty
extends ScanningRecipe<NeedsProperty> {
    @Option(displayName="Property name", description="The name of the property to add.", example="org.gradle.caching")
    private final String key;
    @Option(example="true", displayName="Property value", description="The value of the property to add.")
    private final String value;
    @Option(displayName="Overwrite if exists", description="If a property with the same key exists, overwrite.", example="true")
    @Nullable
    private final Boolean overwrite;
    @Option(displayName="File pattern", description="A glob expression that can be used to constrain which directories or source files should be searched. When not set, all source files are searched.", example="**/*.properties")
    @Nullable
    private final String filePattern;

    public String getDisplayName() {
        return "Add Gradle property";
    }

    public String getInstanceNameSuffix() {
        return String.format("`%s=%s`", this.key, this.value);
    }

    public String getDescription() {
        return "Add a property to the `gradle.properties` file.";
    }

    public NeedsProperty getInitialValue(ExecutionContext ctx) {
        return new NeedsProperty();
    }

    public TreeVisitor<?, ExecutionContext> getScanner(final NeedsProperty acc) {
        return new TreeVisitor<Tree, ExecutionContext>(){

            public Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                SourceFile sourceFile = (SourceFile)Objects.requireNonNull(tree);
                if (AddProperty.this.filePattern != null) {
                    if (new FindSourceFiles(AddProperty.this.filePattern).getVisitor().visitNonNull(tree, (Object)ctx) != tree && sourceFile.getSourcePath().endsWith("gradle.properties")) {
                        acc.hasGradleProperties = true;
                    }
                } else if (sourceFile.getSourcePath().endsWith("gradle.properties")) {
                    acc.hasGradleProperties = true;
                }
                if (IsBuildGradle.matches(sourceFile.getSourcePath())) {
                    acc.isGradleProject = true;
                }
                return tree;
            }
        };
    }

    public Collection<? extends SourceFile> generate(NeedsProperty acc, ExecutionContext ctx) {
        if (!acc.hasGradleProperties) {
            return PropertiesParser.builder().build().parseInputs(Collections.singletonList(Parser.Input.fromString((Path)Paths.get("gradle.properties", new String[0]), (String)(this.key + "=" + this.value))), null, ctx).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public TreeVisitor<?, ExecutionContext> getVisitor(NeedsProperty acc) {
        return Preconditions.check((acc.isGradleProject && acc.hasGradleProperties ? 1 : 0) != 0, (TreeVisitor)new TreeVisitor<Tree, ExecutionContext>(){

            public Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                SourceFile sourceFile = (SourceFile)Objects.requireNonNull(tree);
                if (AddProperty.this.filePattern != null) {
                    if (new FindSourceFiles(AddProperty.this.filePattern).getVisitor().visitNonNull((Tree)sourceFile, (Object)ctx) != sourceFile && sourceFile.getSourcePath().endsWith("gradle.properties")) {
                        SourceFile t = !Boolean.TRUE.equals(AddProperty.this.overwrite) ? sourceFile : new ChangePropertyValue(AddProperty.this.key, AddProperty.this.value, null, Boolean.valueOf(false), null).getVisitor().visitNonNull((Tree)sourceFile, (Object)ctx);
                        return new org.openrewrite.properties.AddProperty(AddProperty.this.key, AddProperty.this.value, null, null).getVisitor().visitNonNull((Tree)t, (Object)ctx);
                    }
                } else if (sourceFile.getSourcePath().endsWith("gradle.properties")) {
                    SourceFile t = !Boolean.TRUE.equals(AddProperty.this.overwrite) ? sourceFile : new ChangePropertyValue(AddProperty.this.key, AddProperty.this.value, null, Boolean.valueOf(false), null).getVisitor().visitNonNull((Tree)sourceFile, (Object)ctx);
                    return new org.openrewrite.properties.AddProperty(AddProperty.this.key, AddProperty.this.value, null, null).getVisitor().visitNonNull((Tree)t, (Object)ctx);
                }
                return sourceFile;
            }
        });
    }

    @Generated
    public AddProperty(String key, String value, @Nullable Boolean overwrite, @Nullable String filePattern) {
        this.key = key;
        this.value = value;
        this.overwrite = overwrite;
        this.filePattern = filePattern;
    }

    @Generated
    public String getKey() {
        return this.key;
    }

    @Generated
    public String getValue() {
        return this.value;
    }

    @Nullable
    @Generated
    public Boolean getOverwrite() {
        return this.overwrite;
    }

    @Nullable
    @Generated
    public String getFilePattern() {
        return this.filePattern;
    }

    @NonNull
    @Generated
    public String toString() {
        return "AddProperty(key=" + this.getKey() + ", value=" + this.getValue() + ", overwrite=" + this.getOverwrite() + ", filePattern=" + this.getFilePattern() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddProperty)) {
            return false;
        }
        AddProperty other = (AddProperty)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$overwrite = this.getOverwrite();
        Boolean other$overwrite = other.getOverwrite();
        if (this$overwrite == null ? other$overwrite != null : !((Object)this$overwrite).equals(other$overwrite)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        String this$filePattern = this.getFilePattern();
        String other$filePattern = other.getFilePattern();
        return !(this$filePattern == null ? other$filePattern != null : !this$filePattern.equals(other$filePattern));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof AddProperty;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $overwrite = this.getOverwrite();
        result = result * 59 + ($overwrite == null ? 43 : ((Object)$overwrite).hashCode());
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        String $filePattern = this.getFilePattern();
        result = result * 59 + ($filePattern == null ? 43 : $filePattern.hashCode());
        return result;
    }

    public static class NeedsProperty {
        boolean isGradleProject;
        boolean hasGradleProperties;
    }
}

