/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle.search;

import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.gradle.IsBuildGradle;
import org.openrewrite.gradle.table.JVMTestSuitesDefined;
import org.openrewrite.gradle.trait.JvmTestSuite;
import org.openrewrite.gradle.trait.Traits;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.marker.SearchResult;

public final class FindJVMTestSuites
extends Recipe {
    private final transient JVMTestSuitesDefined jvmTestSuitesDefined = new JVMTestSuitesDefined(this);
    @Option(displayName="Insert rows", description="Whether to insert rows into the table. Defaults to true.")
    private final @Nullable Boolean insertRows;

    public String getDisplayName() {
        return "Find Gradle JVMTestSuite plugin configuration";
    }

    public String getDescription() {
        return "Find Gradle JVMTestSuite plugin configurations and produce a data table.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        boolean tableAvailable = this.insertRows == null || this.insertRows != false;
        return Preconditions.check(new IsBuildGradle(), Traits.jvmTestSuite().asVisitor((suite, ctx) -> {
            if (tableAvailable) {
                this.jvmTestSuitesDefined.insertRow((ExecutionContext)ctx, new JVMTestSuitesDefined.Row(suite.getName()));
            }
            return SearchResult.found((Tree)((Statement)suite.getTree()));
        }));
    }

    public static Set<JvmTestSuite> jvmTestSuites(SourceFile sourceFile) {
        if (!IsBuildGradle.matches(sourceFile.getSourcePath())) {
            return Collections.emptySet();
        }
        return Traits.jvmTestSuite().lower(sourceFile).collect(Collectors.toSet());
    }

    @Generated
    public FindJVMTestSuites(@Nullable Boolean insertRows) {
        this.insertRows = insertRows;
    }

    @Generated
    public JVMTestSuitesDefined getJvmTestSuitesDefined() {
        return this.jvmTestSuitesDefined;
    }

    @Generated
    public @Nullable Boolean getInsertRows() {
        return this.insertRows;
    }

    @NonNull
    @Generated
    public String toString() {
        return "FindJVMTestSuites(jvmTestSuitesDefined=" + (Object)((Object)this.getJvmTestSuitesDefined()) + ", insertRows=" + this.getInsertRows() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindJVMTestSuites)) {
            return false;
        }
        FindJVMTestSuites other = (FindJVMTestSuites)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$insertRows = this.getInsertRows();
        Boolean other$insertRows = other.getInsertRows();
        return !(this$insertRows == null ? other$insertRows != null : !((Object)this$insertRows).equals(other$insertRows));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof FindJVMTestSuites;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $insertRows = this.getInsertRows();
        result = result * 59 + ($insertRows == null ? 43 : ((Object)$insertRows).hashCode());
        return result;
    }
}

