/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle.trait;

import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.gradle.marker.GradleProject;
import org.openrewrite.gradle.trait.GradleTraitMatcher;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.trait.Trait;
import org.openrewrite.trait.VisitFunction2;

public final class GradlePlugin
implements Trait<J> {
    private final Cursor cursor;
    private final @Nullable String pluginId;
    private final @Nullable String pluginClass;
    private final @Nullable String version;
    private final boolean applied;

    @Generated
    public GradlePlugin(Cursor cursor, @Nullable String pluginId, @Nullable String pluginClass, @Nullable String version, boolean applied) {
        this.cursor = cursor;
        this.pluginId = pluginId;
        this.pluginClass = pluginClass;
        this.version = version;
        this.applied = applied;
    }

    @Generated
    public Cursor getCursor() {
        return this.cursor;
    }

    @Generated
    public @Nullable String getPluginId() {
        return this.pluginId;
    }

    @Generated
    public @Nullable String getPluginClass() {
        return this.pluginClass;
    }

    @Generated
    public @Nullable String getVersion() {
        return this.version;
    }

    @Generated
    public boolean isApplied() {
        return this.applied;
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GradlePlugin)) {
            return false;
        }
        GradlePlugin other = (GradlePlugin)o;
        if (this.isApplied() != other.isApplied()) {
            return false;
        }
        Cursor this$cursor = this.getCursor();
        Cursor other$cursor = other.getCursor();
        if (this$cursor == null ? other$cursor != null : !this$cursor.equals(other$cursor)) {
            return false;
        }
        String this$pluginId = this.getPluginId();
        String other$pluginId = other.getPluginId();
        if (this$pluginId == null ? other$pluginId != null : !this$pluginId.equals(other$pluginId)) {
            return false;
        }
        String this$pluginClass = this.getPluginClass();
        String other$pluginClass = other.getPluginClass();
        if (this$pluginClass == null ? other$pluginClass != null : !this$pluginClass.equals(other$pluginClass)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        return !(this$version == null ? other$version != null : !this$version.equals(other$version));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isApplied() ? 79 : 97);
        Cursor $cursor = this.getCursor();
        result = result * 59 + ($cursor == null ? 43 : $cursor.hashCode());
        String $pluginId = this.getPluginId();
        result = result * 59 + ($pluginId == null ? 43 : $pluginId.hashCode());
        String $pluginClass = this.getPluginClass();
        result = result * 59 + ($pluginClass == null ? 43 : $pluginClass.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        return result;
    }

    @NonNull
    @Generated
    public String toString() {
        return "GradlePlugin(cursor=" + this.getCursor() + ", pluginId=" + this.getPluginId() + ", pluginClass=" + this.getPluginClass() + ", version=" + this.getVersion() + ", applied=" + this.isApplied() + ")";
    }

    public static class Matcher
    extends GradleTraitMatcher<GradlePlugin> {
        private static final MethodMatcher ALIAS_DSL_MATCHER = new MethodMatcher("* alias(..)", false);
        private static final MethodMatcher APPLY_DSL_MATCHER = new MethodMatcher("* apply(..)", false);
        private static final MethodMatcher PLUGIN_ID_DSL_MATCHER = new MethodMatcher("* id(..)", false);
        private static final MethodMatcher KOTLIN_PLUGIN_DSL_MATCHER = new MethodMatcher("* kotlin(..)", false);
        private static final MethodMatcher PLUGIN_VERSION_DSL_MATCHER = new MethodMatcher("* version(..)", false);
        private static final String[] CORE_PLUGIN_NAMES = new String[]{"java", "java-base", "java-library", "java-platform", "groovy", "scala", "antlr", "jvm-test-suite", "test-report-aggregation", "application", "war", "ear", "maven-publish", "ivy-publish", "distribution", "java-library-distribution", "checkstyle", "pmd", "jacoco", "jacoco-report-aggregation", "codenarc", "eclipse", "eclipse-wtp", "idea", "visual-studio", "xcode", "base", "signing", "java-gradle-plugin", "project-report"};
        protected @Nullable String pluginIdPattern;
        protected @Nullable String pluginClass;
        protected boolean acceptTransitive;

        public Matcher pluginIdPattern(@Nullable String pluginIdPattern) {
            this.pluginIdPattern = pluginIdPattern;
            return this;
        }

        public Matcher pluginClass(@Nullable String pluginClass) {
            this.pluginClass = pluginClass;
            return this;
        }

        public Matcher acceptTransitive(boolean acceptTransitive) {
            this.acceptTransitive = acceptTransitive;
            return this;
        }

        public <P> TreeVisitor<? extends Tree, P> asVisitor(final VisitFunction2<GradlePlugin, P> visitor) {
            return new JavaVisitor<P>(){

                public @Nullable J visit(@Nullable Tree tree, P p) {
                    J j = (J)super.visit(tree, p);
                    if (j instanceof JavaSourceFile) {
                        GradlePlugin plugin = this.test(new Cursor(this.getCursor(), (Object)j));
                        return plugin != null ? (J)visitor.visit((Trait)plugin, p) : j;
                    }
                    return j;
                }

                public J visitIdentifier(J.Identifier ident, P p) {
                    GradlePlugin plugin = this.test(this.getCursor());
                    return plugin != null ? (J)visitor.visit((Trait)plugin, p) : super.visitIdentifier(ident, p);
                }

                public J visitMethodInvocation(J.MethodInvocation method, P p) {
                    GradlePlugin plugin = this.test(this.getCursor());
                    return plugin != null ? (J)visitor.visit((Trait)plugin, p) : super.visitMethodInvocation(method, p);
                }
            };
        }

        protected @Nullable GradlePlugin test(Cursor cursor) {
            Object object = cursor.getValue();
            if (this.acceptTransitive && object instanceof JavaSourceFile) {
                GradleProject gp = this.getGradleProject(cursor);
                if (gp == null) {
                    return null;
                }
                return gp.getPlugins().stream().map(pluginDescriptor -> this.maybeGradlePlugin(cursor, pluginDescriptor.getId(), pluginDescriptor.getFullyQualifiedClassName(), null, true)).findFirst().orElse(null);
            }
            if (object instanceof J.MethodInvocation) {
                J.MethodInvocation m = (J.MethodInvocation)object;
                if (this.withinPlugins(cursor)) {
                    if (ALIAS_DSL_MATCHER.matches(m, true)) {
                        if (!(m.getArguments().get(0) instanceof J.FieldAccess)) {
                            return null;
                        }
                        return this.maybeGradlePlugin(cursor, null, null, null, true);
                    }
                    if (APPLY_DSL_MATCHER.matches(m, true)) {
                        if (!(m.getArguments().get(0) instanceof J.Literal) || !(m.getSelect() instanceof J.MethodInvocation)) {
                            return null;
                        }
                        J.MethodInvocation versionSelect = (J.MethodInvocation)m.getSelect();
                        if (!(PLUGIN_VERSION_DSL_MATCHER.matches(versionSelect, true) && versionSelect.getArguments().get(0) instanceof J.Literal && versionSelect.getSelect() instanceof J.MethodInvocation)) {
                            return null;
                        }
                        J.MethodInvocation idSelect = (J.MethodInvocation)versionSelect.getSelect();
                        if (!PLUGIN_ID_DSL_MATCHER.matches(idSelect, true) && !KOTLIN_PLUGIN_DSL_MATCHER.matches(idSelect, true) || !(idSelect.getArguments().get(0) instanceof J.Literal)) {
                            return null;
                        }
                        J.Literal idLiteral = (J.Literal)idSelect.getArguments().get(0);
                        J.Literal versionLiteral = (J.Literal)versionSelect.getArguments().get(0);
                        J.Literal applyLiteral = (J.Literal)m.getArguments().get(0);
                        String pluginId = "kotlin".equals(idSelect.getSimpleName()) ? "org.jetbrains.kotlin." + idLiteral.getValue() : (String)idLiteral.getValue();
                        String version = (String)versionLiteral.getValue();
                        boolean applied = Boolean.TRUE.equals(applyLiteral.getValue());
                        return this.maybeGradlePlugin(cursor, pluginId, null, version, applied);
                    }
                    if (PLUGIN_VERSION_DSL_MATCHER.matches(m, true)) {
                        String version = null;
                        if (m.getArguments().get(0) instanceof J.Literal) {
                            J.Literal versionLiteral = (J.Literal)m.getArguments().get(0);
                            version = (String)versionLiteral.getValue();
                        }
                        if (!(m.getSelect() instanceof J.MethodInvocation) || !PLUGIN_ID_DSL_MATCHER.matches((J.MethodInvocation)m.getSelect(), true) && !KOTLIN_PLUGIN_DSL_MATCHER.matches((J.MethodInvocation)m.getSelect(), true)) {
                            return null;
                        }
                        J.MethodInvocation select = (J.MethodInvocation)m.getSelect();
                        if (!(select.getArguments().get(0) instanceof J.Literal)) {
                            return null;
                        }
                        J.Literal idLiteral = (J.Literal)select.getArguments().get(0);
                        String pluginId = "kotlin".equals(select.getSimpleName()) ? "org.jetbrains.kotlin." + idLiteral.getValue() : (String)idLiteral.getValue();
                        return this.maybeGradlePlugin(cursor, pluginId, null, version, !this.withinBlock(cursor, "pluginManagement"));
                    }
                    if (PLUGIN_ID_DSL_MATCHER.matches(m, true) || KOTLIN_PLUGIN_DSL_MATCHER.matches(m, true)) {
                        if (!(m.getArguments().get(0) instanceof J.Literal)) {
                            return null;
                        }
                        J.Literal literal = (J.Literal)m.getArguments().get(0);
                        String pluginId = "kotlin".equals(m.getSimpleName()) ? "org.jetbrains.kotlin." + literal.getValue() : (String)literal.getValue();
                        return this.maybeGradlePlugin(cursor, pluginId, null, null, !this.withinBlock(cursor, "pluginManagement"));
                    }
                } else if (this.isProjectReceiver(cursor) && APPLY_DSL_MATCHER.matches(m, true)) {
                    Expression e = (Expression)m.getArguments().get(0);
                    if (e instanceof G.MapEntry) {
                        G.MapEntry entry = (G.MapEntry)e;
                        if (!(entry.getKey() instanceof J.Literal) || !"plugin".equals(((J.Literal)entry.getKey()).getValue())) {
                            return null;
                        }
                        if (entry.getValue() instanceof J.Literal) {
                            String pluginId = (String)((J.Literal)entry.getValue()).getValue();
                            return this.maybeGradlePlugin(cursor, pluginId, null, null, true);
                        }
                        if (entry.getValue() instanceof J.FieldAccess || entry.getValue() instanceof J.Identifier) {
                            return this.maybeGradlePlugin(cursor, null, null, null, true);
                        }
                    } else {
                        if (e instanceof J.Assignment) {
                            J.Assignment assignment = (J.Assignment)e;
                            if (!(assignment.getVariable() instanceof J.Identifier && "plugin".equals(((J.Identifier)assignment.getVariable()).getSimpleName()) && assignment.getAssignment() instanceof J.Literal)) {
                                return null;
                            }
                            J.Literal literal = (J.Literal)assignment.getAssignment();
                            String pluginId = (String)literal.getValue();
                            return this.maybeGradlePlugin(cursor, pluginId, null, null, true);
                        }
                        if (m.getTypeParameters() != null && !m.getTypeParameters().isEmpty() && (m.getTypeParameters().get(0) instanceof J.FieldAccess || m.getTypeParameters().get(0) instanceof J.Identifier)) {
                            return this.maybeGradlePlugin(cursor, null, null, null, true);
                        }
                    }
                }
            } else if (this.withinPlugins(cursor) && object instanceof J.Identifier) {
                J.Identifier i = (J.Identifier)object;
                String maybePluginId = i.getSimpleName();
                if (!this.isCorePlugin(maybePluginId)) {
                    return null;
                }
                return this.maybeGradlePlugin(cursor, maybePluginId, null, null, true);
            }
            return null;
        }

        private boolean withinPlugins(Cursor cursor) {
            Cursor parent = cursor.dropParentUntil(value -> value instanceof J.MethodInvocation || value == "root");
            if (parent.isRoot() || !"plugins".equals(((J.MethodInvocation)parent.getValue()).getSimpleName())) {
                return false;
            }
            return (parent = parent.dropParentUntil(value -> value instanceof J.MethodInvocation || value == "root")).isRoot() || "pluginManagement".equals(((J.MethodInvocation)parent.getValue()).getSimpleName());
        }

        private boolean isProjectReceiver(Cursor cursor) {
            Cursor parent = cursor.dropParentUntil(value -> value instanceof J.MethodInvocation || value == "root");
            if (parent.isRoot()) {
                return true;
            }
            J.MethodInvocation m = (J.MethodInvocation)parent.getValue();
            switch (m.getSimpleName()) {
                case "allprojects": 
                case "subprojects": 
                case "configure": {
                    return true;
                }
            }
            return false;
        }

        private boolean isCorePlugin(String pluginId) {
            for (String pluginName : CORE_PLUGIN_NAMES) {
                if (!pluginName.equals(pluginId)) continue;
                return true;
            }
            return false;
        }

        private @Nullable GradlePlugin maybeGradlePlugin(Cursor cursor, @Nullable String pluginId, @Nullable String pluginClass, @Nullable String version, boolean applied) {
            if (!StringUtils.isBlank((String)this.pluginIdPattern) && !StringUtils.matchesGlob((String)pluginId, (String)this.pluginIdPattern) || !StringUtils.isBlank((String)this.pluginClass) && !StringUtils.matchesGlob((String)pluginClass, (String)this.pluginClass)) {
                return null;
            }
            return new GradlePlugin(cursor, pluginId, pluginClass, version, applied);
        }
    }
}

