/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle.search;

import java.util.StringJoiner;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.PathUtils;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.gradle.IsBuildGradle;
import org.openrewrite.gradle.marker.GradleProject;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.maven.search.EffectiveMavenRepositoriesTable;
import org.openrewrite.maven.tree.MavenRepository;

public final class EffectiveGradleRepositories
extends Recipe {
    @Option(displayName="Use markers", description="Whether to add markers for each effective Gradle repository to the build file. Default `false`.", required=false)
    private final @Nullable Boolean useMarkers;
    private final transient EffectiveMavenRepositoriesTable table = new EffectiveMavenRepositoriesTable((Recipe)this);

    public String getDisplayName() {
        return "List effective Gradle project repositories";
    }

    public String getDescription() {
        return "Lists the Gradle project repositories that would be used for dependency resolution, in order of precedence. This includes Maven repositories defined in the Gradle build files and settings as determined when the LST was produced.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check(new IsBuildGradle(), (TreeVisitor)new TreeVisitor<Tree, ExecutionContext>(){

            public Tree preVisit(Tree tree, ExecutionContext ctx) {
                this.stopAfterPreVisit();
                if (!(tree instanceof SourceFile)) {
                    return tree;
                }
                SourceFile sourceFile = (SourceFile)tree;
                StringJoiner repositories = new StringJoiner("\n");
                String path = PathUtils.separatorsToUnix((String)sourceFile.getSourcePath().toString());
                GradleProject gradleProject = sourceFile.getMarkers().findFirst(GradleProject.class).orElse(null);
                if (gradleProject != null) {
                    for (MavenRepository repository : gradleProject.getMavenRepositories()) {
                        repositories.add(repository.getUri());
                        EffectiveGradleRepositories.this.table.insertRow(ctx, (Object)new EffectiveMavenRepositoriesTable.Row(path, repository.getUri()));
                    }
                }
                if (Boolean.TRUE.equals(EffectiveGradleRepositories.this.useMarkers) && repositories.length() > 0) {
                    return SearchResult.found((Tree)sourceFile, (String)repositories.toString());
                }
                return sourceFile;
            }
        });
    }

    @Generated
    public EffectiveGradleRepositories(@Nullable Boolean useMarkers) {
        this.useMarkers = useMarkers;
    }

    @Generated
    public @Nullable Boolean getUseMarkers() {
        return this.useMarkers;
    }

    @Generated
    public EffectiveMavenRepositoriesTable getTable() {
        return this.table;
    }

    @NonNull
    @Generated
    public String toString() {
        return "EffectiveGradleRepositories(useMarkers=" + this.getUseMarkers() + ", table=" + this.getTable() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EffectiveGradleRepositories)) {
            return false;
        }
        EffectiveGradleRepositories other = (EffectiveGradleRepositories)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$useMarkers = this.getUseMarkers();
        Boolean other$useMarkers = other.getUseMarkers();
        return !(this$useMarkers == null ? other$useMarkers != null : !((Object)this$useMarkers).equals(other$useMarkers));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof EffectiveGradleRepositories;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $useMarkers = this.getUseMarkers();
        result = result * 59 + ($useMarkers == null ? 43 : ((Object)$useMarkers).hashCode());
        return result;
    }
}

