/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.hcl.tree;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collections;
import java.util.List;
import java.util.function.UnaryOperator;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.hcl.tree.Hcl;
import org.openrewrite.hcl.tree.HclRightPadded;
import org.openrewrite.hcl.tree.Space;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.marker.Markers;

public class HclContainer<T> {
    private transient Padding<T> padding;
    private static final HclContainer<?> EMPTY = new HclContainer(Space.EMPTY, Collections.emptyList(), Markers.EMPTY);
    private final Space before;
    private final List<HclRightPadded<T>> elements;
    private final Markers markers;

    private HclContainer(Space before, List<HclRightPadded<T>> elements, Markers markers) {
        this.before = before;
        this.elements = elements;
        this.markers = markers;
    }

    public static <T> HclContainer<T> build(List<HclRightPadded<T>> elements) {
        return HclContainer.build(Space.EMPTY, elements, Markers.EMPTY);
    }

    @JsonCreator
    public static <T> HclContainer<T> build(Space before, List<HclRightPadded<T>> elements, Markers markers) {
        if (before.isEmpty() && elements.isEmpty()) {
            return HclContainer.empty();
        }
        return new HclContainer<T>(before, elements, markers);
    }

    public static <T> HclContainer<T> empty() {
        return EMPTY;
    }

    public HclContainer<T> withBefore(Space before) {
        return this.getBefore() == before ? this : HclContainer.build(before, this.elements, this.markers);
    }

    public HclContainer<T> withMarkers(Markers markers) {
        return this.getMarkers() == markers ? this : HclContainer.build(this.before, this.elements, markers);
    }

    public Markers getMarkers() {
        return this.markers;
    }

    public List<T> getElements() {
        return HclRightPadded.getElements(this.elements);
    }

    public Space getBefore() {
        return this.before;
    }

    public HclContainer<T> map(UnaryOperator<T> map) {
        return this.getPadding().withElements(ListUtils.map(this.elements, t -> t.map(map)));
    }

    public Space getLastSpace() {
        return this.elements.isEmpty() ? Space.EMPTY : this.elements.get(this.elements.size() - 1).getAfter();
    }

    public HclContainer<T> withLastSpace(Space space) {
        List newElements = ListUtils.map(this.elements, (i, elem) -> {
            if (i == this.elements.size() - 1) {
                return elem.withAfter(space);
            }
            return elem;
        });
        return this.elements.isEmpty() || this.getLastSpace() == space ? this : HclContainer.build(this.before, newElements, this.markers);
    }

    public Padding<T> getPadding() {
        if (this.padding == null) {
            this.padding = new Padding(this);
        }
        return this.padding;
    }

    public static <H extends Hcl> @Nullable HclContainer<H> withElementsNullable(@Nullable HclContainer<H> before, @Nullable List<H> elements) {
        if (before == null) {
            if (elements == null || elements.isEmpty()) {
                return null;
            }
            return HclContainer.build(Space.EMPTY, HclRightPadded.withElements(Collections.emptyList(), elements), Markers.EMPTY);
        }
        if (elements == null || elements.isEmpty()) {
            return null;
        }
        return before.getPadding().withElements(HclRightPadded.withElements(before.elements, elements));
    }

    public static <H extends Hcl> HclContainer<H> withElements(HclContainer<H> before, @Nullable List<H> elements) {
        if (elements == null) {
            return before.getPadding().withElements(Collections.emptyList());
        }
        return before.getPadding().withElements(HclRightPadded.withElements(before.elements, elements));
    }

    public String toString() {
        return "HclContainer(before=" + this.before + ", elementCount=" + this.elements.size() + ')';
    }

    public static class Padding<T> {
        private final HclContainer<T> c;

        public List<HclRightPadded<T>> getElements() {
            return ((HclContainer)this.c).elements;
        }

        public HclContainer<T> withElements(List<HclRightPadded<T>> elements) {
            return ((HclContainer)this.c).elements == elements ? this.c : HclContainer.build(((HclContainer)this.c).before, elements, ((HclContainer)this.c).markers);
        }

        @Generated
        public Padding(HclContainer<T> c) {
            this.c = c;
        }
    }

    public static enum Location {
        FOR_VARIABLES(Space.Location.FOR_VARIABLES, HclRightPadded.Location.FOR_VARIABLE_ARGUMENT),
        FUNCTION_CALL_ARGUMENTS(Space.Location.FUNCTION_CALL_ARGUMENTS, HclRightPadded.Location.FUNCTION_CALL_ARGUMENT),
        OBJECT_VALUE_ATTRIBUTES(Space.Location.OBJECT_VALUE_ATTRIBUTES, HclRightPadded.Location.OBJECT_VALUE_ARGUMENT),
        TUPLE_VALUES(Space.Location.TUPLE_VALUES, HclRightPadded.Location.TUPLE_VALUE);

        private final Space.Location beforeLocation;
        private final HclRightPadded.Location elementLocation;

        private Location(Space.Location beforeLocation, HclRightPadded.Location elementLocation) {
            this.beforeLocation = beforeLocation;
            this.elementLocation = elementLocation;
        }

        public Space.Location getBeforeLocation() {
            return this.beforeLocation;
        }

        public HclRightPadded.Location getElementLocation() {
            return this.elementLocation;
        }
    }
}

