/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.lang.reflect.Constructor;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Collection;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.SourceFile;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaUnrestrictedClassLoader;
import org.openrewrite.java.internal.JavaTypeCache;

public class Java21Parser
implements JavaParser {
    private final JavaParser delegate;

    Java21Parser(JavaParser delegate) {
        this.delegate = delegate;
    }

    public Stream<SourceFile> parseInputs(Iterable<Parser.Input> sourceFiles, @Nullable Path relativeTo, ExecutionContext ctx) {
        return this.delegate.parseInputs(sourceFiles, relativeTo, ctx);
    }

    public JavaParser reset() {
        this.delegate.reset();
        return this;
    }

    public JavaParser reset(Collection<URI> cus) {
        this.delegate.reset(cus);
        return this;
    }

    public void setClasspath(Collection<Path> classpath) {
        this.delegate.setClasspath(classpath);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends JavaParser.Builder<Java21Parser, Builder> {
        private static @Nullable ClassLoader moduleClassLoader;

        static synchronized void lazyInitClassLoaders() {
            if (moduleClassLoader != null) {
                return;
            }
            ClassLoader appClassLoader = Java21Parser.class.getClassLoader();
            moduleClassLoader = new JavaUnrestrictedClassLoader(appClassLoader);
        }

        public Java21Parser build() {
            Builder.lazyInitClassLoaders();
            try {
                Class<?> parserImplementation = Class.forName("org.openrewrite.java.isolated.ReloadableJava21Parser", true, moduleClassLoader);
                Constructor<?> parserConstructor = parserImplementation.getDeclaredConstructor(Boolean.TYPE, Collection.class, Collection.class, Collection.class, Charset.class, Collection.class, JavaTypeCache.class);
                parserConstructor.setAccessible(true);
                JavaParser delegate = (JavaParser)parserConstructor.newInstance(this.logCompilationWarningsAndErrors, this.resolvedClasspath(), this.classBytesClasspath, this.dependsOn, this.charset, this.styles, this.javaTypeCache);
                return new Java21Parser(delegate);
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to construct Java21Parser.", e);
            }
        }
    }
}

