/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.SourceFile;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.table.TypeMappings;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypedTree;

public final class FindTypeMappings
extends ScanningRecipe<Map<TypeAssociation, Integer>> {
    private final transient TypeMappings typeMappingsPerSource = new TypeMappings((Recipe)this);

    public String getDisplayName() {
        return "Find type mappings";
    }

    public String getDescription() {
        return "Study the frequency of `J` types and their `JavaType` type attribution.";
    }

    public Map<TypeAssociation, Integer> getInitialValue(ExecutionContext ctx) {
        return new HashMap<TypeAssociation, Integer>();
    }

    public TreeVisitor<?, ExecutionContext> getScanner(final Map<TypeAssociation, Integer> acc) {
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            @Nullable
            public JavaType visitType(@Nullable JavaType javaType, ExecutionContext ctx) {
                Cursor cursor = this.getCursor();
                acc.compute(new TypeAssociation(((JavaSourceFile)cursor.firstEnclosingOrThrow(JavaSourceFile.class)).getClass(), cursor.getValue().getClass(), javaType == null ? null : javaType.getClass(), javaType == null ? (Class)cursor.getPathAsStream().filter(t -> t instanceof TypedTree && ((TypedTree)t).getType() != null).findFirst().map(Object::getClass).orElse(null) : null), (k, v) -> v == null ? 1 : v + 1);
                return javaType;
            }
        };
    }

    public Collection<? extends SourceFile> generate(Map<TypeAssociation, Integer> acc, ExecutionContext ctx) {
        acc.forEach((assoc, count) -> {
            String j = assoc.getJ().getName();
            Class<?> nearJ = assoc.getNearestNonNullJ();
            this.typeMappingsPerSource.insertRow(ctx, new TypeMappings.Row(assoc.getCompilationUnit().getEnclosingClass().getSimpleName(), j.substring(j.lastIndexOf(46) + 1), assoc.getJavaType() == null ? "null" : assoc.getJavaType().getSimpleName(), (Integer)count, nearJ == null ? null : nearJ.getName().substring(nearJ.getName().lastIndexOf(46) + 1)));
        });
        return Collections.emptyList();
    }

    public TypeMappings getTypeMappingsPerSource() {
        return this.typeMappingsPerSource;
    }

    @NonNull
    public String toString() {
        return "FindTypeMappings(typeMappingsPerSource=" + (Object)((Object)this.getTypeMappingsPerSource()) + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindTypeMappings)) {
            return false;
        }
        FindTypeMappings other = (FindTypeMappings)((Object)o);
        return other.canEqual((Object)this);
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof FindTypeMappings;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public static final class TypeAssociation {
        private final Class<? extends JavaSourceFile> compilationUnit;
        private final Class<?> j;
        @Nullable
        private final Class<? extends JavaType> javaType;
        @Nullable
        private final Class<?> nearestNonNullJ;

        public TypeAssociation(Class<? extends JavaSourceFile> compilationUnit, Class<?> j, @Nullable Class<? extends JavaType> javaType, @Nullable Class<?> nearestNonNullJ) {
            this.compilationUnit = compilationUnit;
            this.j = j;
            this.javaType = javaType;
            this.nearestNonNullJ = nearestNonNullJ;
        }

        public Class<? extends JavaSourceFile> getCompilationUnit() {
            return this.compilationUnit;
        }

        public Class<?> getJ() {
            return this.j;
        }

        @Nullable
        public Class<? extends JavaType> getJavaType() {
            return this.javaType;
        }

        @Nullable
        public Class<?> getNearestNonNullJ() {
            return this.nearestNonNullJ;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TypeAssociation)) {
                return false;
            }
            TypeAssociation other = (TypeAssociation)o;
            Class<? extends JavaSourceFile> this$compilationUnit = this.getCompilationUnit();
            Class<? extends JavaSourceFile> other$compilationUnit = other.getCompilationUnit();
            if (this$compilationUnit == null ? other$compilationUnit != null : !this$compilationUnit.equals(other$compilationUnit)) {
                return false;
            }
            Class<?> this$j = this.getJ();
            Class<?> other$j = other.getJ();
            if (this$j == null ? other$j != null : !this$j.equals(other$j)) {
                return false;
            }
            Class<? extends JavaType> this$javaType = this.getJavaType();
            Class<? extends JavaType> other$javaType = other.getJavaType();
            if (this$javaType == null ? other$javaType != null : !this$javaType.equals(other$javaType)) {
                return false;
            }
            Class<?> this$nearestNonNullJ = this.getNearestNonNullJ();
            Class<?> other$nearestNonNullJ = other.getNearestNonNullJ();
            return !(this$nearestNonNullJ == null ? other$nearestNonNullJ != null : !this$nearestNonNullJ.equals(other$nearestNonNullJ));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Class<? extends JavaSourceFile> $compilationUnit = this.getCompilationUnit();
            result = result * 59 + ($compilationUnit == null ? 43 : $compilationUnit.hashCode());
            Class<?> $j = this.getJ();
            result = result * 59 + ($j == null ? 43 : $j.hashCode());
            Class<? extends JavaType> $javaType = this.getJavaType();
            result = result * 59 + ($javaType == null ? 43 : $javaType.hashCode());
            Class<?> $nearestNonNullJ = this.getNearestNonNullJ();
            result = result * 59 + ($nearestNonNullJ == null ? 43 : $nearestNonNullJ.hashCode());
            return result;
        }

        @NonNull
        public String toString() {
            return "FindTypeMappings.TypeAssociation(compilationUnit=" + this.getCompilationUnit() + ", j=" + this.getJ() + ", javaType=" + this.getJavaType() + ", nearestNonNullJ=" + this.getNearestNonNullJ() + ")";
        }
    }
}

