/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.tree.Comment;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.Space;

public class TreeVisitingPrinter
extends TreeVisitor<Tree, ExecutionContext> {
    private static final String TAB = "    ";
    private static final String ELEMENT_PREFIX = "\\---";
    private static final String CONTINUE_PREFIX = "----";
    private static final String UNVISITED_PREFIX = "#";
    private static final char BRANCH_CONTINUE_CHAR = '|';
    private static final char BRANCH_END_CHAR = '\\';
    private static final int CONTENT_MAX_LENGTH = 120;
    private List<Object> lastCursorStack = new ArrayList<Object>();
    private final List<StringBuilder> outputLines = new ArrayList<StringBuilder>();
    private final boolean skipUnvisitedElement;

    protected TreeVisitingPrinter(boolean skipUnvisitedElement) {
        this.skipUnvisitedElement = skipUnvisitedElement;
    }

    public static String printTree(Cursor cursor) {
        return TreeVisitingPrinter.findRootOfJType(cursor).map(TreeVisitingPrinter::printTree).orElse("");
    }

    public static String printTree(Tree tree) {
        TreeVisitingPrinter visitor = new TreeVisitingPrinter(true);
        visitor.visit(tree, (ExecutionContext)new InMemoryExecutionContext());
        return visitor.print();
    }

    public static String printTreeAll(Cursor cursor) {
        return TreeVisitingPrinter.findRootOfJType(cursor).map(TreeVisitingPrinter::printTreeAll).orElse("");
    }

    public static String printTreeAll(Tree tree) {
        TreeVisitingPrinter visitor = new TreeVisitingPrinter(false);
        visitor.visit(tree, (ExecutionContext)new InMemoryExecutionContext());
        return visitor.print();
    }

    private static Optional<Tree> findRootOfJType(Cursor cursor) {
        List cursorStack = StreamSupport.stream(Spliterators.spliteratorUnknownSize(cursor.getPath(), 0), false).collect(Collectors.toList());
        Collections.reverse(cursorStack);
        return cursorStack.stream().filter(Tree.class::isInstance).map(Tree.class::cast).findFirst();
    }

    private String print() {
        return String.join((CharSequence)"\n", this.outputLines);
    }

    private static String leftPadding(int depth) {
        StringBuilder sb = new StringBuilder();
        int tabCount = depth - 1;
        if (tabCount > 0) {
            sb.append(String.join((CharSequence)"", Collections.nCopies(tabCount, TAB)));
        }
        if (depth > 0) {
            sb.append(ELEMENT_PREFIX);
        }
        return sb.toString();
    }

    private void connectToLatestSibling(int depth) {
        StringBuilder line;
        if (depth <= 1) {
            return;
        }
        int pos = (depth - 1) * TAB.length();
        for (int i = this.outputLines.size() - 1; i > 0 && pos < (line = this.outputLines.get(i)).length(); --i) {
            if (line.charAt(pos) != ' ') {
                if (line.charAt(pos) != '\\') break;
                line.setCharAt(pos, '|');
                break;
            }
            line.setCharAt(pos, '|');
        }
    }

    private static String printTreeElement(Tree tree) {
        if (tree instanceof J.CompilationUnit || tree instanceof J.ClassDeclaration || tree instanceof J.Block || tree instanceof J.Empty || tree instanceof J.Try || tree instanceof J.Try.Catch || tree instanceof J.ForLoop || tree instanceof J.WhileLoop || tree instanceof J.DoWhileLoop || tree instanceof J.Lambda || tree instanceof J.Lambda.Parameters || tree instanceof J.If || tree instanceof J.EnumValueSet || tree instanceof J.TypeParameter) {
            return "";
        }
        if (tree instanceof J.Literal) {
            String s = ((J.Literal)tree).getValueSource();
            return s != null ? s : "";
        }
        String precedingComments = tree instanceof J ? TreeVisitingPrinter.printComments(((J)tree).getPrefix().getComments()) : "";
        String[] lines = (precedingComments + tree).split("\n");
        StringBuilder output = new StringBuilder();
        for (int i = 0; i < lines.length; ++i) {
            output.append(lines[i].trim());
            if (i >= lines.length - 1) continue;
            output.append(" ");
        }
        return output.toString();
    }

    private String truncate(String content) {
        if (content.length() > 120) {
            return content.substring(0, 117) + "...";
        }
        return content;
    }

    private static String printSpace(Space space) {
        StringBuilder sb = new StringBuilder();
        sb.append(" whitespace=\"").append(space.getWhitespace()).append("\"");
        sb.append(" comments=\"").append(TreeVisitingPrinter.printComments(space.getComments())).append("\"");
        return sb.toString().replace("\n", "\\s\n");
    }

    private static String printComments(List<Comment> comments) {
        return comments.stream().map(c -> c.printComment(new Cursor(null, (Object)"root"))).collect(Collectors.joining(","));
    }

    public @Nullable Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
        String typeName;
        if (tree == null) {
            return super.visit((Tree)null, (Object)ctx);
        }
        Cursor cursor = this.getCursor();
        List cursorStack = StreamSupport.stream(Spliterators.spliteratorUnknownSize(cursor.getPath(), 0), false).collect(Collectors.toList());
        Collections.reverse(cursorStack);
        int depth = cursorStack.size();
        int diffPos = -1;
        for (int i = 0; i < cursorStack.size(); ++i) {
            if (i < this.lastCursorStack.size() && cursorStack.get(i) == this.lastCursorStack.get(i)) continue;
            diffPos = i;
            break;
        }
        StringBuilder line = new StringBuilder();
        if (diffPos >= 0) {
            for (int i = diffPos; i < cursorStack.size(); ++i) {
                Object element = cursorStack.get(i);
                if (this.skipUnvisitedElement) {
                    if (i == diffPos) {
                        line.append(TreeVisitingPrinter.leftPadding(i));
                        this.connectToLatestSibling(i);
                        continue;
                    }
                    line.append(CONTINUE_PREFIX);
                    continue;
                }
                this.connectToLatestSibling(i);
                StringBuilder newLine = new StringBuilder().append(TreeVisitingPrinter.leftPadding(i)).append(UNVISITED_PREFIX).append(element instanceof String ? element : element.getClass().getSimpleName());
                if (element instanceof JRightPadded) {
                    JRightPadded rp = (JRightPadded)element;
                    newLine.append(" | ");
                    newLine.append(" after = ").append(TreeVisitingPrinter.printSpace(rp.getAfter()));
                }
                if (element instanceof JLeftPadded) {
                    JLeftPadded lp = (JLeftPadded)element;
                    newLine.append(" | ");
                    newLine.append(" before = ").append(TreeVisitingPrinter.printSpace(lp.getBefore()));
                }
                this.outputLines.add(newLine);
            }
        }
        String string = typeName = tree instanceof J ? tree.getClass().getCanonicalName().substring(tree.getClass().getPackage().getName().length() + 1) : tree.getClass().getCanonicalName();
        if (this.skipUnvisitedElement) {
            boolean leftPadded;
            boolean bl = leftPadded = diffPos >= 0;
            if (leftPadded) {
                line.append(CONTINUE_PREFIX);
            } else {
                this.connectToLatestSibling(depth);
                line.append(TreeVisitingPrinter.leftPadding(depth));
            }
            line.append(typeName);
        } else {
            this.connectToLatestSibling(depth);
            line.append(TreeVisitingPrinter.leftPadding(depth)).append(typeName);
        }
        String content = this.truncate(TreeVisitingPrinter.printTreeElement(tree));
        if (!content.isEmpty()) {
            line.append(" | \"").append(content).append("\"");
        }
        this.outputLines.add(line);
        cursorStack.add(tree);
        this.lastCursorStack = cursorStack;
        return super.visit(tree, (Object)ctx);
    }
}

