/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.tools.checkstyle.api;

import java.util.concurrent.atomic.AtomicInteger;
import org.openrewrite.tools.checkstyle.api.AuditEvent;
import org.openrewrite.tools.checkstyle.api.AuditListener;
import org.openrewrite.tools.checkstyle.api.SeverityLevel;

public final class SeverityLevelCounter
implements AuditListener {
    private final SeverityLevel level;
    private final AtomicInteger count = new AtomicInteger();

    public SeverityLevelCounter(SeverityLevel level) {
        if (level == null) {
            throw new IllegalArgumentException("'level' cannot be null");
        }
        this.level = level;
    }

    @Override
    public void addError(AuditEvent event) {
        if (this.level == event.getSeverityLevel()) {
            this.count.incrementAndGet();
        }
    }

    @Override
    public void addException(AuditEvent event, Throwable throwable) {
        if (this.level == SeverityLevel.ERROR) {
            this.count.incrementAndGet();
        }
    }

    @Override
    public void auditStarted(AuditEvent event) {
        this.count.set(0);
    }

    @Override
    public void fileStarted(AuditEvent event) {
    }

    @Override
    public void auditFinished(AuditEvent event) {
    }

    @Override
    public void fileFinished(AuditEvent event) {
    }

    public int getCount() {
        return this.count.get();
    }
}

