/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.tools.checkstyle.checks.annotation;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openrewrite.tools.checkstyle.StatelessCheck;
import org.openrewrite.tools.checkstyle.api.AbstractCheck;
import org.openrewrite.tools.checkstyle.api.DetailAST;
import org.openrewrite.tools.checkstyle.api.TextBlock;
import org.openrewrite.tools.checkstyle.checks.javadoc.JavadocTagInfo;
import org.openrewrite.tools.checkstyle.utils.AnnotationUtil;
import org.openrewrite.tools.checkstyle.utils.CommonUtil;

@StatelessCheck
public final class MissingOverrideCheck
extends AbstractCheck {
    public static final String MSG_KEY_TAG_NOT_VALID_ON = "tag.not.valid.on";
    public static final String MSG_KEY_ANNOTATION_MISSING_OVERRIDE = "annotation.missing.override";
    private static final String OVERRIDE = "Override";
    private static final String FQ_OVERRIDE = "java.lang.Override";
    private static final Pattern MATCH_INHERIT_DOC = CommonUtil.createPattern("\\{\\s*@(inheritDoc)\\s*\\}");
    private boolean javaFiveCompatibility;

    public void setJavaFiveCompatibility(boolean compatibility) {
        this.javaFiveCompatibility = compatibility;
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{9};
    }

    @Override
    public void visitToken(DetailAST ast) {
        TextBlock javadoc = this.getFileContents().getJavadocBefore(ast.getLineNo());
        boolean containsTag = MissingOverrideCheck.containsJavadocTag(javadoc);
        if (containsTag && !JavadocTagInfo.INHERIT_DOC.isValidOn(ast)) {
            this.log(ast, MSG_KEY_TAG_NOT_VALID_ON, JavadocTagInfo.INHERIT_DOC.getText());
        } else {
            DetailAST defOrNew;
            boolean check = true;
            if (this.javaFiveCompatibility && ((defOrNew = ast.getParent().getParent()).findFirstToken(18) != null || defOrNew.findFirstToken(19) != null || defOrNew.getType() == 136)) {
                check = false;
            }
            if (check && containsTag && !AnnotationUtil.containsAnnotation(ast, OVERRIDE) && !AnnotationUtil.containsAnnotation(ast, FQ_OVERRIDE)) {
                this.log(ast, MSG_KEY_ANNOTATION_MISSING_OVERRIDE, new Object[0]);
            }
        }
    }

    private static boolean containsJavadocTag(TextBlock javadoc) {
        boolean javadocTag = false;
        if (javadoc != null) {
            String[] lines;
            for (String line : lines = javadoc.getText()) {
                Matcher matchInheritDoc = MATCH_INHERIT_DOC.matcher(line);
                if (!matchInheritDoc.find()) continue;
                javadocTag = true;
                break;
            }
        }
        return javadocTag;
    }
}

