/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.tools.checkstyle.checks.coding;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.openrewrite.tools.checkstyle.StatelessCheck;
import org.openrewrite.tools.checkstyle.api.AbstractCheck;
import org.openrewrite.tools.checkstyle.api.DetailAST;
import org.openrewrite.tools.checkstyle.api.FullIdent;
import org.openrewrite.tools.checkstyle.utils.CheckUtil;

@StatelessCheck
public final class IllegalCatchCheck
extends AbstractCheck {
    public static final String MSG_KEY = "illegal.catch";
    private final Set<String> illegalClassNames = Arrays.stream(new String[]{"Exception", "Error", "RuntimeException", "Throwable", "java.lang.Error", "java.lang.Exception", "java.lang.RuntimeException", "java.lang.Throwable"}).collect(Collectors.toSet());

    public void setIllegalClassNames(String ... classNames) {
        this.illegalClassNames.clear();
        this.illegalClassNames.addAll(CheckUtil.parseClassNames(classNames));
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{96};
    }

    @Override
    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public void visitToken(DetailAST detailAST) {
        DetailAST parameterDef = detailAST.findFirstToken(21);
        DetailAST excTypeParent = parameterDef.findFirstToken(13);
        for (DetailAST currentNode = excTypeParent.getFirstChild(); currentNode != null; currentNode = currentNode.getNextSibling()) {
            FullIdent ident = FullIdent.createFullIdent(currentNode);
            if (!this.illegalClassNames.contains(ident.getText())) continue;
            this.log(detailAST, MSG_KEY, ident.getText());
        }
    }
}

