/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.tools.checkstyle.checks.design;

import org.openrewrite.tools.checkstyle.StatelessCheck;
import org.openrewrite.tools.checkstyle.api.AbstractCheck;
import org.openrewrite.tools.checkstyle.api.DetailAST;

@StatelessCheck
public final class ThrowsCountCheck
extends AbstractCheck {
    public static final String MSG_KEY = "throws.count";
    private static final int DEFAULT_MAX = 4;
    private boolean ignorePrivateMethods = true;
    private int max = 4;

    @Override
    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{81};
    }

    @Override
    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    public void setIgnorePrivateMethods(boolean ignorePrivateMethods) {
        this.ignorePrivateMethods = ignorePrivateMethods;
    }

    public void setMax(int max) {
        this.max = max;
    }

    @Override
    public void visitToken(DetailAST ast) {
        if (ast.getType() != 81) {
            throw new IllegalStateException(ast.toString());
        }
        this.visitLiteralThrows(ast);
    }

    private void visitLiteralThrows(DetailAST ast) {
        int count;
        if (!(this.ignorePrivateMethods && ThrowsCountCheck.isInPrivateMethod(ast) || ThrowsCountCheck.isOverriding(ast) || (count = (ast.getChildCount() + 1) / 2) <= this.max)) {
            this.log(ast, MSG_KEY, count, this.max);
        }
    }

    private static boolean isOverriding(DetailAST ast) {
        DetailAST modifiers = ast.getParent().findFirstToken(5);
        boolean isOverriding = false;
        for (DetailAST child = modifiers.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getType() != 159 || !"Override".equals(ThrowsCountCheck.getAnnotationName(child))) continue;
            isOverriding = true;
            break;
        }
        return isOverriding;
    }

    private static String getAnnotationName(DetailAST annotation) {
        DetailAST dotAst = annotation.findFirstToken(59);
        String name = dotAst == null ? annotation.findFirstToken(58).getText() : dotAst.findFirstToken(58).getText();
        return name;
    }

    private static boolean isInPrivateMethod(DetailAST ast) {
        DetailAST methodModifiers = ast.getParent().findFirstToken(5);
        return methodModifiers.findFirstToken(61) != null;
    }
}

