/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.tools.checkstyle.checks.indentation;

import org.openrewrite.tools.checkstyle.api.DetailAST;
import org.openrewrite.tools.checkstyle.checks.indentation.AbstractExpressionHandler;
import org.openrewrite.tools.checkstyle.checks.indentation.BlockParentHandler;
import org.openrewrite.tools.checkstyle.checks.indentation.CatchHandler;
import org.openrewrite.tools.checkstyle.checks.indentation.FinallyHandler;
import org.openrewrite.tools.checkstyle.checks.indentation.IndentLevel;
import org.openrewrite.tools.checkstyle.checks.indentation.IndentationCheck;
import org.openrewrite.tools.checkstyle.checks.indentation.NewHandler;

public class TryHandler
extends BlockParentHandler {
    public TryHandler(IndentationCheck indentCheck, DetailAST ast, AbstractExpressionHandler parent) {
        super(indentCheck, "try", ast, parent);
    }

    private DetailAST getTryResLparen() {
        return this.getMainAst().getFirstChild().getFirstChild();
    }

    private DetailAST getTryResRparen() {
        return this.getMainAst().getFirstChild().getLastChild();
    }

    @Override
    public IndentLevel getSuggestedChildIndent(AbstractExpressionHandler child) {
        IndentLevel result = child instanceof CatchHandler || child instanceof FinallyHandler || child instanceof NewHandler && TryHandler.isTryBlocksResourceSpecification(child) ? this.getIndent() : super.getSuggestedChildIndent(child);
        return result;
    }

    @Override
    public void checkIndentation() {
        super.checkIndentation();
        if (this.getMainAst().getFirstChild().getType() == 176) {
            this.checkTryResParen(this.getTryResLparen(), "lparen");
            this.checkTryResParen(this.getTryResRparen(), "rparen");
            this.checkTryResources(this.getMainAst().getFirstChild());
        }
    }

    private void checkTryResParen(DetailAST parenAst, String subType) {
        if (this.isOnStartOfLine(parenAst)) {
            IndentLevel expectedIdent = new IndentLevel(this.getIndent(), 0, this.getIndentCheck().getLineWrappingIndentation());
            this.checkChildIndentation(parenAst, subType, expectedIdent);
        }
    }

    private void checkChildIndentation(DetailAST ast, String subType, IndentLevel expectedIdent) {
        if (this.getIndentCheck().isForceStrictCondition()) {
            if (!expectedIdent.isAcceptable(this.expandedTabsColumnNo(ast))) {
                this.logError(ast, subType, this.expandedTabsColumnNo(ast), expectedIdent);
            }
        } else if (this.expandedTabsColumnNo(ast) < expectedIdent.getFirstIndentLevel()) {
            this.logError(ast, subType, this.expandedTabsColumnNo(ast), expectedIdent);
        }
    }

    private void checkTryResources(DetailAST resourcesSpecAst) {
        DetailAST resourcesAst = resourcesSpecAst.findFirstToken(177);
        int indentation = this.getIndent().getFirstIndentLevel() + this.getIndentCheck().getLineWrappingIndentation();
        IndentLevel expectedResourceIndent = new IndentLevel(indentation);
        String subType = "resource";
        for (DetailAST resourceAst = resourcesAst.getFirstChild(); resourceAst != null; resourceAst = resourceAst.getNextSibling()) {
            if (resourceAst.getType() != 178) continue;
            DetailAST nextSibling = resourceAst.getNextSibling() == null ? this.getTryResRparen() : resourceAst.getNextSibling();
            if (this.isOnStartOfLine(resourceAst)) {
                this.checkChildIndentation(resourceAst, "resource", expectedResourceIndent);
                this.checkWrappingIndentation(resourceAst, nextSibling, this.getIndentCheck().getLineWrappingIndentation(), expectedResourceIndent.getFirstIndentLevel(), true);
                continue;
            }
            this.checkWrappingIndentation(resourceAst, nextSibling);
        }
    }

    private static boolean isTryBlocksResourceSpecification(AbstractExpressionHandler expression) {
        boolean isResourceSpecificationExpression = false;
        DetailAST ast = expression.getMainAst();
        while (ast.getType() != 95) {
            if (ast.getType() == 176) {
                isResourceSpecificationExpression = true;
                break;
            }
            ast = ast.getParent();
        }
        return isResourceSpecificationExpression;
    }
}

