/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.tools.checkstyle.checks.javadoc;

import java.util.regex.Pattern;
import org.openrewrite.tools.checkstyle.StatelessCheck;
import org.openrewrite.tools.checkstyle.api.AbstractCheck;
import org.openrewrite.tools.checkstyle.api.DetailAST;
import org.openrewrite.tools.checkstyle.api.FileContents;
import org.openrewrite.tools.checkstyle.api.Scope;
import org.openrewrite.tools.checkstyle.api.TextBlock;
import org.openrewrite.tools.checkstyle.utils.ScopeUtil;

@StatelessCheck
public class JavadocVariableCheck
extends AbstractCheck {
    public static final String MSG_JAVADOC_MISSING = "javadoc.missing";
    private Scope scope = Scope.PRIVATE;
    private Scope excludeScope;
    private Pattern ignoreNamePattern;

    public void setScope(Scope scope) {
        this.scope = scope;
    }

    public void setExcludeScope(Scope excludeScope) {
        this.excludeScope = excludeScope;
    }

    public void setIgnoreNamePattern(Pattern pattern) {
        this.ignoreNamePattern = pattern;
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{10, 155};
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{10};
    }

    @Override
    public void visitToken(DetailAST ast) {
        FileContents contents;
        TextBlock textBlock;
        if (this.shouldCheck(ast) && (textBlock = (contents = this.getFileContents()).getJavadocBefore(ast.getLineNo())) == null) {
            this.log(ast, MSG_JAVADOC_MISSING, new Object[0]);
        }
    }

    private boolean isIgnored(DetailAST ast) {
        String name = ast.findFirstToken(58).getText();
        return this.ignoreNamePattern != null && this.ignoreNamePattern.matcher(name).matches() || "serialVersionUID".equals(name);
    }

    private boolean shouldCheck(DetailAST ast) {
        boolean result = false;
        if (!ScopeUtil.isInCodeBlock(ast) && !this.isIgnored(ast)) {
            Scope customScope = ScopeUtil.getScope(ast);
            Scope surroundingScope = ScopeUtil.getSurroundingScope(ast);
            result = customScope.isIn(this.scope) && surroundingScope.isIn(this.scope) && (this.excludeScope == null || !customScope.isIn(this.excludeScope) || !surroundingScope.isIn(this.excludeScope));
        }
        return result;
    }
}

