/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.tools.checkstyle.utils;

import java.util.Optional;
import org.openrewrite.tools.checkstyle.api.DetailAST;
import org.openrewrite.tools.checkstyle.api.Scope;
import org.openrewrite.tools.checkstyle.utils.TokenUtil;

public final class ScopeUtil {
    private ScopeUtil() {
    }

    public static Scope getDeclaredScopeFromMods(DetailAST aMods) {
        Scope result = null;
        for (DetailAST token = aMods.getFirstChild(); token != null; token = token.getNextSibling()) {
            if ("public".equals(token.getText())) {
                result = Scope.PUBLIC;
                continue;
            }
            if ("protected".equals(token.getText())) {
                result = Scope.PROTECTED;
                continue;
            }
            if (!"private".equals(token.getText())) continue;
            result = Scope.PRIVATE;
        }
        return result;
    }

    public static Scope getScope(DetailAST ast) {
        return Optional.ofNullable(ast.findFirstToken(5)).map(ScopeUtil::getDeclaredScopeFromMods).orElseGet(() -> ScopeUtil.getDefaultScope(ast));
    }

    public static Scope getScopeFromMods(DetailAST aMods) {
        return Optional.ofNullable(ScopeUtil.getDeclaredScopeFromMods(aMods)).orElseGet(() -> ScopeUtil.getDefaultScope(aMods.getParent()));
    }

    private static Scope getDefaultScope(DetailAST ast) {
        Scope result = ScopeUtil.isInEnumBlock(ast) ? (ast.getType() == 155 ? Scope.PUBLIC : (ast.getType() == 8 ? Scope.PRIVATE : Scope.PACKAGE)) : (ScopeUtil.isInInterfaceOrAnnotationBlock(ast) ? Scope.PUBLIC : Scope.PACKAGE);
        return result;
    }

    public static Scope getSurroundingScope(DetailAST node) {
        Scope returnValue = null;
        for (DetailAST token = node.getParent(); token != null; token = token.getParent()) {
            int type = token.getType();
            if (TokenUtil.isTypeDeclaration(type)) {
                Scope tokenScope = ScopeUtil.getScope(token);
                if (returnValue != null && !returnValue.isIn(tokenScope)) continue;
                returnValue = tokenScope;
                continue;
            }
            if (type != 136) continue;
            returnValue = Scope.ANONINNER;
            break;
        }
        return returnValue;
    }

    public static boolean isInClassBlock(DetailAST node) {
        return ScopeUtil.isInBlockOf(node, 14);
    }

    public static boolean isInRecordBlock(DetailAST node) {
        return ScopeUtil.isInBlockOf(node, 199);
    }

    public static boolean isInInterfaceBlock(DetailAST node) {
        return ScopeUtil.isInBlockOf(node, 15);
    }

    public static boolean isInAnnotationBlock(DetailAST node) {
        return ScopeUtil.isInBlockOf(node, 157);
    }

    private static boolean isInBlockOf(DetailAST node, int tokenType) {
        boolean returnValue = false;
        for (DetailAST token = node.getParent(); token != null && !returnValue; token = token.getParent()) {
            if (token.getType() == tokenType) {
                returnValue = true;
                continue;
            }
            if (token.getType() == 136 || TokenUtil.isTypeDeclaration(token.getType())) break;
        }
        return returnValue;
    }

    public static boolean isInInterfaceOrAnnotationBlock(DetailAST node) {
        return ScopeUtil.isInInterfaceBlock(node) || ScopeUtil.isInAnnotationBlock(node);
    }

    public static boolean isInEnumBlock(DetailAST node) {
        boolean returnValue = false;
        for (DetailAST token = node.getParent(); token != null && !returnValue; token = token.getParent()) {
            if (token.getType() == 154) {
                returnValue = true;
                continue;
            }
            if (TokenUtil.isOfType(token, 15, 157, 14, 136)) break;
        }
        return returnValue;
    }

    public static boolean isInCodeBlock(DetailAST node) {
        boolean returnValue = false;
        int[] tokenTypes = new int[]{9, 8, 11, 12, 181, 203};
        for (DetailAST token = node.getParent(); token != null; token = token.getParent()) {
            if (!TokenUtil.isOfType(token, tokenTypes)) continue;
            returnValue = true;
            break;
        }
        return returnValue;
    }

    public static boolean isOuterMostType(DetailAST node) {
        boolean returnValue = true;
        for (DetailAST parent = node.getParent(); parent != null; parent = parent.getParent()) {
            if (!TokenUtil.isTypeDeclaration(parent.getType())) continue;
            returnValue = false;
            break;
        }
        return returnValue;
    }

    public static boolean isLocalVariableDef(DetailAST node) {
        DetailAST parent;
        boolean localVariableDef = false;
        if (node.getType() == 10) {
            parent = node.getParent();
            localVariableDef = TokenUtil.isOfType(parent, 7, 35, 156);
        }
        if (node.getType() == 21) {
            parent = node.getParent();
            boolean bl = localVariableDef = parent.getType() == 96;
        }
        if (node.getType() == 178) {
            localVariableDef = node.getChildCount() > 1;
        }
        return localVariableDef;
    }

    public static boolean isClassFieldDef(DetailAST node) {
        return node.getType() == 10 && !ScopeUtil.isLocalVariableDef(node);
    }

    public static boolean isInScope(DetailAST ast, Scope scope) {
        Scope surroundingScopeOfAstToken = ScopeUtil.getSurroundingScope(ast);
        return surroundingScopeOfAstToken == scope;
    }
}

