/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.table.MethodCalls;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.marker.SearchResult;

public final class FindDistinctMethods
extends ScanningRecipe<Map<String, UUID>> {
    private final transient MethodCalls methodCalls = new MethodCalls((Recipe)this);
    @Option(displayName="Method pattern", description="A [method pattern](https://docs.openrewrite.org/reference/method-patterns) is used to find matching method invocations. For example, to find all method invocations in the Guava library, use the pattern: `com.google.common..*#*(..)`.<br/><br/>The pattern format is `<PACKAGE>#<METHOD_NAME>(<ARGS>)`. <br/><br/>`..*` includes all subpackages of `com.google.common`. <br/>`*(..)` matches any method name with any number of arguments. <br/><br/>For more specific queries, like Guava's `ImmutableMap`, use `com.google.common.collect.ImmutableMap#*(..)` to narrow down the results.", example="java.util.List add(..)", required=false)
    private final @Nullable String methodPattern;
    @Option(displayName="Match on overrides", description="When enabled, find methods that are overrides of the method pattern.", required=false)
    private final @Nullable Boolean matchOverrides;

    public String getDisplayName() {
        return "Find distinct methods in use";
    }

    public String getDescription() {
        return "A sample of every distinct method in use in a repository. The code sample in the method calls data table will be a representative use of the method, though there may be many other such uses of the method.";
    }

    public Validated<Object> validate() {
        return super.validate().and(MethodMatcher.validate(this.methodPattern));
    }

    public Map<String, UUID> getInitialValue(ExecutionContext ctx) {
        return new LinkedHashMap<String, UUID>();
    }

    public TreeVisitor<?, ExecutionContext> getScanner(final Map<String, UUID> acc) {
        return Preconditions.check(new UsesMethod(this.getMethodPattern(), this.matchOverrides), (TreeVisitor)new JavaVisitor<ExecutionContext>(){
            final MethodMatcher methodMatcher;
            {
                this.methodMatcher = new MethodMatcher(FindDistinctMethods.this.getMethodPattern(), FindDistinctMethods.this.matchOverrides);
            }

            @Override
            public J visitExpression(Expression expression, ExecutionContext ctx) {
                MethodCall methodCall;
                if (expression instanceof MethodCall && this.methodMatcher.matches(methodCall = (MethodCall)expression) && methodCall.getMethodType() != null) {
                    acc.computeIfAbsent(methodCall.getMethodType().toString(), signature -> expression.getId());
                }
                return super.visitExpression(expression, ctx);
            }
        });
    }

    public TreeVisitor<?, ExecutionContext> getVisitor(final Map<String, UUID> acc) {
        return Preconditions.check(new UsesMethod(this.getMethodPattern(), this.matchOverrides), (TreeVisitor)new JavaVisitor<ExecutionContext>(){
            final MethodMatcher methodMatcher;
            {
                this.methodMatcher = new MethodMatcher(FindDistinctMethods.this.getMethodPattern(), FindDistinctMethods.this.matchOverrides);
            }

            @Override
            public J visitExpression(Expression expression, ExecutionContext ctx) {
                MethodCall methodCall;
                J e = super.visitExpression(expression, ctx);
                if (expression instanceof MethodCall && this.methodMatcher.matches(methodCall = (MethodCall)expression) && methodCall.getMethodType() != null) {
                    String key = methodCall.getMethodType().toString();
                    if (methodCall.getId().equals(acc.get(key))) {
                        Cursor methodCursor = this.getCursor();
                        FindDistinctMethods.this.methodCalls.insertRow(ctx, new MethodCalls.Row(((SourceFile)methodCursor.firstEnclosingOrThrow(SourceFile.class)).getSourcePath().toString(), methodCall.printTrimmed(methodCursor), Objects.requireNonNull(methodCall.getMethodType()).getDeclaringType().getFullyQualifiedName(), methodCall.getMethodType().getName(), methodCall.getMethodType().getParameterTypes().stream().map(Object::toString).collect(Collectors.joining(","))));
                        acc.remove(key);
                        e = (J)SearchResult.found((Tree)e);
                    }
                }
                return e;
            }
        });
    }

    private String getMethodPattern() {
        return this.methodPattern == null ? "*..* *(..)" : this.methodPattern;
    }

    @Generated
    public FindDistinctMethods(@Nullable String methodPattern, @Nullable Boolean matchOverrides) {
        this.methodPattern = methodPattern;
        this.matchOverrides = matchOverrides;
    }

    @Generated
    public MethodCalls getMethodCalls() {
        return this.methodCalls;
    }

    @Generated
    public @Nullable Boolean getMatchOverrides() {
        return this.matchOverrides;
    }

    @NonNull
    @Generated
    public String toString() {
        return "FindDistinctMethods(methodCalls=" + (Object)((Object)this.getMethodCalls()) + ", methodPattern=" + this.getMethodPattern() + ", matchOverrides=" + this.getMatchOverrides() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindDistinctMethods)) {
            return false;
        }
        FindDistinctMethods other = (FindDistinctMethods)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$matchOverrides = this.getMatchOverrides();
        Boolean other$matchOverrides = other.getMatchOverrides();
        if (this$matchOverrides == null ? other$matchOverrides != null : !((Object)this$matchOverrides).equals(other$matchOverrides)) {
            return false;
        }
        String this$methodPattern = this.getMethodPattern();
        String other$methodPattern = other.getMethodPattern();
        return !(this$methodPattern == null ? other$methodPattern != null : !this$methodPattern.equals(other$methodPattern));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof FindDistinctMethods;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $matchOverrides = this.getMatchOverrides();
        result = result * 59 + ($matchOverrides == null ? 43 : ((Object)$matchOverrides).hashCode());
        String $methodPattern = this.getMethodPattern();
        result = result * 59 + ($methodPattern == null ? 43 : $methodPattern.hashCode());
        return result;
    }
}

