/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.tools.checkstyle;

import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import org.antlr.v4.runtime.Token;
import org.openrewrite.tools.checkstyle.api.DetailAST;
import org.openrewrite.tools.checkstyle.utils.TokenUtil;

public final class DetailAstImpl
implements DetailAST {
    private static final int NOT_INITIALIZED = Integer.MIN_VALUE;
    private int lineNo = Integer.MIN_VALUE;
    private int columnNo = Integer.MIN_VALUE;
    private int childCount = Integer.MIN_VALUE;
    private DetailAstImpl parent;
    private DetailAstImpl previousSibling;
    private DetailAstImpl firstChild;
    private DetailAstImpl nextSibling;
    private String text;
    private int type;
    private List<Token> hiddenBefore;
    private List<Token> hiddenAfter;
    private BitSet branchTokenTypes;

    public void initialize(int tokenType, String tokenText) {
        this.type = tokenType;
        this.text = tokenText;
    }

    public void initialize(Token token) {
        this.text = token.getText();
        this.type = token.getType();
        this.lineNo = token.getLine();
        this.columnNo = token.getCharPositionInLine();
    }

    public void addPreviousSibling(DetailAST ast) {
        this.clearBranchTokenTypes();
        DetailAstImpl.clearChildCountCache(this.parent);
        if (ast != null) {
            DetailAstImpl previousSiblingNode = this.previousSibling;
            DetailAstImpl astImpl = (DetailAstImpl)ast;
            if (previousSiblingNode != null) {
                astImpl.previousSibling = previousSiblingNode;
                previousSiblingNode.setNextSibling(astImpl);
            } else if (this.parent != null) {
                this.parent.setFirstChild(astImpl);
            }
            astImpl.setNextSibling(this);
            this.previousSibling = astImpl;
        }
    }

    public void addNextSibling(DetailAST ast) {
        this.clearBranchTokenTypes();
        DetailAstImpl.clearChildCountCache(this.parent);
        if (ast != null) {
            DetailAstImpl sibling = this.nextSibling;
            DetailAstImpl astImpl = (DetailAstImpl)ast;
            if (sibling != null) {
                astImpl.setNextSibling(sibling);
                sibling.previousSibling = astImpl;
            }
            astImpl.previousSibling = this;
            this.setNextSibling(astImpl);
        }
    }

    public void addChild(DetailAST child) {
        DetailAST temp;
        this.clearBranchTokenTypes();
        DetailAstImpl.clearChildCountCache(this);
        if (child != null) {
            DetailAstImpl astImpl = (DetailAstImpl)child;
            astImpl.setParent(this);
            astImpl.previousSibling = (DetailAstImpl)this.getLastChild();
        }
        if ((temp = this.firstChild) == null) {
            this.firstChild = (DetailAstImpl)child;
        } else {
            while (temp.getNextSibling() != null) {
                temp = temp.getNextSibling();
            }
            temp.setNextSibling(child);
        }
    }

    @Override
    public int getChildCount() {
        if (this.childCount == Integer.MIN_VALUE) {
            this.childCount = 0;
            for (DetailAST child = this.firstChild; child != null; child = child.getNextSibling()) {
                ++this.childCount;
            }
        }
        return this.childCount;
    }

    @Override
    public int getChildCount(int tokenType) {
        int count = 0;
        for (DetailAST ast = this.firstChild; ast != null; ast = ast.getNextSibling()) {
            if (ast.getType() != tokenType) continue;
            ++count;
        }
        return count;
    }

    private void setParent(DetailAstImpl parent) {
        DetailAstImpl instance = this;
        do {
            instance.clearBranchTokenTypes();
            instance.parent = parent;
        } while ((instance = instance.nextSibling) != null);
    }

    @Override
    public DetailAST getParent() {
        return this.parent;
    }

    @Override
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    @Override
    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    @Override
    public int getLineNo() {
        int resultNo = -1;
        if (this.lineNo == Integer.MIN_VALUE && (resultNo = DetailAstImpl.findLineNo(this.firstChild)) == -1) {
            resultNo = DetailAstImpl.findLineNo(this.nextSibling);
        }
        if (resultNo == -1) {
            resultNo = this.lineNo;
        }
        return resultNo;
    }

    public void setLineNo(int lineNo) {
        this.lineNo = lineNo;
    }

    @Override
    public int getColumnNo() {
        int resultNo = -1;
        if (this.columnNo == Integer.MIN_VALUE && (resultNo = DetailAstImpl.findColumnNo(this.firstChild)) == -1) {
            resultNo = DetailAstImpl.findColumnNo(this.nextSibling);
        }
        if (resultNo == -1) {
            resultNo = this.columnNo;
        }
        return resultNo;
    }

    public void setColumnNo(int columnNo) {
        this.columnNo = columnNo;
    }

    @Override
    public DetailAST getLastChild() {
        DetailAstImpl ast = this.firstChild;
        while (ast != null && ast.nextSibling != null) {
            ast = ast.nextSibling;
        }
        return ast;
    }

    private static int findColumnNo(DetailAST ast) {
        int resultNo = -1;
        for (DetailAST node = ast; node != null; node = node.getNextSibling()) {
            if (TokenUtil.isCommentType(node.getType())) {
                continue;
            }
            resultNo = node.getColumnNo();
            break;
        }
        return resultNo;
    }

    private static int findLineNo(DetailAST ast) {
        int resultNo = -1;
        for (DetailAST node = ast; node != null; node = node.getNextSibling()) {
            if (TokenUtil.isCommentType(node.getType())) {
                continue;
            }
            resultNo = node.getLineNo();
            break;
        }
        return resultNo;
    }

    private BitSet getBranchTokenTypes() {
        if (this.branchTokenTypes == null) {
            this.branchTokenTypes = new BitSet();
            this.branchTokenTypes.set(this.type);
            DetailAstImpl child = this.firstChild;
            while (child != null) {
                BitSet childTypes = child.getBranchTokenTypes();
                this.branchTokenTypes.or(childTypes);
                child = child.nextSibling;
            }
        }
        return this.branchTokenTypes;
    }

    @Override
    public boolean branchContains(int tokenType) {
        return this.getBranchTokenTypes().get(tokenType);
    }

    @Override
    public DetailAST getPreviousSibling() {
        return this.previousSibling;
    }

    @Override
    public DetailAST findFirstToken(int tokenType) {
        DetailAstImpl returnValue = null;
        for (DetailAST ast = this.firstChild; ast != null; ast = ast.getNextSibling()) {
            if (ast.getType() != tokenType) continue;
            returnValue = ast;
            break;
        }
        return returnValue;
    }

    public String toString() {
        return this.text + "[" + this.getLineNo() + "x" + this.getColumnNo() + "]";
    }

    @Override
    public DetailAstImpl getNextSibling() {
        return this.nextSibling;
    }

    @Override
    public DetailAstImpl getFirstChild() {
        return this.firstChild;
    }

    @Override
    public int getNumberOfChildren() {
        return this.getChildCount();
    }

    @Override
    public boolean hasChildren() {
        return this.firstChild != null;
    }

    private static void clearChildCountCache(DetailAstImpl ast) {
        if (ast != null) {
            ast.childCount = Integer.MIN_VALUE;
        }
    }

    private void clearBranchTokenTypes() {
        DetailAstImpl prevParent = this.parent;
        while (prevParent != null) {
            prevParent.branchTokenTypes = null;
            prevParent = prevParent.parent;
        }
    }

    public void setNextSibling(DetailAST nextSibling) {
        this.clearBranchTokenTypes();
        DetailAstImpl.clearChildCountCache(this.parent);
        this.nextSibling = (DetailAstImpl)nextSibling;
        if (nextSibling != null && this.parent != null) {
            ((DetailAstImpl)nextSibling).setParent(this.parent);
        }
        if (nextSibling != null) {
            ((DetailAstImpl)nextSibling).previousSibling = this;
        }
    }

    public void setFirstChild(DetailAST firstChild) {
        this.clearBranchTokenTypes();
        DetailAstImpl.clearChildCountCache(this);
        this.firstChild = (DetailAstImpl)firstChild;
        if (firstChild != null) {
            ((DetailAstImpl)firstChild).setParent(this);
        }
    }

    public void removeChildren() {
        this.firstChild = null;
    }

    public List<Token> getHiddenBefore() {
        List<Token> returnList = null;
        if (this.hiddenBefore != null) {
            returnList = Collections.unmodifiableList(this.hiddenBefore);
        }
        return returnList;
    }

    public List<Token> getHiddenAfter() {
        List<Token> returnList = null;
        if (this.hiddenAfter != null) {
            returnList = Collections.unmodifiableList(this.hiddenAfter);
        }
        return returnList;
    }

    public void setHiddenBefore(List<Token> hiddenBefore) {
        this.hiddenBefore = Collections.unmodifiableList(hiddenBefore);
    }

    public void setHiddenAfter(List<Token> hiddenAfter) {
        this.hiddenAfter = Collections.unmodifiableList(hiddenAfter);
    }
}

