/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.Collections;
import lombok.Generated;
import org.openrewrite.Tree;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Markers;

public class FullyQualifyMemberReference<P>
extends JavaVisitor<P> {
    private final JavaType memberToFullyQualify;

    @Override
    public J visitCompilationUnit(J.CompilationUnit cu, P p) {
        if (this.memberToFullyQualify instanceof JavaType.Method || this.memberToFullyQualify instanceof JavaType.Variable) {
            return super.visitCompilationUnit(cu, p);
        }
        return cu;
    }

    @Override
    public J visitMethodInvocation(J.MethodInvocation methodInvocation, P p) {
        J.MethodInvocation mi = (J.MethodInvocation)super.visitMethodInvocation(methodInvocation, p);
        if (!(this.memberToFullyQualify instanceof JavaType.Method) || methodInvocation.getSelect() != null || methodInvocation.getMethodType() == null) {
            return mi;
        }
        JavaType.Method m = (JavaType.Method)this.memberToFullyQualify;
        if (m.getName().equals(methodInvocation.getMethodType().getName()) && m.getDeclaringType().getFullyQualifiedName().equals(methodInvocation.getMethodType().getDeclaringType().getFullyQualifiedName())) {
            return mi.withSelect(this.toIdentifier(m.getDeclaringType()));
        }
        return mi;
    }

    @Override
    public J visitIdentifier(J.Identifier identifier, P p) {
        if (!this.isUnqualifiedVarAccess(identifier) || !(this.memberToFullyQualify instanceof JavaType.Variable)) {
            return super.visitIdentifier(identifier, p);
        }
        JavaType.Variable memberToFullyQualify = (JavaType.Variable)this.memberToFullyQualify;
        JavaType.FullyQualified memberToFullyQualifyOwner = TypeUtils.asFullyQualified(memberToFullyQualify.getOwner());
        JavaType.FullyQualified identifierOwner = TypeUtils.asFullyQualified(identifier.getFieldType().getOwner());
        if (memberToFullyQualifyOwner == null || identifierOwner == null) {
            return super.visitIdentifier(identifier, p);
        }
        if (memberToFullyQualifyOwner.getFullyQualifiedName().equals(identifierOwner.getFullyQualifiedName()) && memberToFullyQualify.getName().equals(identifier.getSimpleName())) {
            return this.toFieldAccess(memberToFullyQualify, identifier);
        }
        return super.visitIdentifier(identifier, p);
    }

    private boolean isUnqualifiedVarAccess(J.Identifier identifier) {
        return identifier.getFieldType() != null && !(this.getCursor().getParentTreeCursor().getValue() instanceof J.FieldAccess);
    }

    private J.Identifier toIdentifier(JavaType.FullyQualified fullyQualified) {
        return new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, Collections.emptyList(), fullyQualified.getFullyQualifiedName(), fullyQualified, null);
    }

    private J.FieldAccess toFieldAccess(JavaType.Variable variableType, J.Identifier identifier) {
        return new J.FieldAccess(Tree.randomId(), identifier.getPrefix(), Markers.EMPTY, this.toIdentifier(TypeUtils.asFullyQualified(variableType.getOwner())), JLeftPadded.build(identifier.withPrefix(Space.EMPTY)), variableType.getType());
    }

    @Generated
    public FullyQualifyMemberReference(JavaType memberToFullyQualify) {
        this.memberToFullyQualify = memberToFullyQualify;
    }
}

