/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.io.ByteArrayInputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Incubating;
import org.openrewrite.Parser;
import org.openrewrite.SourceFile;
import org.openrewrite.java.JdkParserBuilderCache;
import org.openrewrite.java.RuntimeClasspathCache;
import org.openrewrite.java.internal.JavaTypeCache;
import org.openrewrite.java.internal.parser.RewriteClasspathJarClasspathLoader;
import org.openrewrite.java.internal.parser.TypeTable;
import org.openrewrite.java.tree.J;
import org.openrewrite.style.NamedStyles;

public interface JavaParser
extends Parser {
    public static final String SKIP_SOURCE_SET_TYPE_GENERATION = "org.openrewrite.java.skipSourceSetTypeGeneration";

    public static List<Path> runtimeClasspath() {
        return RuntimeClasspathCache.getRuntimeClasspath();
    }

    public static List<Path> dependenciesFromClasspath(String ... artifactNames) {
        List<Path> runtimeClasspath = RuntimeClasspathCache.getRuntimeClasspath();
        ArrayList<Path> artifacts = new ArrayList<Path>(artifactNames.length);
        ArrayList<String> missingArtifactNames = new ArrayList<String>(artifactNames.length);
        for (String artifactName : artifactNames) {
            List<Path> matchedArtifacts = JavaParser.filterArtifacts(artifactName, runtimeClasspath);
            if (matchedArtifacts.isEmpty()) {
                missingArtifactNames.add(artifactName);
                continue;
            }
            artifacts.addAll(matchedArtifacts);
        }
        if (!missingArtifactNames.isEmpty()) {
            String missing = missingArtifactNames.stream().sorted().collect(Collectors.joining("', '", "'", "'"));
            throw new IllegalArgumentException(String.format("Unable to find runtime dependencies beginning with: %s, classpath: %s", missing, runtimeClasspath));
        }
        return artifacts;
    }

    public static List<Path> filterArtifacts(String artifactName, List<Path> runtimeClasspath) {
        ArrayList<Path> artifacts = new ArrayList<Path>();
        String normalizedArtifactName = artifactName.replace('-', '_');
        Pattern jarPattern = Pattern.compile(String.format("(%s|%s)(?:-.*?)?\\.jar$", artifactName, normalizedArtifactName));
        Pattern explodedPattern = Pattern.compile("/" + artifactName + "/");
        for (Path cpEntry : runtimeClasspath) {
            String cpEntryString = cpEntry.toString();
            if (!jarPattern.matcher(cpEntryString).find() && (!explodedPattern.matcher(cpEntryString).find() || !cpEntry.toFile().isDirectory())) continue;
            artifacts.add(cpEntry);
        }
        return artifacts;
    }

    public static List<Path> dependenciesFromResources(ExecutionContext ctx, String ... artifactNamesWithVersions) {
        if (artifactNamesWithVersions.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Path> artifacts = new ArrayList<Path>(artifactNamesWithVersions.length);
        LinkedHashSet<String> missingArtifactNames = new LinkedHashSet<String>(Arrays.asList(artifactNamesWithVersions));
        TypeTable typeTable = TypeTable.fromClasspath(ctx, missingArtifactNames);
        if (typeTable != null) {
            Iterator it = missingArtifactNames.iterator();
            while (it.hasNext()) {
                String missingArtifactName = (String)it.next();
                Path located = typeTable.load(missingArtifactName);
                if (located == null) continue;
                artifacts.add(located);
                it.remove();
            }
        }
        if (!missingArtifactNames.isEmpty()) {
            try (RewriteClasspathJarClasspathLoader classpathLoader = new RewriteClasspathJarClasspathLoader(ctx);){
                for (String missingArtifactName : new ArrayList<String>(missingArtifactNames)) {
                    Path located = classpathLoader.load(missingArtifactName);
                    if (located == null) continue;
                    artifacts.add(located);
                    missingArtifactNames.remove(missingArtifactName);
                }
            }
        }
        if (!missingArtifactNames.isEmpty()) {
            String missing = missingArtifactNames.stream().sorted().collect(Collectors.joining("', '", "'", "'"));
            throw new IllegalArgumentException(String.format("Unable to find classpath resource dependencies beginning with: %s", missing));
        }
        return artifacts;
    }

    public static Builder<? extends JavaParser, ?> fromJavaVersion() {
        return JdkParserBuilderCache.getBuilder();
    }

    default public Stream<SourceFile> parse(ExecutionContext ctx, String ... sources) {
        return this.parseInputs(Arrays.stream(sources).map(sourceFile -> new Parser.Input(this.sourcePathFromSourceText(Paths.get("", new String[0]), (String)sourceFile), null, () -> new ByteArrayInputStream(sourceFile.getBytes(this.getCharset(ctx))), true)).collect(Collectors.toList()), null, ctx);
    }

    default public Stream<SourceFile> parse(String ... sources) {
        InMemoryExecutionContext ctx = new InMemoryExecutionContext();
        return this.parse((ExecutionContext)ctx, sources);
    }

    default public boolean accept(Path path) {
        return path.toString().endsWith(".java") && !path.endsWith("module-info.java");
    }

    public JavaParser reset();

    public JavaParser reset(Collection<URI> var1);

    public void setClasspath(Collection<Path> var1);

    default public Path sourcePathFromSourceText(Path prefix, String sourceCode) {
        return JavaParser.resolveSourcePathFromSourceText(prefix, sourceCode);
    }

    public static Path resolveSourcePathFromSourceText(Path prefix, String sourceCode) {
        Pattern packagePattern = Pattern.compile("^package\\s+([^;]+);");
        Pattern classPattern = Pattern.compile("(class|interface|enum|record)\\s*(<[^>]*>)?\\s+(\\w+)");
        Pattern publicClassPattern = Pattern.compile("public\\s+" + classPattern.pattern());
        Function<String, @Nullable String> simpleName = sourceStr -> {
            Matcher classMatcher = publicClassPattern.matcher((CharSequence)sourceStr);
            if (classMatcher.find()) {
                return classMatcher.group(3);
            }
            classMatcher = classPattern.matcher((CharSequence)sourceStr);
            return classMatcher.find() ? classMatcher.group(3) : null;
        };
        Matcher packageMatcher = packagePattern.matcher(sourceCode);
        String pkg = packageMatcher.find() ? packageMatcher.group(1).replace('.', '/') + "/" : "";
        String className = Optional.ofNullable(simpleName.apply(sourceCode)).orElse(Long.toString(System.nanoTime())) + ".java";
        return prefix.resolve(Paths.get(pkg + className, new String[0]));
    }

    public static abstract class Builder<P extends JavaParser, B extends Builder<P, B>>
    extends Parser.Builder {
        protected Collection<Path> classpath = Collections.emptyList();
        protected Collection<String> artifactNames = Collections.emptyList();
        protected Collection<byte[]> classBytesClasspath = Collections.emptyList();
        protected JavaTypeCache javaTypeCache = new JavaTypeCache();
        protected @Nullable Collection<// Could not load outer class - annotation placement on inner may be incorrect
        Parser.Input> dependsOn;
        protected Charset charset = Charset.defaultCharset();
        protected boolean logCompilationWarningsAndErrors = false;
        protected final List<NamedStyles> styles = new ArrayList<NamedStyles>();

        public Builder() {
            super(J.CompilationUnit.class);
        }

        public B logCompilationWarningsAndErrors(boolean logCompilationWarningsAndErrors) {
            this.logCompilationWarningsAndErrors = logCompilationWarningsAndErrors;
            return (B)((Object)this);
        }

        public B typeCache(JavaTypeCache javaTypeCache) {
            this.javaTypeCache = javaTypeCache;
            return (B)((Object)this);
        }

        public B charset(Charset charset) {
            this.charset = charset;
            return (B)((Object)this);
        }

        public B dependsOn(Collection<Parser.Input> inputs) {
            this.dependsOn = inputs;
            return (B)((Object)this);
        }

        public B dependsOn(String ... inputsAsStrings) {
            this.dependsOn = Arrays.stream(inputsAsStrings).map(input -> Parser.Input.fromString((Path)JavaParser.resolveSourcePathFromSourceText(Paths.get("", new String[0]), input), (String)input)).collect(Collectors.toList());
            return (B)((Object)this);
        }

        public B classpath(Collection<Path> classpath) {
            this.artifactNames = Collections.emptyList();
            this.classpath = classpath;
            return (B)((Object)this);
        }

        @Incubating(since="8.18.3")
        public B addClasspathEntry(Path entry) {
            if (this.classpath.isEmpty()) {
                this.classpath = Collections.singletonList(entry);
            } else if (!this.classpath.contains(entry)) {
                this.classpath = new ArrayList<Path>(this.classpath);
                this.classpath.add(entry);
            }
            return (B)((Object)this);
        }

        public B classpath(String ... artifactNames) {
            this.artifactNames = Arrays.asList(artifactNames);
            this.classpath = Collections.emptyList();
            return (B)((Object)this);
        }

        public B classpathFromResources(ExecutionContext ctx, String ... classpath) {
            this.artifactNames = Collections.emptyList();
            this.classpath = JavaParser.dependenciesFromResources(ctx, classpath);
            return (B)((Object)this);
        }

        @Deprecated
        public B classpath(byte[] ... classpath) {
            this.classBytesClasspath = Arrays.asList(classpath);
            return (B)((Object)this);
        }

        public B styles(Iterable<? extends NamedStyles> styles) {
            for (NamedStyles namedStyles : styles) {
                this.styles.add(namedStyles);
            }
            return (B)((Object)this);
        }

        protected Collection<Path> resolvedClasspath() {
            if (!this.artifactNames.isEmpty()) {
                this.classpath = new ArrayList<Path>(this.classpath);
                this.classpath.addAll(JavaParser.dependenciesFromClasspath(this.artifactNames.toArray(new String[0])));
                this.artifactNames = Collections.emptyList();
            }
            return this.classpath;
        }

        public abstract P build();

        public String getDslName() {
            return "java";
        }

        public Builder<P, B> clone() {
            Builder clone = (Builder)super.clone();
            clone.javaTypeCache = this.javaTypeCache.clone();
            return clone;
        }
    }
}

