/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;
import org.openrewrite.java.JavaParser;

public class JavaUnrestrictedClassLoader
extends URLClassLoader {
    final List<Path> modules;

    public JavaUnrestrictedClassLoader(ClassLoader parentClassloader) {
        this(parentClassloader, JavaUnrestrictedClassLoader.getLombok());
    }

    private static List<URL> getLombok() {
        try {
            return JavaParser.dependenciesFromClasspath("lombok").stream().map(it -> {
                try {
                    return it.toUri().toURL();
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            }).collect(Collectors.toList());
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
    }

    public JavaUnrestrictedClassLoader(ClassLoader parentClassloader, List<URL> jars) {
        super(jars.toArray(new URL[0]), parentClassloader);
        FileSystem fs = FileSystems.getFileSystem(URI.create("jrt:/"));
        this.modules = Arrays.asList(fs.getPath("modules", "jdk.compiler"), fs.getPath("modules", "java.compiler"), fs.getPath("modules", "java.base"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            Class<?> c = this.findLoadedClass(name);
            if (c != null) {
                return c;
            }
            String internalName = name.replace('.', '/') + ".class";
            Class<?> _class = this.loadIsolatedClass(name);
            if (_class != null) {
                return _class;
            }
            if (name.startsWith("com.sun") || name.startsWith("sun")) {
                try {
                    for (Path path : this.modules) {
                        Path classFile = path.resolve(internalName);
                        if (!Files.exists(classFile, new LinkOption[0])) continue;
                        byte[] bytes = Files.readAllBytes(classFile);
                        return this.defineClass(name, bytes, 0, bytes.length);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            if (name.startsWith("lombok")) {
                return this.findClass(name);
            }
            return super.loadClass(name);
        }
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        if (name.startsWith("META-INF/services/lombok.")) {
            Objects.requireNonNull(name);
            Enumeration[] tmp = new Enumeration[]{this.findResources(name), this.getParent().getResources(name)};
            return new CompoundEnumeration<URL>(tmp);
        }
        return super.getResources(name);
    }

    @Override
    public @Nullable URL getResource(String name) {
        try {
            for (Path path : this.modules) {
                Path classFile = path.resolve(name);
                if (!Files.exists(classFile, new LinkOption[0])) continue;
                return classFile.toUri().toURL();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return super.getResource(name);
    }

    private @Nullable Class<?> loadIsolatedClass(String className) {
        Class<?> clazz;
        block11: {
            if (!className.startsWith("org.openrewrite.java.isolated")) {
                return null;
            }
            String internalName = className.replace('.', '/') + ".class";
            URL url = JavaParser.class.getClassLoader().getResource(internalName);
            if (url == null) {
                return null;
            }
            InputStream stream = url.openStream();
            try {
                int bytesRead;
                ByteArrayOutputStream classBytes = new ByteArrayOutputStream();
                byte[] bytes = new byte[4096];
                while ((bytesRead = stream.read(bytes)) > 0) {
                    classBytes.write(bytes, 0, bytesRead);
                }
                clazz = this.defineClass(className, classBytes.toByteArray(), 0, classBytes.size());
                if (stream == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            stream.close();
        }
        return clazz;
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }

    private static final class CompoundEnumeration<E>
    implements Enumeration<E> {
        private final Enumeration<E>[] enums;
        private int index;

        public CompoundEnumeration(Enumeration<E>[] enums) {
            this.enums = enums;
        }

        private boolean next() {
            while (this.index < this.enums.length) {
                if (this.enums[this.index].hasMoreElements()) {
                    return true;
                }
                ++this.index;
            }
            return false;
        }

        @Override
        public boolean hasMoreElements() {
            return this.next();
        }

        @Override
        public E nextElement() {
            if (!this.next()) {
                throw new NoSuchElementException();
            }
            return this.enums[this.index].nextElement();
        }
    }
}

