/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.lang.reflect.Method;
import java.util.function.Supplier;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.java.JavaParser;

final class JdkParserBuilderCache {
    private static volatile @Nullable Supplier<JavaParser.Builder<? extends JavaParser, ?>> cachedBuilderSupplier = null;

    static JavaParser.Builder<? extends JavaParser, ?> getBuilder() {
        Supplier<JavaParser.Builder<JavaParser, ?>> supplier = cachedBuilderSupplier;
        if (supplier != null) {
            return supplier.get();
        }
        Class<JdkParserBuilderCache> clazz = JdkParserBuilderCache.class;
        synchronized (JdkParserBuilderCache.class) {
            supplier = cachedBuilderSupplier;
            if (supplier != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return supplier.get();
            }
            String[] versionParts = System.getProperty("java.version").split("[.-]");
            int version = Integer.parseInt(versionParts[0]);
            if (version == 1) {
                version = 8;
            }
            if (version > 21) {
                supplier = JdkParserBuilderCache.tryCreateBuilderSupplier("org.openrewrite.java.Java25Parser");
            }
            if (version > 17 && supplier == null) {
                supplier = JdkParserBuilderCache.tryCreateBuilderSupplier("org.openrewrite.java.Java21Parser");
            }
            if (version > 11 && supplier == null) {
                supplier = JdkParserBuilderCache.tryCreateBuilderSupplier("org.openrewrite.java.Java17Parser");
            }
            if (version > 8 && supplier == null) {
                supplier = JdkParserBuilderCache.tryCreateBuilderSupplier("org.openrewrite.java.Java11Parser");
            }
            if (supplier == null) {
                supplier = JdkParserBuilderCache.tryCreateBuilderSupplier("org.openrewrite.java.Java8Parser");
            }
            if (supplier != null) {
                cachedBuilderSupplier = supplier;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return supplier.get();
            }
            throw new IllegalStateException("Unable to create a Java parser instance. `rewrite-java-8`, `rewrite-java-11`, `rewrite-java-17`, `rewrite-java-21`, or `rewrite-java-25` must be on the classpath.");
        }
    }

    private static @Nullable Supplier<JavaParser.Builder<? extends JavaParser, ?>> tryCreateBuilderSupplier(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            Method builderMethod = clazz.getDeclaredMethod("builder", new Class[0]);
            return () -> {
                try {
                    return (JavaParser.Builder)((Object)((Object)builderMethod.invoke(null, new Object[0])));
                }
                catch (Throwable e) {
                    throw new RuntimeException("Failed to invoke builder() on " + className, e);
                }
            };
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            return null;
        }
    }

    @Generated
    private JdkParserBuilderCache() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

