/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.tools.checkstyle.checks.naming;

import java.util.Arrays;
import java.util.Optional;
import org.openrewrite.tools.checkstyle.api.DetailAST;
import org.openrewrite.tools.checkstyle.checks.naming.AbstractNameCheck;
import org.openrewrite.tools.checkstyle.checks.naming.AccessModifierOption;
import org.openrewrite.tools.checkstyle.utils.CheckUtil;

public class ParameterNameCheck
extends AbstractNameCheck {
    private boolean ignoreOverridden;
    private AccessModifierOption[] accessModifiers = new AccessModifierOption[]{AccessModifierOption.PUBLIC, AccessModifierOption.PROTECTED, AccessModifierOption.PACKAGE, AccessModifierOption.PRIVATE};

    public ParameterNameCheck() {
        super("^[a-z][a-zA-Z0-9]*$");
    }

    public void setIgnoreOverridden(boolean ignoreOverridden) {
        this.ignoreOverridden = ignoreOverridden;
    }

    public void setAccessModifiers(AccessModifierOption ... accessModifiers) {
        this.accessModifiers = Arrays.copyOf(accessModifiers, accessModifiers.length);
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{21};
    }

    @Override
    protected boolean mustCheckName(DetailAST ast) {
        boolean checkName = true;
        DetailAST parent = ast.getParent();
        if (this.ignoreOverridden && ParameterNameCheck.isOverriddenMethod(ast) || parent.getType() == 96 || parent.getParent().getType() == 181 || CheckUtil.isReceiverParameter(ast) || !this.matchAccessModifiers(CheckUtil.getAccessModifierFromModifiersToken(parent.getParent()))) {
            checkName = false;
        }
        return checkName;
    }

    private boolean matchAccessModifiers(AccessModifierOption accessModifier) {
        return Arrays.stream(this.accessModifiers).anyMatch(modifier -> modifier == accessModifier);
    }

    private static boolean isOverriddenMethod(DetailAST ast) {
        Optional<DetailAST> overrideToken;
        boolean overridden = false;
        DetailAST parent = ast.getParent().getParent();
        Optional<DetailAST> annotation = Optional.ofNullable(parent.getFirstChild().getFirstChild());
        if (annotation.isPresent() && (overrideToken = Optional.ofNullable(annotation.get().findFirstToken(58))).isPresent() && "Override".equals(overrideToken.get().getText())) {
            overridden = true;
        }
        return overridden;
    }
}

