/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.marker;

import java.util.UUID;
import lombok.Generated;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Marker;

public final class JavaVersion
implements Marker {
    private final UUID id;
    private final String createdBy;
    private final String vmVendor;
    private final String sourceCompatibility;
    private final String targetCompatibility;

    public int getMajorVersion() {
        try {
            return Integer.parseInt(this.normalize(this.sourceCompatibility));
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public int getMajorReleaseVersion() {
        try {
            return Integer.parseInt(this.normalize(this.targetCompatibility));
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private String normalize(String version) {
        if (!version.contains(".")) {
            return version;
        }
        if (version.startsWith("1.")) {
            String removePrefix = version.substring(version.indexOf(".") + 1);
            return this.normalize(removePrefix);
        }
        return version.substring(0, version.indexOf("."));
    }

    @Generated
    public JavaVersion(UUID id, String createdBy, String vmVendor, String sourceCompatibility, String targetCompatibility) {
        this.id = id;
        this.createdBy = createdBy;
        this.vmVendor = vmVendor;
        this.sourceCompatibility = sourceCompatibility;
        this.targetCompatibility = targetCompatibility;
    }

    @Generated
    public UUID getId() {
        return this.id;
    }

    @Generated
    public String getCreatedBy() {
        return this.createdBy;
    }

    @Generated
    public String getVmVendor() {
        return this.vmVendor;
    }

    @Generated
    public String getSourceCompatibility() {
        return this.sourceCompatibility;
    }

    @Generated
    public String getTargetCompatibility() {
        return this.targetCompatibility;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JavaVersion)) {
            return false;
        }
        JavaVersion other = (JavaVersion)o;
        String this$createdBy = this.getCreatedBy();
        String other$createdBy = other.getCreatedBy();
        if (this$createdBy == null ? other$createdBy != null : !this$createdBy.equals(other$createdBy)) {
            return false;
        }
        String this$vmVendor = this.getVmVendor();
        String other$vmVendor = other.getVmVendor();
        if (this$vmVendor == null ? other$vmVendor != null : !this$vmVendor.equals(other$vmVendor)) {
            return false;
        }
        String this$sourceCompatibility = this.getSourceCompatibility();
        String other$sourceCompatibility = other.getSourceCompatibility();
        if (this$sourceCompatibility == null ? other$sourceCompatibility != null : !this$sourceCompatibility.equals(other$sourceCompatibility)) {
            return false;
        }
        String this$targetCompatibility = this.getTargetCompatibility();
        String other$targetCompatibility = other.getTargetCompatibility();
        return !(this$targetCompatibility == null ? other$targetCompatibility != null : !this$targetCompatibility.equals(other$targetCompatibility));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $createdBy = this.getCreatedBy();
        result = result * 59 + ($createdBy == null ? 43 : $createdBy.hashCode());
        String $vmVendor = this.getVmVendor();
        result = result * 59 + ($vmVendor == null ? 43 : $vmVendor.hashCode());
        String $sourceCompatibility = this.getSourceCompatibility();
        result = result * 59 + ($sourceCompatibility == null ? 43 : $sourceCompatibility.hashCode());
        String $targetCompatibility = this.getTargetCompatibility();
        result = result * 59 + ($targetCompatibility == null ? 43 : $targetCompatibility.hashCode());
        return result;
    }

    @NonNull
    @Generated
    public String toString() {
        return "JavaVersion(id=" + this.getId() + ", createdBy=" + this.getCreatedBy() + ", vmVendor=" + this.getVmVendor() + ", sourceCompatibility=" + this.getSourceCompatibility() + ", targetCompatibility=" + this.getTargetCompatibility() + ")";
    }

    @NonNull
    @Generated
    public JavaVersion withId(UUID id) {
        return this.id == id ? this : new JavaVersion(id, this.createdBy, this.vmVendor, this.sourceCompatibility, this.targetCompatibility);
    }

    @NonNull
    @Generated
    public JavaVersion withCreatedBy(String createdBy) {
        return this.createdBy == createdBy ? this : new JavaVersion(this.id, createdBy, this.vmVendor, this.sourceCompatibility, this.targetCompatibility);
    }

    @NonNull
    @Generated
    public JavaVersion withVmVendor(String vmVendor) {
        return this.vmVendor == vmVendor ? this : new JavaVersion(this.id, this.createdBy, vmVendor, this.sourceCompatibility, this.targetCompatibility);
    }

    @NonNull
    @Generated
    public JavaVersion withSourceCompatibility(String sourceCompatibility) {
        return this.sourceCompatibility == sourceCompatibility ? this : new JavaVersion(this.id, this.createdBy, this.vmVendor, sourceCompatibility, this.targetCompatibility);
    }

    @NonNull
    @Generated
    public JavaVersion withTargetCompatibility(String targetCompatibility) {
        return this.targetCompatibility == targetCompatibility ? this : new JavaVersion(this.id, this.createdBy, this.vmVendor, this.sourceCompatibility, targetCompatibility);
    }
}

