/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.json.internal;

import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.jspecify.annotations.Nullable;
import org.openrewrite.FileAttributes;
import org.openrewrite.Tree;
import org.openrewrite.internal.EncodingDetectingInputStream;
import org.openrewrite.json.internal.grammar.JSON5BaseVisitor;
import org.openrewrite.json.internal.grammar.JSON5Parser;
import org.openrewrite.json.tree.Json;
import org.openrewrite.json.tree.JsonKey;
import org.openrewrite.json.tree.JsonRightPadded;
import org.openrewrite.json.tree.JsonValue;
import org.openrewrite.json.tree.Space;
import org.openrewrite.marker.Markers;

public class JsonParserVisitor
extends JSON5BaseVisitor<Json> {
    private final Path path;
    private final String source;
    private final Charset charset;
    private final boolean charsetBomMarked;
    private final @Nullable FileAttributes fileAttributes;
    private int cursor = 0;
    private int codePointCursor = 0;

    public JsonParserVisitor(Path path, @Nullable FileAttributes fileAttributes, EncodingDetectingInputStream source) {
        this.path = path;
        this.fileAttributes = fileAttributes;
        this.source = source.readFully();
        this.charset = source.getCharset();
        this.charsetBomMarked = source.isCharsetBomMarked();
    }

    @Override
    public Json visitArr(JSON5Parser.ArrContext ctx) {
        return this.convert(ctx, (C arr, Space prefix) -> {
            this.sourceBefore("[");
            List<JSON5Parser.ValueContext> values = ctx.value();
            ArrayList<JsonRightPadded<JsonValue>> converted = new ArrayList<JsonRightPadded<JsonValue>>(values.size());
            for (int i = 0; i < values.size(); ++i) {
                JSON5Parser.ValueContext value = values.get(i);
                if (i == values.size() - 1) {
                    JsonRightPadded<JsonValue> unpadded = JsonRightPadded.build((JsonValue)this.visit((ParseTree)value));
                    if (this.positionOfNext(",", Character.valueOf(']')) >= 0) {
                        converted.add(unpadded.withAfter(this.sourceBefore(",")));
                        converted.add(JsonRightPadded.build(new Json.Empty(Tree.randomId(), Space.EMPTY, Markers.EMPTY)).withAfter(this.sourceBefore("]")));
                        continue;
                    }
                    converted.add(unpadded.withAfter(this.sourceBefore("]")));
                    continue;
                }
                converted.add(JsonRightPadded.build((JsonValue)this.visit((ParseTree)value)).withAfter(this.sourceBefore(",")));
            }
            if (values.isEmpty()) {
                converted.add(JsonRightPadded.build(new Json.Empty(Tree.randomId(), Space.EMPTY, Markers.EMPTY)).withAfter(this.sourceBefore("]")));
            }
            return new Json.Array(Tree.randomId(), (Space)prefix, Markers.EMPTY, (List<JsonRightPadded<JsonValue>>)converted);
        });
    }

    @Override
    public Json.Document visitJson5(JSON5Parser.Json5Context ctx) {
        return !ctx.children.isEmpty() && ctx.children.get(0) instanceof TerminalNode && ((TerminalNode)ctx.children.get(0)).getSymbol().getType() == -1 ? new Json.Document(Tree.randomId(), this.path, Space.EMPTY, Markers.EMPTY, this.charset.name(), this.charsetBomMarked, null, this.fileAttributes, new Json.Literal(Tree.randomId(), Space.EMPTY, Markers.EMPTY, this.source, ""), Space.EMPTY) : this.convert(ctx, (C c, Space prefix) -> new Json.Document(Tree.randomId(), this.path, (Space)prefix, Markers.EMPTY, this.charset.name(), this.charsetBomMarked, null, this.fileAttributes, this.visitValue(c.value()), Space.format(this.source, this.cursor, this.source.length())));
    }

    @Override
    public JsonKey visitKey(JSON5Parser.KeyContext ctx) {
        if (ctx.IDENTIFIER() != null) {
            return this.convert(ctx.IDENTIFIER(), (TerminalNode ident, Space fmt) -> new Json.Identifier(Tree.randomId(), (Space)fmt, Markers.EMPTY, ctx.IDENTIFIER().getText()));
        }
        return this.convert(ctx.STRING(), (TerminalNode str, Space prefix) -> {
            String source = str.getText();
            return new Json.Literal(Tree.randomId(), (Space)prefix, Markers.EMPTY, source, source.substring(1, source.length() - 1));
        });
    }

    @Override
    public Json.Member visitMember(JSON5Parser.MemberContext ctx) {
        return this.convert(ctx, (C member, Space prefix) -> new Json.Member(Tree.randomId(), (Space)prefix, Markers.EMPTY, JsonRightPadded.build(this.visitKey(ctx.key())).withAfter(this.sourceBefore(":")), this.visitValue(ctx.value())));
    }

    @Override
    public Json visitObj(JSON5Parser.ObjContext ctx) {
        return this.convert(ctx, (C arr, Space prefix) -> {
            this.sourceBefore("{");
            List<JSON5Parser.MemberContext> members = ctx.member();
            ArrayList<JsonRightPadded<Json>> converted = new ArrayList<JsonRightPadded<Json>>(members.size());
            for (int i = 0; i < members.size(); ++i) {
                JSON5Parser.MemberContext member = members.get(i);
                if (i == members.size() - 1) {
                    JsonRightPadded<Json> unpadded = JsonRightPadded.build((Json)this.visit((ParseTree)member));
                    if (this.positionOfNext(",", Character.valueOf('}')) >= 0) {
                        converted.add(unpadded.withAfter(this.sourceBefore(",")));
                        converted.add(JsonRightPadded.build(new Json.Empty(Tree.randomId(), Space.EMPTY, Markers.EMPTY)).withAfter(this.sourceBefore("}")));
                        continue;
                    }
                    converted.add(unpadded.withAfter(this.sourceBefore("}")));
                    continue;
                }
                converted.add(JsonRightPadded.build((Json)this.visit((ParseTree)member)).withAfter(this.sourceBefore(",")));
            }
            if (members.isEmpty()) {
                converted.add(JsonRightPadded.build(new Json.Empty(Tree.randomId(), Space.EMPTY, Markers.EMPTY)).withAfter(this.sourceBefore("}")));
            }
            return new Json.JsonObject(Tree.randomId(), (Space)prefix, Markers.EMPTY, (List<JsonRightPadded<Json>>)converted);
        });
    }

    @Override
    public Json.Literal visitNumber(JSON5Parser.NumberContext ctx) {
        Number value;
        AtomicReference<Space> prefix = new AtomicReference<Space>();
        StringBuilder source = new StringBuilder();
        AtomicInteger sign = new AtomicInteger(1);
        if (ctx.SYMBOL() != null) {
            this.convert(ctx.SYMBOL(), (TerminalNode sym, Space fmt) -> {
                source.append(ctx.SYMBOL().getText());
                if ("-".equals(ctx.SYMBOL().getText())) {
                    sign.set(-1);
                }
                prefix.set((Space)fmt);
                return null;
            });
        }
        if (ctx.NUMERIC_LITERAL() != null) {
            if (prefix.get() == null) {
                prefix.set(this.sourceBefore(ctx.NUMERIC_LITERAL().getText()));
            } else {
                this.skip(ctx.NUMERIC_LITERAL());
            }
            source.append(ctx.NUMERIC_LITERAL().getText());
            value = "Infinity".equals(ctx.NUMERIC_LITERAL().getText()) ? Double.valueOf(sign.get() == 1 ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY) : Double.valueOf(Double.NaN);
        } else {
            if (prefix.get() == null) {
                prefix.set(this.sourceBefore(ctx.NUMBER().getText()));
            } else {
                this.skip(ctx.NUMBER());
            }
            String text = ctx.NUMBER().getText();
            source.append(text);
            if (text.startsWith("0x")) {
                value = Long.decode(text) * (long)sign.get();
            } else if (text.contains(".") || text.contains("e") || text.contains("E")) {
                value = Double.parseDouble(text) * (double)sign.get();
            } else {
                try {
                    value = Integer.parseInt(text) * sign.get();
                }
                catch (NumberFormatException e) {
                    try {
                        value = Long.parseLong(text) * (long)sign.get();
                    }
                    catch (NumberFormatException e1) {
                        value = sign.get() == 1 ? new BigInteger(text, 10) : new BigInteger("-" + text, 10);
                    }
                }
            }
        }
        return new Json.Literal(Tree.randomId(), (Space)prefix.get(), Markers.EMPTY, source.toString(), value);
    }

    @Override
    public JsonValue visitValue(JSON5Parser.ValueContext ctx) {
        if (ctx.STRING() != null) {
            return this.convert(ctx.STRING(), (TerminalNode str, Space prefix) -> {
                String source = str.getText();
                return new Json.Literal(Tree.randomId(), (Space)prefix, Markers.EMPTY, source, source.substring(1, source.length() - 1));
            });
        }
        if (ctx.LITERAL() != null) {
            return this.convert(ctx.LITERAL(), (TerminalNode literal, Space prefix) -> {
                String source = literal.getText();
                Boolean value = null;
                if ("true".equals(source)) {
                    value = true;
                } else if ("false".equals(source)) {
                    value = false;
                }
                return new Json.Literal(Tree.randomId(), (Space)prefix, Markers.EMPTY, source, value);
            });
        }
        return (JsonValue)super.visitValue(ctx);
    }

    private Space prefix(ParserRuleContext ctx) {
        return this.prefix(ctx.getStart());
    }

    private Space prefix(@Nullable TerminalNode terminalNode) {
        return terminalNode == null ? Space.EMPTY : this.prefix(terminalNode.getSymbol());
    }

    private Space prefix(Token token) {
        int start = token.getStartIndex();
        if (start < this.codePointCursor) {
            return Space.EMPTY;
        }
        return Space.format(this.source, this.cursor, this.advanceCursor(start));
    }

    public int advanceCursor(int newCodePointIndex) {
        if (newCodePointIndex <= this.codePointCursor) {
            return this.cursor;
        }
        this.cursor = this.source.offsetByCodePoints(this.cursor, newCodePointIndex - this.codePointCursor);
        this.codePointCursor = newCodePointIndex;
        return this.cursor;
    }

    private <C extends ParserRuleContext, T> @Nullable T convert(C ctx, BiFunction<C, Space, T> conversion) {
        if (ctx == null) {
            return null;
        }
        T t = conversion.apply(ctx, this.prefix(ctx));
        if (ctx.getStop() != null) {
            this.advanceCursor(ctx.getStop().getStopIndex() + 1);
        }
        return t;
    }

    private <T> T convert(TerminalNode node, BiFunction<TerminalNode, Space, T> conversion) {
        T t = conversion.apply(node, this.prefix(node));
        this.advanceCursor(node.getSymbol().getStopIndex() + 1);
        return t;
    }

    private void skip(TerminalNode node) {
        this.advanceCursor(node.getSymbol().getStopIndex() + 1);
    }

    private Space sourceBefore(String untilDelim) {
        int delimIndex = this.positionOfNext(untilDelim, null);
        if (delimIndex < 0) {
            return Space.EMPTY;
        }
        Space space = Space.format(this.source, this.cursor, delimIndex);
        this.advanceCursor(this.codePointCursor + Character.codePointCount(this.source, this.cursor, delimIndex) + untilDelim.length());
        return space;
    }

    private int positionOfNext(String untilDelim, @Nullable Character stop) {
        int delimIndex;
        boolean inMultiLineComment = false;
        boolean inSingleLineComment = false;
        for (delimIndex = this.cursor; delimIndex < this.source.length() - untilDelim.length() + 1; ++delimIndex) {
            if (inSingleLineComment) {
                if (this.source.charAt(delimIndex) != '\n') continue;
                inSingleLineComment = false;
                continue;
            }
            if (inMultiLineComment) {
                if (this.source.charAt(delimIndex) == '*' && this.source.charAt(delimIndex + 1) == '/') {
                    inMultiLineComment = false;
                    delimIndex += 2;
                }
            } else if (this.source.charAt(delimIndex) == '/' && this.source.length() - untilDelim.length() > delimIndex + 1) {
                char next = this.source.charAt(delimIndex + 1);
                if (next == '/') {
                    inSingleLineComment = true;
                    ++delimIndex;
                } else if (next == '*') {
                    inMultiLineComment = true;
                    ++delimIndex;
                }
            }
            if (inMultiLineComment || inSingleLineComment) continue;
            if (stop != null && this.source.charAt(delimIndex) == stop.charValue()) {
                return -1;
            }
            if (this.source.startsWith(untilDelim, delimIndex)) break;
        }
        return delimIndex > this.source.length() - untilDelim.length() ? -1 : delimIndex;
    }
}

