/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.kotlin.style;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.StreamUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.kotlin.KotlinStyle;
import org.openrewrite.kotlin.internal.KotlinPrinter;
import org.openrewrite.kotlin.style.Deserializer;
import org.openrewrite.kotlin.style.IntelliJ;
import org.openrewrite.kotlin.style.Serializer;
import org.openrewrite.marker.Markers;

@JsonDeserialize(using=Deserializer.class)
@JsonSerialize(using=Serializer.class)
public class ImportLayoutStyle
implements KotlinStyle {
    private final int topLevelSymbolsToUseStarImport;
    private final int javaStaticsAndEnumsToUseStarImport;
    private final List<Block> layout;
    private final List<Block> packagesToFold;
    private final List<Block> blocksNoCatchalls;
    private final List<Block> blocksOnlyCatchalls;
    private final boolean importAliasesSeparately;

    public ImportLayoutStyle(int topLevelSymbolsToUseStarImport, int javaStaticsAndEnumsToUseStarImport, List<Block> layout, List<Block> packagesToFold, boolean importAliasesSeparately) {
        this.topLevelSymbolsToUseStarImport = topLevelSymbolsToUseStarImport;
        this.javaStaticsAndEnumsToUseStarImport = javaStaticsAndEnumsToUseStarImport;
        this.layout = layout.isEmpty() ? IntelliJ.importLayout().getLayout() : layout;
        this.packagesToFold = packagesToFold;
        Map<Boolean, List<Block>> blockGroups = layout.stream().collect(Collectors.partitioningBy(Block.AllOthers.class::isInstance));
        this.blocksNoCatchalls = blockGroups.get(false);
        this.blocksOnlyCatchalls = blockGroups.get(true);
        this.importAliasesSeparately = importAliasesSeparately;
    }

    /*
     * WARNING - void declaration
     */
    public List<JRightPadded<J.Import>> addImport(List<JRightPadded<J.Import>> originalImports, J.Import toAdd, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable J.Package pkg, Collection<JavaType.FullyQualified> classpath) {
        JRightPadded<J.Import> anImport2;
        JRightPadded<J.Import> anImport22;
        int n;
        void var10_18;
        int j;
        JRightPadded paddedToAdd = new JRightPadded((Object)toAdd, Space.EMPTY, Markers.EMPTY);
        if (originalImports.isEmpty()) {
            paddedToAdd = pkg == null ? paddedToAdd : paddedToAdd.withElement((Object)((J.Import)paddedToAdd.getElement()).withPrefix(Space.format((String)"\n\n")));
            paddedToAdd = ImportLayoutStyle.isPackageAlwaysFolded(this.packagesToFold, (J.Import)paddedToAdd.getElement()) ? paddedToAdd.withElement((Object)((J.Import)paddedToAdd.getElement()).withQualid(((J.Import)paddedToAdd.getElement()).getQualid().withName(((J.Import)paddedToAdd.getElement()).getQualid().getName().withSimpleName("*")))) : paddedToAdd;
            return Collections.singletonList(paddedToAdd);
        }
        List<JRightPadded<J.Import>> ideallyOrdered = new ImportLayoutStyle(Integer.MAX_VALUE, Integer.MAX_VALUE, this.layout, this.packagesToFold, this.importAliasesSeparately).orderImports(ListUtils.concat(originalImports, (Object)paddedToAdd), new HashSet<JavaType.FullyQualified>());
        if (ideallyOrdered.size() == originalImports.size()) {
            HashSet<String> originalPaths = new HashSet<String>();
            for (JRightPadded<J.Import> jRightPadded : originalImports) {
                originalPaths.add(((J.Import)jRightPadded.getElement()).getTypeName());
            }
            int sharedImports = 0;
            for (JRightPadded<J.Import> jRightPadded : ideallyOrdered) {
                if (!originalPaths.contains(((J.Import)jRightPadded.getElement()).getTypeName())) continue;
                ++sharedImports;
            }
            if (sharedImports == originalImports.size()) {
                return originalImports;
            }
        }
        JRightPadded<J.Import> before = null;
        JRightPadded after = null;
        Block block = this.block((JRightPadded<J.Import>)paddedToAdd);
        boolean bl = false;
        block2: for (int i3 = 0; i3 < ideallyOrdered.size(); ++i3) {
            JRightPadded<J.Import> anImport3 = ideallyOrdered.get(i3);
            if (!((J.Import)anImport3.getElement()).isScope((Tree)paddedToAdd.getElement())) continue;
            before = i3 > 0 ? ideallyOrdered.get(i3 - 1) : null;
            JRightPadded jRightPadded = after = i3 + 1 < ideallyOrdered.size() ? ideallyOrdered.get(i3 + 1) : null;
            if (before != null) {
                for (j = 0; !(j >= originalImports.size() || after != null && ((J.Import)after.getElement()).equals(originalImports.get(j).getElement()) && block.accept(after)); ++j) {
                    if (!((J.Import)before.getElement()).equals(originalImports.get(j).getElement())) continue;
                    int n2 = j + 1;
                    after = n2 < originalImports.size() ? originalImports.get(n2) : null;
                    break block2;
                }
            } else {
                if (after == null) break;
                for (j = 0; j < originalImports.size(); ++j) {
                    if (!((J.Import)after.getElement()).equals(originalImports.get(j).getElement())) continue;
                    int n3 = j;
                    before = j > 0 ? originalImports.get(n3 - 1) : null;
                    break block2;
                }
            }
            break;
        }
        AtomicBoolean isNewBlock = new AtomicBoolean(false);
        if (var10_18 != false || pkg != null) {
            if (before == null) {
                if (pkg != null) {
                    Space prefix = ((J.Import)originalImports.get(0).getElement()).getPrefix();
                    paddedToAdd = paddedToAdd.withElement((Object)((J.Import)paddedToAdd.getElement()).withPrefix(prefix));
                }
            } else if (this.block(before) != block) {
                boolean isFound = false;
                for (j = var10_18; j < originalImports.size(); ++j) {
                    if (this.block(originalImports.get(j)) != block) continue;
                    n = j;
                    after = originalImports.get(j);
                    isFound = true;
                    break;
                }
                isNewBlock.set(!isFound);
                paddedToAdd = paddedToAdd.withElement((Object)((J.Import)paddedToAdd.getElement()).withPrefix(Space.format((String)"\n\n")));
            } else {
                paddedToAdd = paddedToAdd.withElement((Object)((J.Import)paddedToAdd.getElement()).withPrefix(Space.format((String)"\n")));
            }
        }
        ArrayList<JRightPadded<J.Import>> checkConflicts = new ArrayList<JRightPadded<J.Import>>(originalImports);
        checkConflicts.add((JRightPadded<J.Import>)paddedToAdd);
        boolean isFoldable = new ImportLayoutConflictDetection(classpath, checkConflicts).isPackageFoldable(ImportLayoutStyle.packageOrOuterClassName((JRightPadded<J.Import>)paddedToAdd));
        AtomicInteger starFoldFrom = new AtomicInteger(n);
        AtomicInteger starFoldTo = new AtomicInteger(n);
        AtomicBoolean starFold = new AtomicBoolean(false);
        int sameCount = 1;
        for (int i2 = n; i2 < originalImports.size() && this.block(anImport22 = originalImports.get(i2)) == block && ImportLayoutStyle.packageOrOuterClassName(anImport22).equals(ImportLayoutStyle.packageOrOuterClassName((JRightPadded<J.Import>)paddedToAdd)); ++i2) {
            starFoldTo.set(i2 + 1);
            ++sameCount;
        }
        for (int i2 = n - 1; i2 >= 0 && this.block(anImport2 = originalImports.get(i2)) == block && ImportLayoutStyle.packageOrOuterClassName(anImport2).equals(ImportLayoutStyle.packageOrOuterClassName((JRightPadded<J.Import>)paddedToAdd)); --i2) {
            starFoldFrom.set(i2);
            ++sameCount;
        }
        if (isFoldable && (((J.Import)paddedToAdd.getElement()).isStatic() && this.javaStaticsAndEnumsToUseStarImport <= sameCount || !((J.Import)paddedToAdd.getElement()).isStatic() && this.topLevelSymbolsToUseStarImport <= sameCount || ImportLayoutStyle.isPackageAlwaysFolded(this.packagesToFold, (J.Import)paddedToAdd.getElement()))) {
            starFold.set(true);
            if (n != starFoldFrom.get()) {
                paddedToAdd = paddedToAdd.withElement((Object)((J.Import)paddedToAdd.getElement()).withPrefix(((J.Import)originalImports.get(starFoldFrom.get()).getElement()).getPrefix()));
            }
        }
        if (starFold.get()) {
            paddedToAdd = paddedToAdd.withElement((Object)((J.Import)paddedToAdd.getElement()).withQualid(((J.Import)paddedToAdd.getElement()).getQualid().withName(((J.Import)paddedToAdd.getElement()).getQualid().getName().withSimpleName("*"))));
            JRightPadded jRightPadded = after = starFoldTo.get() < originalImports.size() ? originalImports.get(starFoldTo.get()) : null;
        }
        if (after != null) {
            if (this.block(after) == block) {
                after = after.withElement((Object)((J.Import)after.getElement()).withPrefix(Space.format((String)"\n")));
            } else if (!isNewBlock.get() && ((J.Import)after.getElement()).getPrefix().getLastWhitespace().chars().filter(c -> c == 10).count() < 2L) {
                after = after.withElement((Object)((J.Import)after.getElement()).withPrefix(Space.format((String)"\n\n")));
            }
        }
        JRightPadded finalToAdd = paddedToAdd;
        JRightPadded finalAfter = after;
        return ListUtils.flatMap(originalImports, (i, anImport) -> {
            if (starFold.get() && i >= starFoldFrom.get() && i < starFoldTo.get()) {
                return i.intValue() == starFoldFrom.get() ? finalToAdd : null;
            }
            if (finalAfter != null && ((J.Import)anImport.getElement()).isScope((Tree)finalAfter.getElement())) {
                if (starFold.get()) {
                    if (starFoldFrom.get() == starFoldTo.get()) {
                        return Arrays.asList(finalToAdd, finalAfter);
                    }
                    return finalAfter;
                }
                if (isNewBlock.get()) {
                    return ((J.Import)anImport.getElement()).isStatic() && !((J.Import)finalToAdd.getElement()).isStatic() ? Arrays.asList(finalToAdd, finalAfter) : Arrays.asList(finalAfter, finalToAdd);
                }
                return Arrays.asList(finalToAdd, finalAfter);
            }
            if (i == originalImports.size() - 1 && finalAfter == null) {
                return Arrays.asList(anImport, finalToAdd);
            }
            return anImport;
        });
    }

    private Block block(JRightPadded<J.Import> anImport) {
        for (Block block : this.layout) {
            if (!block.accept(anImport)) continue;
            return block;
        }
        throw new IllegalStateException("Expected to find a block to fit import into.");
    }

    public List<JRightPadded<J.Import>> orderImports(List<JRightPadded<J.Import>> originalImports, Collection<JavaType.FullyQualified> classpath) {
        LayoutState layoutState = new LayoutState();
        ImportLayoutConflictDetection importLayoutConflictDetection = new ImportLayoutConflictDetection(classpath, originalImports);
        ArrayList<JRightPadded<J.Import>> orderedImports = new ArrayList<JRightPadded<J.Import>>();
        block0: for (JRightPadded<J.Import> anImport : originalImports) {
            for (Block block : this.blocksNoCatchalls) {
                if (!block.accept(anImport)) continue;
                layoutState.claimImport(block, anImport);
                continue block0;
            }
            for (Block block : this.blocksOnlyCatchalls) {
                if (!block.accept(anImport)) continue;
                layoutState.claimImport(block, anImport);
                continue block0;
            }
        }
        int importIndex = 0;
        int extraLineSpaceCount = 0;
        String prevWhitespace = "";
        for (Block block : this.layout) {
            if (block instanceof Block.BlankLines) {
                extraLineSpaceCount = 0;
                for (int i = 0; i < ((Block.BlankLines)block).getCount(); ++i) {
                    ++extraLineSpaceCount;
                }
                continue;
            }
            List<JRightPadded<J.Import>> blockOrdering = block.orderedImports(layoutState, this.topLevelSymbolsToUseStarImport, this.javaStaticsAndEnumsToUseStarImport, importLayoutConflictDetection, this.packagesToFold);
            for (JRightPadded<J.Import> orderedImport : blockOrdering) {
                Space prefix;
                boolean whitespaceContainsCRLF = ((J.Import)orderedImport.getElement()).getPrefix().getWhitespace().contains("\r\n");
                if (importIndex == 0) {
                    prefix = ((J.Import)originalImports.get(0).getElement()).getPrefix();
                } else {
                    String newLineCharacters = whitespaceContainsCRLF || StringUtils.isNullOrEmpty((String)((J.Import)orderedImport.getElement()).getPrefix().getWhitespace()) && "\r\n".equals(prevWhitespace) ? "\r\n" : "\n";
                    StringBuilder newWhitespace = new StringBuilder(newLineCharacters);
                    for (int i = 0; i < extraLineSpaceCount; ++i) {
                        newWhitespace.append(newLineCharacters);
                    }
                    prefix = ((J.Import)orderedImport.getElement()).getPrefix().withWhitespace(newWhitespace.toString());
                }
                if (!((J.Import)orderedImport.getElement()).getPrefix().equals((Object)prefix)) {
                    orderedImports.add((JRightPadded<J.Import>)orderedImport.withElement((Object)((J.Import)orderedImport.getElement()).withPrefix(prefix)));
                } else {
                    orderedImports.add(orderedImport);
                }
                prevWhitespace = whitespaceContainsCRLF ? "\r\n" : "\n";
                extraLineSpaceCount = 0;
                ++importIndex;
            }
        }
        return orderedImports;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static boolean isPackageAlwaysFolded(List<Block> packagesToFold, J.Import checkImport) {
        boolean isPackageFolded = false;
        String anImportName = checkImport.getQualid().printTrimmed(new KotlinPrinter());
        for (Block block : packagesToFold) {
            Block.ImportPackage importPackage = (Block.ImportPackage)block;
            if (!importPackage.packageWildcard.matcher(anImportName).matches()) continue;
            isPackageFolded = true;
        }
        return isPackageFolded;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("topLevelSymbols=").append(this.topLevelSymbolsToUseStarImport).append(", javaStaticAndEnums=").append(this.javaStaticsAndEnumsToUseStarImport).append('\n');
        for (Block block : this.layout) {
            s.append(block).append("\n");
        }
        return s.toString();
    }

    private static String packageOrOuterClassName(JRightPadded<J.Import> anImport) {
        String typeName = ((J.Import)anImport.getElement()).getTypeName();
        if (((J.Import)anImport.getElement()).isStatic()) {
            return typeName;
        }
        String className = ((J.Import)anImport.getElement()).getClassName();
        if (className.contains("$")) {
            return ((J.Import)anImport.getElement()).getPackageName() + "." + className.substring(0, className.lastIndexOf(36)).replace('$', '.');
        }
        return ((J.Import)anImport.getElement()).getPackageName();
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ImportLayoutStyle)) {
            return false;
        }
        ImportLayoutStyle other = (ImportLayoutStyle)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTopLevelSymbolsToUseStarImport() != other.getTopLevelSymbolsToUseStarImport()) {
            return false;
        }
        if (this.getJavaStaticsAndEnumsToUseStarImport() != other.getJavaStaticsAndEnumsToUseStarImport()) {
            return false;
        }
        List<Block> this$layout = this.getLayout();
        List<Block> other$layout = other.getLayout();
        if (this$layout == null ? other$layout != null : !((Object)this$layout).equals(other$layout)) {
            return false;
        }
        List<Block> this$packagesToFold = this.getPackagesToFold();
        List<Block> other$packagesToFold = other.getPackagesToFold();
        return !(this$packagesToFold == null ? other$packagesToFold != null : !((Object)this$packagesToFold).equals(other$packagesToFold));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof ImportLayoutStyle;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getTopLevelSymbolsToUseStarImport();
        result = result * 59 + this.getJavaStaticsAndEnumsToUseStarImport();
        List<Block> $layout = this.getLayout();
        result = result * 59 + ($layout == null ? 43 : ((Object)$layout).hashCode());
        List<Block> $packagesToFold = this.getPackagesToFold();
        result = result * 59 + ($packagesToFold == null ? 43 : ((Object)$packagesToFold).hashCode());
        return result;
    }

    @Generated
    public int getTopLevelSymbolsToUseStarImport() {
        return this.topLevelSymbolsToUseStarImport;
    }

    @Generated
    public int getJavaStaticsAndEnumsToUseStarImport() {
        return this.javaStaticsAndEnumsToUseStarImport;
    }

    @Generated
    public List<Block> getLayout() {
        return this.layout;
    }

    @Generated
    public List<Block> getPackagesToFold() {
        return this.packagesToFold;
    }

    @Generated
    public List<Block> getBlocksNoCatchalls() {
        return this.blocksNoCatchalls;
    }

    @Generated
    public List<Block> getBlocksOnlyCatchalls() {
        return this.blocksOnlyCatchalls;
    }

    @Generated
    public boolean isImportAliasesSeparately() {
        return this.importAliasesSeparately;
    }

    public static interface Block {
        public boolean accept(JRightPadded<J.Import> var1);

        public List<JRightPadded<J.Import>> orderedImports(LayoutState var1, int var2, int var3, ImportLayoutConflictDetection var4, List<Block> var5);

        public static class AllAliases
        extends ImportPackage {
            private Collection<ImportPackage> packageImports = Collections.emptyList();

            public AllAliases() {
                super("*", true, true);
            }

            public void setPackageImports(Collection<ImportPackage> packageImports) {
                this.packageImports = packageImports;
            }

            @Override
            public boolean accept(JRightPadded<J.Import> anImport) {
                for (ImportPackage pi : this.packageImports) {
                    if (!pi.accept(anImport)) continue;
                    return false;
                }
                return ((J.Import)anImport.getElement()).getAlias() != null;
            }

            @Override
            public String toString() {
                return "import all alias imports";
            }
        }

        public static class AllOthers
        extends ImportPackage {
            private Collection<ImportPackage> packageImports = Collections.emptyList();

            public AllOthers(boolean acceptAlias) {
                super("*", true, acceptAlias);
            }

            public void setPackageImports(Collection<ImportPackage> packageImports) {
                this.packageImports = packageImports;
            }

            @Override
            public boolean accept(JRightPadded<J.Import> anImport) {
                for (ImportPackage pi : this.packageImports) {
                    if (!pi.accept(anImport)) continue;
                    return false;
                }
                return true;
            }

            @Override
            public String toString() {
                return "import all other imports";
            }
        }

        public static class ImportPackage
        implements Block {
            boolean acceptAliasImport;
            static final Comparator<JRightPadded<J.Import>> IMPORT_SORTING = (i1, i2) -> {
                String[] import1 = ((J.Import)i1.getElement()).getQualid().printTrimmed().split("\\.");
                String[] import2 = ((J.Import)i2.getElement()).getQualid().printTrimmed().split("\\.");
                for (int i = 0; i < Math.min(import1.length, import2.length); ++i) {
                    int diff = import1[i].compareTo(import2[i]);
                    if (diff == 0) continue;
                    return diff;
                }
                if (import1.length == import2.length) {
                    return 0;
                }
                return import1.length > import2.length ? 1 : -1;
            };
            private final Pattern packageWildcard;

            public ImportPackage(String packageWildcard, boolean withSubpackages, boolean acceptAliasImport) {
                this.acceptAliasImport = acceptAliasImport;
                this.packageWildcard = Pattern.compile(packageWildcard.replace(".", "\\.").replace("*", withSubpackages ? ".+" : "[^.]+"));
            }

            public Pattern getPackageWildcard() {
                return this.packageWildcard;
            }

            @Override
            public boolean accept(JRightPadded<J.Import> anImport) {
                if (!this.acceptAliasImport && ((J.Import)anImport.getElement()).getAlias() != null) {
                    return false;
                }
                return this.packageWildcard.matcher(((J.Import)anImport.getElement()).getQualid().printTrimmed()).matches();
            }

            @Override
            public List<JRightPadded<J.Import>> orderedImports(LayoutState layoutState, int classCountToUseStarImport, int nameCountToUseStarImport, ImportLayoutConflictDetection importLayoutConflictDetection, List<Block> packagesToFold) {
                List<JRightPadded<J.Import>> imports = layoutState.getImports(this);
                Map groupedImports = imports.stream().sorted(IMPORT_SORTING).collect(Collectors.groupingBy(x$0 -> ImportLayoutStyle.packageOrOuterClassName((JRightPadded<J.Import>)x$0), LinkedHashMap::new, Collectors.toList()));
                ArrayList<JRightPadded<J.Import>> ordered = new ArrayList<JRightPadded<J.Import>>(imports.size());
                for (List importGroup : groupedImports.values()) {
                    JRightPadded toStar = (JRightPadded)importGroup.get(0);
                    int threshold = ((J.Import)toStar.getElement()).isStatic() ? nameCountToUseStarImport : classCountToUseStarImport;
                    boolean starImportExists = importGroup.stream().anyMatch(it -> ((J.Import)it.getElement()).getQualid().getSimpleName().equals("*"));
                    boolean disableFoldingImports = true;
                    if (!disableFoldingImports && importLayoutConflictDetection.isPackageFoldable(ImportLayoutStyle.packageOrOuterClassName((JRightPadded<J.Import>)toStar)) && (ImportLayoutStyle.isPackageAlwaysFolded(packagesToFold, (J.Import)toStar.getElement()) || importGroup.size() >= threshold || starImportExists && importGroup.size() > 1)) {
                        J.FieldAccess qualid = ((J.Import)toStar.getElement()).getQualid();
                        J.Identifier name = qualid.getName();
                        Set typeNamesInThisGroup = importGroup.stream().map(im -> ((J.Import)im.getElement()).getClassName()).collect(Collectors.toSet());
                        Optional<String> oneOfTheTypesIsInAnotherGroupToo = groupedImports.values().stream().filter(group -> group != importGroup).flatMap(group -> group.stream().filter(im -> typeNamesInThisGroup.contains(((J.Import)im.getElement()).getClassName()))).map(im -> ((J.Import)im.getElement()).getTypeName()).findAny();
                        if (starImportExists || !oneOfTheTypesIsInAnotherGroupToo.isPresent()) {
                            ordered.add((JRightPadded<J.Import>)toStar.withElement((Object)((J.Import)toStar.getElement()).withQualid(qualid.withName(name.withSimpleName("*")))));
                            continue;
                        }
                    }
                    Predicate predicate = StreamUtils.distinctBy(t -> ((J.Import)t.getElement()).printTrimmed(new KotlinPrinter()));
                    for (JRightPadded importJRightPadded : importGroup) {
                        if (!predicate.test(importJRightPadded)) continue;
                        ordered.add((JRightPadded<J.Import>)importJRightPadded);
                    }
                }
                ordered.sort(IMPORT_SORTING);
                return ordered;
            }

            public String toString() {
                return "import " + this.packageWildcard;
            }
        }

        public static class BlankLines
        implements Block {
            private int count = 1;

            private int getCount() {
                return this.count;
            }

            @Override
            public boolean accept(JRightPadded<J.Import> anImport) {
                return false;
            }

            @Override
            public List<JRightPadded<J.Import>> orderedImports(LayoutState layoutState, int classCountToUseStarImport, int nameCountToUseStartImport, ImportLayoutConflictDetection importLayoutConflictDetection, List<Block> packagesToFold) {
                return Collections.emptyList();
            }

            public String toString() {
                return "<blank line>" + (this.count > 1 ? " (x" + this.count + ")" : "");
            }
        }
    }

    private static class ImportLayoutConflictDetection {
        private final Collection<JavaType.FullyQualified> classpath;
        private final List<JRightPadded<J.Import>> originalImports;
        private final Set<String> jvmClasspathNames = new HashSet<String>();
        private @Nullable Set<String> containsClassNameConflict = null;

        ImportLayoutConflictDetection(Collection<JavaType.FullyQualified> classpath, List<JRightPadded<J.Import>> originalImports) {
            this.classpath = classpath;
            this.originalImports = originalImports;
        }

        public boolean isPackageFoldable(String packageName) {
            if (this.containsClassNameConflict == null) {
                this.containsClassNameConflict = new HashSet<String>();
                this.setJVMClassNames();
                Map<String, Set<String>> nameToPackages = this.mapNamesInPackageToPackages();
                for (String className : nameToPackages.keySet()) {
                    if (nameToPackages.get(className).size() <= 1 && !this.jvmClasspathNames.contains(className)) continue;
                    this.containsClassNameConflict.addAll((Collection<String>)nameToPackages.get(className));
                }
            }
            return this.classpath.isEmpty() || !this.containsClassNameConflict.contains(packageName);
        }

        private void setJVMClassNames() {
            for (JavaType.FullyQualified fqn : this.classpath) {
                if (!"java.lang".equals(fqn.getPackageName())) continue;
                this.jvmClasspathNames.add(fqn.getClassName());
            }
        }

        private Map<String, Set<String>> mapNamesInPackageToPackages() {
            HashMap<String, Set<String>> nameToPackages = new HashMap<String, Set<String>>();
            HashSet<String> checkPackageForClasses = new HashSet<String>();
            for (JRightPadded<J.Import> anImport : this.originalImports) {
                checkPackageForClasses.add(ImportLayoutStyle.packageOrOuterClassName((JRightPadded<J.Import>)anImport));
                nameToPackages.computeIfAbsent(((J.Import)anImport.getElement()).getClassName(), p -> new HashSet()).add(((J.Import)anImport.getElement()).getPackageName());
            }
            for (JavaType.FullyQualified classGraphFqn : this.classpath) {
                Set packages;
                String packageName = classGraphFqn.getPackageName();
                if (checkPackageForClasses.contains(packageName)) {
                    String className = classGraphFqn.getClassName();
                    Set packages2 = nameToPackages.getOrDefault(className, new HashSet());
                    packages2.add(packageName);
                    nameToPackages.put(className, packages2);
                    continue;
                }
                if (!checkPackageForClasses.contains(classGraphFqn.getFullyQualifiedName())) continue;
                packageName = classGraphFqn.getFullyQualifiedName();
                for (JavaType.Variable member : classGraphFqn.getMembers()) {
                    if (!member.getFlags().contains(Flag.Static)) continue;
                    packages = nameToPackages.getOrDefault(member.getName(), new HashSet());
                    packages.add(packageName);
                    nameToPackages.put(member.getName(), packages);
                }
                for (JavaType.Method method : classGraphFqn.getMethods()) {
                    if (!method.getFlags().contains(Flag.Static)) continue;
                    packages = nameToPackages.getOrDefault(method.getName(), new HashSet());
                    packages.add(packageName);
                    nameToPackages.put(method.getName(), packages);
                }
            }
            return nameToPackages;
        }
    }

    private static class LayoutState {
        Map<Block, List<JRightPadded<J.Import>>> imports = new HashMap<Block, List<JRightPadded<J.Import>>>();

        private LayoutState() {
        }

        public void claimImport(Block block, JRightPadded<J.Import> import_) {
            this.imports.computeIfAbsent(block, b -> new ArrayList()).add(import_);
        }

        public List<JRightPadded<J.Import>> getImports(Block block) {
            return this.imports.getOrDefault(block, Collections.emptyList());
        }
    }

    public static class Builder {
        private final List<Block> blocks = new ArrayList<Block>();
        private final List<Block> packagesToFold = new ArrayList<Block>();
        private int topLevelSymbolsToUseStarImport = 5;
        private int javaStaticsAndEnumsToUseStarImport = 3;
        private boolean importAliasesSeparately = false;

        public Builder importAllOthers() {
            this.blocks.add(new Block.AllOthers(!this.importAliasesSeparately));
            return this;
        }

        public Builder importAllAliases() {
            this.blocks.add(new Block.AllAliases());
            return this;
        }

        public Builder blankLine() {
            if (!this.blocks.isEmpty() && this.blocks.get(this.blocks.size() - 1) instanceof Block.BlankLines) {
                ((Block.BlankLines)this.blocks.get(this.blocks.size() - 1)).count++;
            } else {
                this.blocks.add(new Block.BlankLines());
            }
            return this;
        }

        public Builder importPackage(String packageWildcard, Boolean withSubpackages) {
            this.blocks.add(new Block.ImportPackage(packageWildcard, withSubpackages, !this.importAliasesSeparately));
            return this;
        }

        public Builder importPackage(String packageWildcard) {
            return this.importPackage(packageWildcard, true);
        }

        public Builder packageToFold(String packageWildcard, Boolean withSubpackages) {
            this.packagesToFold.add(new Block.ImportPackage(packageWildcard, withSubpackages, !this.importAliasesSeparately));
            return this;
        }

        public Builder packageToFold(String packageWildcard) {
            return this.packageToFold(packageWildcard, true);
        }

        public Builder topLevelSymbolsToUseStarImport(int topLevelSymbolsToUseStarImport) {
            this.topLevelSymbolsToUseStarImport = topLevelSymbolsToUseStarImport;
            return this;
        }

        public Builder javaStaticsAndEnumsToUseStarImport(int javaStaticsAndEnumsToUseStarImport) {
            this.javaStaticsAndEnumsToUseStarImport = javaStaticsAndEnumsToUseStarImport;
            return this;
        }

        public Builder importAliasesSeparately(boolean importAliasesSeparately) {
            this.importAliasesSeparately = importAliasesSeparately;
            return this;
        }

        public ImportLayoutStyle build() {
            for (Block block : this.blocks) {
                if (!(block instanceof Block.AllOthers)) continue;
                ((Block.AllOthers)block).setPackageImports(this.blocks.stream().filter(b -> b.getClass().equals(Block.ImportPackage.class)).map(Block.ImportPackage.class::cast).collect(Collectors.toList()));
            }
            return new ImportLayoutStyle(this.topLevelSymbolsToUseStarImport, this.javaStaticsAndEnumsToUseStarImport, this.blocks, this.packagesToFold, this.importAliasesSeparately);
        }
    }
}

