/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.kotlin;

import java.util.List;
import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.kotlin.marker.TypeReferencePrefix;
import org.openrewrite.kotlin.tree.K;
import org.openrewrite.kotlin.tree.KContainer;
import org.openrewrite.kotlin.tree.KLeftPadded;
import org.openrewrite.kotlin.tree.KRightPadded;
import org.openrewrite.kotlin.tree.KSpace;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markers;

public class KotlinVisitor<P>
extends JavaVisitor<P> {
    public boolean isAcceptable(SourceFile sourceFile, P p) {
        return sourceFile instanceof K.CompilationUnit;
    }

    public String getLanguage() {
        return "kotlin";
    }

    public J visitCompilationUnit(K.CompilationUnit cu, P p) {
        K.CompilationUnit c = cu;
        c = c.withPrefix(this.visitSpace(c.getPrefix(), Space.Location.COMPILATION_UNIT_PREFIX, p));
        c = c.withMarkers(this.visitMarkers(c.getMarkers(), p));
        if ((c = c.withAnnotations(ListUtils.map(c.getAnnotations(), e -> (J.Annotation)this.visitAndCast((Tree)e, p)))).getPadding().getPackageDeclaration() != null) {
            c = c.getPadding().withPackageDeclaration((JRightPadded<J.Package>)this.visitRightPadded(c.getPadding().getPackageDeclaration(), JRightPadded.Location.PACKAGE, p));
        }
        c = c.getPadding().withImports(ListUtils.map(c.getPadding().getImports(), t -> this.visitRightPadded((JRightPadded)t, JRightPadded.Location.IMPORT, p)));
        c = c.getPadding().withStatements(ListUtils.map(c.getPadding().getStatements(), rp -> rp.withElement((Object)Objects.requireNonNull((Statement)this.visitAndCast((Tree)rp.getElement(), p))).withAfter(this.visitSpace(rp.getAfter(), Space.Location.BLOCK_STATEMENT_SUFFIX, p))));
        return c.withEof(this.visitSpace(c.getEof(), Space.Location.COMPILATION_UNIT_EOF, p));
    }

    public J visitCompilationUnit(J.CompilationUnit cu, P p) {
        throw new UnsupportedOperationException("Kotlin has a different structure for its compilation unit. See K.CompilationUnit.");
    }

    public J visitAnnotatedExpression(K.AnnotatedExpression annotatedExpression, P p) {
        K.AnnotatedExpression ae = annotatedExpression;
        ae = ae.withMarkers(this.visitMarkers(ae.getMarkers(), p));
        Expression temp = (Expression)this.visitExpression(ae = ae.withAnnotations(ListUtils.map(ae.getAnnotations(), a -> (J.Annotation)this.visitAndCast((Tree)a, p))), p);
        if (!(temp instanceof K.AnnotatedExpression)) {
            return temp;
        }
        ae = (K.AnnotatedExpression)temp;
        return ae;
    }

    public J visitAnnotationType(K.AnnotationType annotationType, P p) {
        K.AnnotationType a = annotationType;
        a = a.withPrefix(this.visitSpace(a.getPrefix(), Space.Location.ANNOTATION_PREFIX, p));
        a = a.withMarkers(this.visitMarkers(a.getMarkers(), p));
        a = a.getPadding().withUseSite((JRightPadded<Expression>)this.visitRightPadded(a.getPadding().getUseSite(), JRightPadded.Location.ANNOTATION_ARGUMENT, p));
        return a.withCallee((J.Annotation)this.visitAndCast((Tree)a.getCallee(), p));
    }

    public J visitBinary(K.Binary binary, P p) {
        K.Binary b = binary;
        b = b.withPrefix(this.visitSpace(b.getPrefix(), KSpace.Location.BINARY_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(b = b.withMarkers(this.visitMarkers(b.getMarkers(), p)), p);
        if (!(temp instanceof K.Binary)) {
            return temp;
        }
        b = (K.Binary)temp;
        b = b.withLeft((Expression)this.visitAndCast((Tree)b.getLeft(), p));
        b = b.getPadding().withOperator(this.visitLeftPadded(b.getPadding().getOperator(), KLeftPadded.Location.BINARY_OPERATOR, p));
        b = b.withRight((Expression)this.visitAndCast((Tree)b.getRight(), p));
        return b.withType(this.visitType(b.getType(), p));
    }

    public J visitClassDeclaration(K.ClassDeclaration classDeclaration, P p) {
        K.ClassDeclaration c = classDeclaration;
        c = c.withMarkers(this.visitMarkers(c.getMarkers(), p));
        c = c.withClassDeclaration((J.ClassDeclaration)this.visitAndCast((Tree)c.getClassDeclaration(), p));
        return c.withTypeConstraints((K.TypeConstraints)this.visitAndCast((Tree)c.getTypeConstraints(), p));
    }

    public J visitConstructor(K.Constructor constructor, P p) {
        K.Constructor c = constructor;
        c = c.withMarkers(this.visitMarkers(c.getMarkers(), p));
        c = c.withMethodDeclaration((J.MethodDeclaration)this.visitAndCast((Tree)c.getMethodDeclaration(), p));
        return c.getPadding().withInvocation(this.visitLeftPadded(c.getPadding().getInvocation(), p));
    }

    public J visitConstructorInvocation(K.ConstructorInvocation constructorInvocation, P p) {
        K.ConstructorInvocation d = constructorInvocation;
        d = d.withPrefix(this.visitSpace(d.getPrefix(), KSpace.Location.CONSTRUCTOR_INVOCATION_PREFIX, p));
        d = d.withMarkers(this.visitMarkers(d.getMarkers(), p));
        d = d.withTypeTree((TypeTree)this.visitAndCast((Tree)d.getTypeTree(), p));
        return d.getPadding().withArguments((JContainer<Expression>)this.visitContainer(d.getPadding().getArguments(), JContainer.Location.METHOD_INVOCATION_ARGUMENTS, p));
    }

    public J visitDelegatedSuperType(K.DelegatedSuperType delegatedSuperType, P p) {
        K.DelegatedSuperType d = delegatedSuperType;
        d = d.withBy(this.visitSpace(d.getBy(), KSpace.Location.DELEGATED_SUPER_TYPE_BY, p));
        d = d.withMarkers(this.visitMarkers(d.getMarkers(), p));
        d = d.withTypeTree((TypeTree)this.visitAndCast((Tree)d.getTypeTree(), p));
        return d.withDelegate((Expression)this.visitAndCast((Tree)d.getDelegate(), p));
    }

    public J visitDestructuringDeclaration(K.DestructuringDeclaration destructuringDeclaration, P p) {
        K.DestructuringDeclaration d = destructuringDeclaration;
        d = d.withPrefix(this.visitSpace(d.getPrefix(), KSpace.Location.DESTRUCTURING_DECLARATION_PREFIX, p));
        Statement temp = (Statement)this.visitStatement(d = d.withMarkers(this.visitMarkers(d.getMarkers(), p)), p);
        if (!(temp instanceof K.DestructuringDeclaration)) {
            return temp;
        }
        d = (K.DestructuringDeclaration)temp;
        d = d.withInitializer((J.VariableDeclarations)this.visitAndCast((Tree)d.getInitializer(), p));
        return d.getPadding().withDestructAssignments(this.visitContainer(d.getPadding().getDestructAssignments(), KContainer.Location.DESTRUCT_ASSIGNMENTS, p));
    }

    public J visitFunctionType(K.FunctionType functionType2, P p) {
        K.FunctionType f2 = functionType2;
        f2 = f2.withPrefix(this.visitSpace(f2.getPrefix(), KSpace.Location.FUNCTION_TYPE_PREFIX, p));
        f2 = f2.withMarkers(this.visitMarkers(f2.getMarkers(), p));
        f2 = f2.withLeadingAnnotations(ListUtils.map(f2.getLeadingAnnotations(), a -> (J.Annotation)this.visitAndCast((Tree)a, p)));
        f2 = f2.withModifiers(ListUtils.map(f2.getModifiers(), e -> (J.Modifier)this.visitAndCast((Tree)e, p)));
        if ((f2 = f2.withReceiver(this.visitRightPadded(f2.getReceiver(), p))).getPadding().getParameters() != null) {
            f2 = f2.getPadding().withParameters(this.visitContainer(f2.getPadding().getParameters(), KContainer.Location.FUNCTION_TYPE_PARAMETERS, p));
        }
        return f2.withReturnType(this.visitRightPadded(f2.getReturnType(), p));
    }

    public J visitFunctionTypeParameter(K.FunctionType.Parameter parameter, P p) {
        K.FunctionType.Parameter pa = parameter;
        if ((pa = pa.withMarkers(this.visitMarkers(pa.getMarkers(), p))).getName() != null) {
            pa = pa.withName((J.Identifier)this.visitAndCast((Tree)pa.getName(), p));
        }
        return pa.withParameterType((TypeTree)this.visitAndCast((Tree)pa.getParameterType(), p));
    }

    public J visitListLiteral(K.ListLiteral listLiteral, P p) {
        K.ListLiteral l = listLiteral;
        l = l.withPrefix(this.visitSpace(l.getPrefix(), KSpace.Location.LIST_LITERAL_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(l = l.withMarkers(this.visitMarkers(l.getMarkers(), p)), p);
        if (!(temp instanceof K.ListLiteral)) {
            return temp;
        }
        l = (K.ListLiteral)temp;
        l = l.getPadding().withElements(this.visitContainer(l.getPadding().getElements(), KContainer.Location.LIST_LITERAL_ELEMENTS, p));
        return l.withType(this.visitType(l.getType(), p));
    }

    public J visitMethodDeclaration(K.MethodDeclaration methodDeclaration, P p) {
        K.MethodDeclaration m = methodDeclaration;
        m = m.withMarkers(this.visitMarkers(m.getMarkers(), p));
        m = m.withMethodDeclaration((J.MethodDeclaration)this.visitAndCast((Tree)m.getMethodDeclaration(), p));
        return m.withTypeConstraints((K.TypeConstraints)this.visitAndCast((Tree)m.getTypeConstraints(), p));
    }

    public J visitMultiAnnotationType(K.MultiAnnotationType multiAnnotationType, P p) {
        K.MultiAnnotationType m = multiAnnotationType;
        m = m.withPrefix(this.visitSpace(m.getPrefix(), Space.Location.ANNOTATION_PREFIX, p));
        m = m.withMarkers(this.visitMarkers(m.getMarkers(), p));
        m = m.getPadding().withUseSite((JRightPadded<Expression>)this.visitRightPadded(m.getPadding().getUseSite(), JRightPadded.Location.ANNOTATION_ARGUMENT, p));
        return m.withAnnotations(this.visitContainer(m.getAnnotations(), p));
    }

    public J visitProperty(K.Property property, P p) {
        K.Property pr = property;
        pr = pr.withPrefix(this.visitSpace(pr.getPrefix(), KSpace.Location.PROPERTY_PREFIX, p));
        Statement temp = (Statement)this.visitStatement(pr = pr.withMarkers(this.visitMarkers(pr.getMarkers(), p)), p);
        if (!(temp instanceof K.Property)) {
            return temp;
        }
        pr = (K.Property)temp;
        pr = pr.getPadding().withVariableDeclarations(this.visitRightPadded(pr.getPadding().getVariableDeclarations(), p));
        pr = pr.getPadding().withReceiver(this.visitRightPadded(pr.getPadding().getReceiver(), p));
        return pr.withAccessors(this.visitContainer(pr.getAccessors(), p));
    }

    public J visitReturn(K.Return return_, P p) {
        K.Return r = return_;
        r = (K.Return)r.withPrefix(this.visitSpace(r.getPrefix(), KSpace.Location.RETURN_PREFIX, p));
        Statement temp = (Statement)this.visitStatement(r = (K.Return)r.withMarkers(this.visitMarkers(r.getMarkers(), p)), p);
        if (!(temp instanceof K.Return)) {
            return temp;
        }
        r = (K.Return)temp;
        Expression temp2 = (Expression)this.visitExpression(r, p);
        if (!(temp2 instanceof K.Return)) {
            return temp2;
        }
        r = (K.Return)temp2;
        r = r.withExpression((J.Return)this.visitAndCast((Tree)r.getExpression(), p));
        return r.withLabel((J.Identifier)this.visitAndCast((Tree)r.getLabel(), p));
    }

    public J visitSpreadArgument(K.SpreadArgument spreadArgument, P p) {
        K.SpreadArgument s = spreadArgument;
        s = s.withPrefix(this.visitSpace(s.getPrefix(), KSpace.Location.SPREAD_ARGUMENT_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(s = s.withMarkers(this.visitMarkers(s.getMarkers(), p)), p);
        if (!(temp instanceof K.SpreadArgument)) {
            return temp;
        }
        s = (K.SpreadArgument)temp;
        return s.withExpression((Expression)this.visitAndCast((Tree)s.getExpression(), p));
    }

    public J visitStringTemplate(K.StringTemplate stringTemplate, P p) {
        K.StringTemplate k = stringTemplate;
        k = k.withPrefix(this.visitSpace(k.getPrefix(), KSpace.Location.STRING_TEMPLATE_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(k = k.withMarkers(this.visitMarkers(k.getMarkers(), p)), p);
        if (!(temp instanceof K.StringTemplate)) {
            return temp;
        }
        k = (K.StringTemplate)temp;
        k = k.withStrings(ListUtils.map(k.getStrings(), s -> (J)this.visit((Tree)s, p)));
        return k.withType(this.visitType(k.getType(), p));
    }

    public J visitStringTemplateExpression(K.StringTemplate.Expression expression, P p) {
        K.StringTemplate.Expression v = expression;
        v = v.withPrefix(this.visitSpace(v.getPrefix(), KSpace.Location.STRING_TEMPLATE_EXPRESSION_PREFIX, p));
        v = v.withMarkers(this.visitMarkers(v.getMarkers(), p));
        v = v.withTree((J)this.visit((Tree)v.getTree(), p));
        return v.withAfter(this.visitSpace(v.getAfter(), KSpace.Location.STRING_TEMPLATE_EXPRESSION_AFTER, p));
    }

    public J visitThis(K.This aThis, P p) {
        K.This k = aThis;
        k = k.withPrefix(this.visitSpace(k.getPrefix(), KSpace.Location.THIS_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(k = k.withMarkers(this.visitMarkers(k.getMarkers(), p)), p);
        if (!(temp instanceof K.This)) {
            return temp;
        }
        k = (K.This)temp;
        return k.withType(this.visitType(k.getType(), p));
    }

    public J visitTypeAlias(K.TypeAlias typeAlias, P p) {
        K.TypeAlias t = typeAlias;
        t = t.withPrefix(this.visitSpace(t.getPrefix(), KSpace.Location.TYPE_ALIAS_PREFIX, p));
        Statement temp = (Statement)this.visitStatement(t = t.withMarkers(this.visitMarkers(t.getMarkers(), p)), p);
        if (!(temp instanceof K.TypeAlias)) {
            return temp;
        }
        t = (K.TypeAlias)temp;
        t = t.withLeadingAnnotations(ListUtils.map(t.getLeadingAnnotations(), a -> (J.Annotation)this.visitAndCast((Tree)a, p)));
        t = t.withModifiers(ListUtils.map(t.getModifiers(), mod -> mod.withPrefix(this.visitSpace(mod.getPrefix(), Space.Location.MODIFIER_PREFIX, p))));
        t = t.withModifiers(ListUtils.map(t.getModifiers(), m -> (J.Modifier)this.visitAndCast((Tree)m, p)));
        if ((t = t.withName((J.Identifier)this.visitAndCast((Tree)t.getName(), p))).getPadding().getTypeParameters() != null) {
            t = t.getPadding().withTypeParameters((JContainer<J.TypeParameter>)this.visitContainer(t.getPadding().getTypeParameters(), JContainer.Location.TYPE_PARAMETERS, p));
        }
        if (t.getPadding().getInitializer() != null) {
            t = t.getPadding().withInitializer(this.visitLeftPadded(t.getPadding().getInitializer(), KLeftPadded.Location.TYPE_ALIAS_INITIALIZER, p));
        }
        return t.withType(this.visitType(t.getType(), p));
    }

    public J visitTypeConstraints(K.TypeConstraints typeConstraints, P p) {
        K.TypeConstraints t = typeConstraints;
        t = (K.TypeConstraints)t.withPrefix(this.visitSpace(t.getPrefix(), KSpace.Location.TYPE_CONSTRAINT_PREFIX, p));
        t = t.withMarkers(this.visitMarkers(t.getMarkers(), p));
        return t.getPadding().withConstraints(this.visitContainer(t.getPadding().getConstraints(), p));
    }

    public J visitUnary(K.Unary unary, P p) {
        K.Unary u = unary;
        u = u.withPrefix(this.visitSpace(u.getPrefix(), KSpace.Location.UNARY_PREFIX, p));
        Statement temp = (Statement)this.visitStatement(u = u.withMarkers(this.visitMarkers(u.getMarkers(), p)), p);
        if (!(temp instanceof K.Unary)) {
            return temp;
        }
        u = (K.Unary)temp;
        Expression temp2 = (Expression)this.visitExpression(u, p);
        if (!(temp2 instanceof K.Unary)) {
            return temp2;
        }
        u = (K.Unary)temp2;
        u = u.getPadding().withOperator((JLeftPadded<K.Unary.Type>)this.visitLeftPadded(u.getPadding().getOperator(), JLeftPadded.Location.UNARY_OPERATOR, p));
        u = u.withExpression((Expression)this.visitAndCast((Tree)u.getExpression(), p));
        return u.withType(this.visitType(u.getType(), p));
    }

    public J visitWhen(K.When when, P p) {
        K.When w = when;
        w = w.withPrefix(this.visitSpace(w.getPrefix(), KSpace.Location.WHEN_PREFIX, p));
        Statement temp = (Statement)this.visitStatement(w = w.withMarkers(this.visitMarkers(w.getMarkers(), p)), p);
        if (!(temp instanceof K.When)) {
            return temp;
        }
        w = (K.When)temp;
        w = w.withSelector((J.ControlParentheses<J>)((J.ControlParentheses)this.visitAndCast((Tree)w.getSelector(), p)));
        w = w.withBranches((J.Block)this.visitAndCast((Tree)w.getBranches(), p));
        return w.withType(this.visitType(w.getType(), p));
    }

    public J visitWhenBranch(K.WhenBranch whenBranch, P p) {
        K.WhenBranch w = whenBranch;
        w = w.withPrefix(this.visitSpace(w.getPrefix(), KSpace.Location.WHEN_BRANCH_PREFIX, p));
        Statement temp = (Statement)this.visitStatement(w = w.withMarkers(this.visitMarkers(w.getMarkers(), p)), p);
        if (!(temp instanceof K.WhenBranch)) {
            return temp;
        }
        w = (K.WhenBranch)temp;
        w = w.getPadding().withExpressions(this.visitContainer(w.getPadding().getExpressions(), KContainer.Location.WHEN_BRANCH_EXPRESSION, p));
        return w.getPadding().withBody((JRightPadded<J>)this.visitRightPadded(w.getPadding().getBody(), JRightPadded.Location.CASE_BODY, p));
    }

    public <T> JRightPadded<T> visitRightPadded(@Nullable JRightPadded<T> right, P p) {
        return super.visitRightPadded(right, JRightPadded.Location.LANGUAGE_EXTENSION, p);
    }

    public <T> JLeftPadded<T> visitLeftPadded(JLeftPadded<T> left, P p) {
        return super.visitLeftPadded(left, JLeftPadded.Location.LANGUAGE_EXTENSION, p);
    }

    public Space visitSpace(Space space, KSpace.Location loc, P p) {
        return this.visitSpace(space, Space.Location.LANGUAGE_EXTENSION, p);
    }

    public <J2 extends J> JContainer<J2> visitContainer(JContainer<J2> container, P p) {
        return super.visitContainer(container, JContainer.Location.LANGUAGE_EXTENSION, p);
    }

    public <J2 extends J> @Nullable JContainer<J2> visitContainer(@Nullable JContainer<J2> container, KContainer.Location loc, P p) {
        if (container == null) {
            return null;
        }
        this.setCursor(new Cursor(this.getCursor(), container));
        Space before = this.visitSpace(container.getBefore(), loc.getBeforeLocation(), p);
        List js = ListUtils.map((List)container.getPadding().getElements(), t -> this.visitRightPadded((JRightPadded)t, loc.getElementLocation(), p));
        this.setCursor(this.getCursor().getParent());
        return js == container.getPadding().getElements() && before == container.getBefore() ? container : JContainer.build((Space)before, (List)js, (Markers)container.getMarkers());
    }

    public <T> @Nullable JLeftPadded<T> visitLeftPadded(@Nullable JLeftPadded<T> left, KLeftPadded.Location loc, P p) {
        if (left == null) {
            return null;
        }
        this.setCursor(new Cursor(this.getCursor(), left));
        Space before = this.visitSpace(left.getBefore(), loc.getBeforeLocation(), p);
        Object t = left.getElement();
        if (t instanceof J) {
            t = this.visitAndCast((Tree)((J)left.getElement()), p);
        }
        this.setCursor(this.getCursor().getParent());
        if (t == null) {
            if (left.getElement() == null && before == left.getBefore()) {
                return left;
            }
            return null;
        }
        return before == left.getBefore() && t == left.getElement() ? left : new JLeftPadded(before, t, left.getMarkers());
    }

    public <T> @Nullable JRightPadded<T> visitRightPadded(@Nullable JRightPadded<T> right, KRightPadded.Location loc, P p) {
        if (right == null) {
            return null;
        }
        this.setCursor(new Cursor(this.getCursor(), right));
        Object t = right.getElement();
        if (t instanceof J) {
            t = this.visitAndCast((Tree)((J)right.getElement()), p);
        }
        this.setCursor(this.getCursor().getParent());
        if (t == null) {
            return null;
        }
        Space after = this.visitSpace(right.getAfter(), loc.getAfterLocation(), p);
        Markers markers = this.visitMarkers(right.getMarkers(), p);
        return after == right.getAfter() && t == right.getElement() && markers == right.getMarkers() ? right : new JRightPadded<T>(t, after, markers);
    }

    public <M extends Marker> M visitMarker(Marker marker, P p) {
        Marker m = super.visitMarker(marker, p);
        if (marker instanceof TypeReferencePrefix) {
            TypeReferencePrefix tr = (TypeReferencePrefix)marker;
            m = tr.withPrefix(this.visitSpace(tr.getPrefix(), KSpace.Location.TYPE_REFERENCE_PREFIX, p));
        }
        return (M)m;
    }
}

