/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Optional;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.ChangePropertyValue;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.maven.MavenTagInsertionComparator;
import org.openrewrite.maven.tree.ResolvedPom;
import org.openrewrite.xml.AddToTagVisitor;
import org.openrewrite.xml.ChangeTagValueVisitor;
import org.openrewrite.xml.XPathMatcher;
import org.openrewrite.xml.tree.Xml;

public final class ChangeProjectVersion
extends Recipe {
    private static final Collection<String> implicitlyDefinedVersionProperties = Arrays.asList("${version}", "${project.version}", "${pom.version}", "${project.parent.version}");
    @Option(displayName="Group", description="The group ID of the maven project to change its version. This can be a glob expression.", example="org.openrewrite")
    private final String groupId;
    @Option(displayName="Artifact", description="The artifact ID of the maven project to change its version. This can be a glob expression.", example="*")
    private final String artifactId;
    @Option(displayName="New version", description="The new version to replace the maven project version.", example="8.4.2")
    private final String newVersion;
    @Option(displayName="Override Parent Version", description="This flag can be set to explicitly override the inherited parent version. Default `false`.", required=false)
    @Nullable
    private final Boolean overrideParentVersion;

    public String getDisplayName() {
        return "Change Maven Project Version";
    }

    public String getInstanceNameSuffix() {
        return String.format("`%s:%s:%s`", this.groupId, this.artifactId, this.newVersion);
    }

    public String getDescription() {
        return "Change the project version of a Maven pom.xml. Identifies the project to be changed by its groupId and artifactId. If the version is defined as a property, this recipe will only change the property value if the property exists within the same pom.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new MavenIsoVisitor<ExecutionContext>(){
            private final XPathMatcher PROJECT_MATCHER = new XPathMatcher("/project");

            @Override
            public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext ctx) {
                ResolvedPom resolvedPom;
                Xml.Tag t = super.visitTag(tag, ctx);
                if (this.PROJECT_MATCHER.matches(this.getCursor()) && StringUtils.matchesGlob((String)(resolvedPom = this.getResolutionResult().getPom()).getValue(t.getChildValue("groupId").orElse(null)), (String)ChangeProjectVersion.this.groupId) && StringUtils.matchesGlob((String)resolvedPom.getValue(t.getChildValue("artifactId").orElse(null)), (String)ChangeProjectVersion.this.artifactId)) {
                    Optional versionTag = t.getChild("version");
                    if (versionTag.isPresent() && ((Xml.Tag)versionTag.get()).getValue().isPresent()) {
                        String versionTagValue = (String)((Xml.Tag)versionTag.get()).getValue().get();
                        String oldVersion = resolvedPom.getValue(versionTagValue);
                        assert (oldVersion != null);
                        if (!oldVersion.equals(ChangeProjectVersion.this.newVersion)) {
                            if (versionTagValue.startsWith("${") && !implicitlyDefinedVersionProperties.contains(versionTagValue)) {
                                this.doAfterVisit(new ChangePropertyValue(versionTagValue.substring(2, versionTagValue.length() - 1), ChangeProjectVersion.this.newVersion, false, false).getVisitor());
                            } else {
                                this.doAfterVisit((TreeVisitor)new ChangeTagValueVisitor((Xml.Tag)versionTag.get(), ChangeProjectVersion.this.newVersion));
                            }
                            this.maybeUpdateModel();
                        }
                    } else if (Boolean.TRUE.equals(ChangeProjectVersion.this.overrideParentVersion)) {
                        Xml.Tag newVersionTag = Xml.Tag.build((String)("<version>" + ChangeProjectVersion.this.newVersion + "</version>"));
                        this.doAfterVisit((TreeVisitor)new AddToTagVisitor(t, newVersionTag, (Comparator)new MavenTagInsertionComparator(t.getChildren())));
                        this.maybeUpdateModel();
                    }
                }
                return t;
            }
        };
    }

    public ChangeProjectVersion(String groupId, String artifactId, String newVersion, @Nullable Boolean overrideParentVersion) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.newVersion = newVersion;
        this.overrideParentVersion = overrideParentVersion;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getNewVersion() {
        return this.newVersion;
    }

    @Nullable
    public Boolean getOverrideParentVersion() {
        return this.overrideParentVersion;
    }

    @NonNull
    public String toString() {
        return "ChangeProjectVersion(groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", newVersion=" + this.getNewVersion() + ", overrideParentVersion=" + this.getOverrideParentVersion() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeProjectVersion)) {
            return false;
        }
        ChangeProjectVersion other = (ChangeProjectVersion)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$overrideParentVersion = this.getOverrideParentVersion();
        Boolean other$overrideParentVersion = other.getOverrideParentVersion();
        if (this$overrideParentVersion == null ? other$overrideParentVersion != null : !((Object)this$overrideParentVersion).equals(other$overrideParentVersion)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$artifactId = this.getArtifactId();
        String other$artifactId = other.getArtifactId();
        if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
            return false;
        }
        String this$newVersion = this.getNewVersion();
        String other$newVersion = other.getNewVersion();
        return !(this$newVersion == null ? other$newVersion != null : !this$newVersion.equals(other$newVersion));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ChangeProjectVersion;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $overrideParentVersion = this.getOverrideParentVersion();
        result = result * 59 + ($overrideParentVersion == null ? 43 : ((Object)$overrideParentVersion).hashCode());
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $artifactId = this.getArtifactId();
        result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
        String $newVersion = this.getNewVersion();
        result = result * 59 + ($newVersion == null ? 43 : $newVersion.hashCode());
        return result;
    }
}

