/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.search;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.search.DependencyInsight;
import org.openrewrite.maven.tree.Scope;

public final class DoesNotIncludeDependency
extends Recipe {
    @Option(displayName="Group", description="The first part of a dependency coordinate `com.google.guava:guava:VERSION`. Supports glob.", example="com.google.guava")
    private final String groupId;
    @Option(displayName="Artifact", description="The second part of a dependency coordinate `com.google.guava:guava:VERSION`. Supports glob.", example="guava")
    private final String artifactId;
    @Option(displayName="Only direct dependencies", description="Default false. If enabled, transitive dependencies will not be considered.", required=false, example="true")
    @Nullable
    private final Boolean onlyDirect;
    @Option(displayName="Scope", description="Default any. If specified, only the requested scope's classpaths will be checked.", required=false, valid={"compile", "test", "runtime", "provided"}, example="compile")
    @Nullable
    private final String scope;

    public String getDisplayName() {
        return "Does not include Maven dependency";
    }

    public String getInstanceNameSuffix() {
        return String.format("`%s:%s`", this.groupId, this.artifactId);
    }

    public String getDescription() {
        return "A precondition which returns false if visiting a Maven pom which includes the specified dependency in the classpath of some scope. For compatibility with multimodule projects, this should most often be applied as a precondition.";
    }

    public Validated<Object> validate() {
        return super.validate().and(Validated.notBlank((String)"groupId", (String)this.groupId).and(Validated.notBlank((String)"artifactId", (String)this.artifactId))).and(Validated.test((String)"scope", (String)"scope is a valid Maven scope", (Object)this.scope, s -> Scope.fromName(s) != Scope.Invalid));
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.not((TreeVisitor)Preconditions.or(this.dependencyInsightVisitors()));
    }

    private TreeVisitor<?, ExecutionContext>[] dependencyInsightVisitors() {
        if (this.scope == null) {
            return new TreeVisitor[]{new DependencyInsight(this.groupId, this.artifactId, null, null, this.onlyDirect).getVisitor()};
        }
        return new TreeVisitor[]{new DependencyInsight(this.groupId, this.artifactId, this.scope, null, this.onlyDirect).getVisitor()};
    }

    public DoesNotIncludeDependency(String groupId, String artifactId, @Nullable Boolean onlyDirect, @Nullable String scope) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.onlyDirect = onlyDirect;
        this.scope = scope;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    @Nullable
    public Boolean getOnlyDirect() {
        return this.onlyDirect;
    }

    @Nullable
    public String getScope() {
        return this.scope;
    }

    @NonNull
    public String toString() {
        return "DoesNotIncludeDependency(groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", onlyDirect=" + this.getOnlyDirect() + ", scope=" + this.getScope() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DoesNotIncludeDependency)) {
            return false;
        }
        DoesNotIncludeDependency other = (DoesNotIncludeDependency)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$onlyDirect = this.getOnlyDirect();
        Boolean other$onlyDirect = other.getOnlyDirect();
        if (this$onlyDirect == null ? other$onlyDirect != null : !((Object)this$onlyDirect).equals(other$onlyDirect)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$artifactId = this.getArtifactId();
        String other$artifactId = other.getArtifactId();
        if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
            return false;
        }
        String this$scope = this.getScope();
        String other$scope = other.getScope();
        return !(this$scope == null ? other$scope != null : !this$scope.equals(other$scope));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof DoesNotIncludeDependency;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $onlyDirect = this.getOnlyDirect();
        result = result * 59 + ($onlyDirect == null ? 43 : ((Object)$onlyDirect).hashCode());
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $artifactId = this.getArtifactId();
        result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
        String $scope = this.getScope();
        result = result * 59 + ($scope == null ? 43 : $scope.hashCode());
        return result;
    }
}

