/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.Optional;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.maven.MavenVisitor;
import org.openrewrite.maven.table.MavenMetadataFailures;
import org.openrewrite.xml.ChangeTagValueVisitor;
import org.openrewrite.xml.tree.Xml;

public final class ChangePluginGroupIdAndArtifactId
extends Recipe {
    private final MavenMetadataFailures metadataFailures = new MavenMetadataFailures(this);
    @Option(displayName="Old group ID", description="The old group ID to replace. The group ID is the first part of a plugin coordinate 'com.google.guava:guava:VERSION'. Supports glob expressions.", example="org.openrewrite.recipe")
    private final String oldGroupId;
    @Option(displayName="Old artifact ID", description="The old artifactId to replace. The artifact ID is the second part of a plugin coordinate 'com.google.guava:guava:VERSION'. Supports glob expressions.", example="my-deprecated-maven-plugin")
    private final String oldArtifactId;
    @Option(displayName="New group ID", description="The new group ID to use.", example="corp.internal.openrewrite.recipe", required=false)
    private final @Nullable String newGroupId;
    @Option(displayName="New artifact ID", description="The new artifact ID to use.", example="my-new-maven-plugin", required=false)
    private final @Nullable String newArtifactId;
    @Option(displayName="New version", description="An exact version number.", example="29.X", required=false)
    private final @Nullable String newVersion;

    public String getDisplayName() {
        return "Change Maven plugin group and artifact ID";
    }

    public String getInstanceNameSuffix() {
        return String.format("`%s:%s`", this.newGroupId, this.newArtifactId);
    }

    public String getDescription() {
        return "Change the groupId and/or the artifactId of a specified Maven plugin. Optionally update the plugin version. This recipe does not perform any validation and assumes all values passed are valid.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new MavenVisitor<ExecutionContext>(){

            public Xml visitTag(Xml.Tag tag, ExecutionContext ctx) {
                Xml.Tag t = (Xml.Tag)super.visitTag(tag, (Object)ctx);
                if (this.isPluginTag(ChangePluginGroupIdAndArtifactId.this.oldGroupId, ChangePluginGroupIdAndArtifactId.this.oldArtifactId)) {
                    if (ChangePluginGroupIdAndArtifactId.this.newGroupId != null) {
                        t = this.changeChildTagValue(t, "groupId", ChangePluginGroupIdAndArtifactId.this.newGroupId, ctx);
                    }
                    if (ChangePluginGroupIdAndArtifactId.this.newArtifactId != null) {
                        t = this.changeChildTagValue(t, "artifactId", ChangePluginGroupIdAndArtifactId.this.newArtifactId, ctx);
                    }
                    if (ChangePluginGroupIdAndArtifactId.this.newVersion != null) {
                        t = this.changeChildTagValue(t, "version", ChangePluginGroupIdAndArtifactId.this.newVersion, ctx);
                    }
                    if (t != tag) {
                        this.maybeUpdateModel();
                    }
                }
                return t;
            }

            private Xml.Tag changeChildTagValue(Xml.Tag tag, String childTagName, String newValue, ExecutionContext ctx) {
                Optional childTag = tag.getChild(childTagName);
                if (childTag.isPresent() && !newValue.equals(((Xml.Tag)childTag.get()).getValue().orElse(null))) {
                    tag = (Xml.Tag)new ChangeTagValueVisitor((Xml.Tag)childTag.get(), newValue).visitNonNull((Tree)tag, (Object)ctx);
                }
                return tag;
            }
        };
    }

    @Generated
    public ChangePluginGroupIdAndArtifactId(String oldGroupId, String oldArtifactId, @Nullable String newGroupId, @Nullable String newArtifactId, @Nullable String newVersion) {
        this.oldGroupId = oldGroupId;
        this.oldArtifactId = oldArtifactId;
        this.newGroupId = newGroupId;
        this.newArtifactId = newArtifactId;
        this.newVersion = newVersion;
    }

    @Generated
    public MavenMetadataFailures getMetadataFailures() {
        return this.metadataFailures;
    }

    @Generated
    public String getOldGroupId() {
        return this.oldGroupId;
    }

    @Generated
    public String getOldArtifactId() {
        return this.oldArtifactId;
    }

    @Generated
    public @Nullable String getNewGroupId() {
        return this.newGroupId;
    }

    @Generated
    public @Nullable String getNewArtifactId() {
        return this.newArtifactId;
    }

    @Generated
    public @Nullable String getNewVersion() {
        return this.newVersion;
    }

    @NonNull
    @Generated
    public String toString() {
        return "ChangePluginGroupIdAndArtifactId(metadataFailures=" + (Object)((Object)this.getMetadataFailures()) + ", oldGroupId=" + this.getOldGroupId() + ", oldArtifactId=" + this.getOldArtifactId() + ", newGroupId=" + this.getNewGroupId() + ", newArtifactId=" + this.getNewArtifactId() + ", newVersion=" + this.getNewVersion() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangePluginGroupIdAndArtifactId)) {
            return false;
        }
        ChangePluginGroupIdAndArtifactId other = (ChangePluginGroupIdAndArtifactId)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$oldGroupId = this.getOldGroupId();
        String other$oldGroupId = other.getOldGroupId();
        if (this$oldGroupId == null ? other$oldGroupId != null : !this$oldGroupId.equals(other$oldGroupId)) {
            return false;
        }
        String this$oldArtifactId = this.getOldArtifactId();
        String other$oldArtifactId = other.getOldArtifactId();
        if (this$oldArtifactId == null ? other$oldArtifactId != null : !this$oldArtifactId.equals(other$oldArtifactId)) {
            return false;
        }
        String this$newGroupId = this.getNewGroupId();
        String other$newGroupId = other.getNewGroupId();
        if (this$newGroupId == null ? other$newGroupId != null : !this$newGroupId.equals(other$newGroupId)) {
            return false;
        }
        String this$newArtifactId = this.getNewArtifactId();
        String other$newArtifactId = other.getNewArtifactId();
        if (this$newArtifactId == null ? other$newArtifactId != null : !this$newArtifactId.equals(other$newArtifactId)) {
            return false;
        }
        String this$newVersion = this.getNewVersion();
        String other$newVersion = other.getNewVersion();
        return !(this$newVersion == null ? other$newVersion != null : !this$newVersion.equals(other$newVersion));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof ChangePluginGroupIdAndArtifactId;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $oldGroupId = this.getOldGroupId();
        result = result * 59 + ($oldGroupId == null ? 43 : $oldGroupId.hashCode());
        String $oldArtifactId = this.getOldArtifactId();
        result = result * 59 + ($oldArtifactId == null ? 43 : $oldArtifactId.hashCode());
        String $newGroupId = this.getNewGroupId();
        result = result * 59 + ($newGroupId == null ? 43 : $newGroupId.hashCode());
        String $newArtifactId = this.getNewArtifactId();
        result = result * 59 + ($newArtifactId == null ? 43 : $newArtifactId.hashCode());
        String $newVersion = this.getNewVersion();
        result = result * 59 + ($newVersion == null ? 43 : $newVersion.hashCode());
        return result;
    }
}

