/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.graph;

import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.graph.GradleDependencyGraphBuilder;
import org.openrewrite.maven.graph.MavenDependencyGraphBuilder;
import org.openrewrite.maven.tree.ResolvedDependency;
import org.openrewrite.maven.tree.ResolvedGroupArtifactVersion;

public class DependencyGraph {
    private final MavenDependencyGraphBuilder mavenBuilder = new MavenDependencyGraphBuilder();
    private final GradleDependencyGraphBuilder gradleBuilder = new GradleDependencyGraphBuilder();

    public void collectMavenDependencyPaths(List<ResolvedDependency> dependencies, Map<ResolvedGroupArtifactVersion, List<DependencyPath>> paths, String scope) {
        this.mavenBuilder.collectDependencyPaths(dependencies, paths, scope);
    }

    public void collectGradleDependencyPaths(List<ResolvedDependency> dependencies, Map<ResolvedGroupArtifactVersion, List<DependencyPath>> paths, String scope) {
        this.gradleBuilder.collectDependencyPaths(dependencies, paths, scope);
    }

    public String buildDependencyGraph(ResolvedGroupArtifactVersion gav, Map<ResolvedGroupArtifactVersion, List<DependencyPath>> projectPaths, int minDepth, String scopeOrConfiguration) {
        if (projectPaths == null || !projectPaths.containsKey(gav)) {
            return this.formatDependency(gav.getGroupId(), gav.getArtifactId(), gav.getVersion()) + "\n\\--- " + scopeOrConfiguration;
        }
        List<DependencyPath> paths = projectPaths.get(gav);
        if (paths.isEmpty()) {
            return this.formatDependency(gav.getGroupId(), gav.getArtifactId(), gav.getVersion()) + "\n\\--- " + scopeOrConfiguration;
        }
        String actualScopeOrConfig = this.determineScopeOrConfig(paths, scopeOrConfiguration);
        if (minDepth == 0) {
            return this.buildDirectDependencyGraph(gav, paths, actualScopeOrConfig);
        }
        return this.buildInverseDependencyTree(gav, projectPaths, actualScopeOrConfig);
    }

    private String determineScopeOrConfig(List<DependencyPath> paths, String defaultScopeOrConfig) {
        DependencyPath firstPath;
        if (!paths.isEmpty() && (firstPath = paths.get(0)).getScope() != null && !firstPath.getScope().isEmpty()) {
            return firstPath.getScope();
        }
        return defaultScopeOrConfig;
    }

    private String buildDirectDependencyGraph(ResolvedGroupArtifactVersion gav, List<DependencyPath> paths, String scopeOrConfig) {
        GradleDependencyNode node;
        DependencyPath firstPath = paths.get(0);
        if (firstPath.getPath().size() == 1 && firstPath.getPath().get(0) instanceof GradleDependencyNode && (node = (GradleDependencyNode)firstPath.getPath().get(0)).getResolvedDependency() != null) {
            return this.render(node.getResolvedDependency(), scopeOrConfig);
        }
        return this.formatDependency(gav.getGroupId(), gav.getArtifactId(), gav.getVersion()) + "\n\\--- " + scopeOrConfig;
    }

    public String render(ResolvedDependency dependency, String configuration) {
        return this.formatDependency(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion()) + "\n\\--- " + configuration;
    }

    public String buildInverseDependencyTree(ResolvedGroupArtifactVersion gav, Map<ResolvedGroupArtifactVersion, List<DependencyPath>> projectPaths, String scopeOrConfiguration) {
        List<DependencyPath> paths = projectPaths.get(gav);
        if (paths == null || paths.isEmpty()) {
            return "";
        }
        StringBuilder tree = new StringBuilder();
        tree.append(this.formatDependency(gav.getGroupId(), gav.getArtifactId(), gav.getVersion()));
        DependencyPath path = paths.get(0);
        if (!path.getPath().isEmpty()) {
            this.appendDependencyPath(tree, path.getPath(), scopeOrConfiguration);
        }
        return tree.toString();
    }

    private void appendDependencyPath(StringBuilder tree, List<DependencyNode> nodes, String scopeOrConfiguration) {
        if (nodes.isEmpty()) {
            this.appendIndentedLine(tree, 0, scopeOrConfiguration);
            return;
        }
        for (int i = 1; i < nodes.size(); ++i) {
            DependencyNode parent = nodes.get(i);
            this.appendIndentedLine(tree, i - 1, this.formatDependency(parent.getGroupId(), parent.getArtifactId(), parent.getVersion()));
        }
        this.appendIndentedLine(tree, Math.max(0, nodes.size() - 1), scopeOrConfiguration);
    }

    private void appendIndentedLine(StringBuilder tree, int depth, String content) {
        tree.append("\n");
        for (int i = 0; i < depth; ++i) {
            tree.append("     ");
        }
        tree.append("\\--- ").append(content);
    }

    private String formatDependency(String groupId, String artifactId, String version) {
        return groupId + ":" + artifactId + ":" + version;
    }

    public static final class DependencyPath {
        private final List<DependencyNode> path;
        private final String scope;

        @Generated
        public DependencyPath(List<DependencyNode> path, String scope) {
            this.path = path;
            this.scope = scope;
        }

        @Generated
        public List<DependencyNode> getPath() {
            return this.path;
        }

        @Generated
        public String getScope() {
            return this.scope;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DependencyPath)) {
                return false;
            }
            DependencyPath other = (DependencyPath)o;
            List<DependencyNode> this$path = this.getPath();
            List<DependencyNode> other$path = other.getPath();
            if (this$path == null ? other$path != null : !((Object)this$path).equals(other$path)) {
                return false;
            }
            String this$scope = this.getScope();
            String other$scope = other.getScope();
            return !(this$scope == null ? other$scope != null : !this$scope.equals(other$scope));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<DependencyNode> $path = this.getPath();
            result = result * 59 + ($path == null ? 43 : ((Object)$path).hashCode());
            String $scope = this.getScope();
            result = result * 59 + ($scope == null ? 43 : $scope.hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "DependencyGraph.DependencyPath(path=" + this.getPath() + ", scope=" + this.getScope() + ")";
        }
    }

    public static class GradleDependencyNode
    extends DependencyNode {
        ResolvedDependency resolvedDependency;

        public GradleDependencyNode(String groupId, String artifactId, String version, String scope, ResolvedDependency resolvedDependency) {
            super(groupId, artifactId, version, scope);
            this.resolvedDependency = resolvedDependency;
        }

        @Generated
        public ResolvedDependency getResolvedDependency() {
            return this.resolvedDependency;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GradleDependencyNode)) {
                return false;
            }
            GradleDependencyNode other = (GradleDependencyNode)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ResolvedDependency this$resolvedDependency = this.getResolvedDependency();
            ResolvedDependency other$resolvedDependency = other.getResolvedDependency();
            return !(this$resolvedDependency == null ? other$resolvedDependency != null : !((Object)this$resolvedDependency).equals(other$resolvedDependency));
        }

        @Generated
        protected boolean canEqual(@Nullable Object other) {
            return other instanceof GradleDependencyNode;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            ResolvedDependency $resolvedDependency = this.getResolvedDependency();
            result = result * 59 + ($resolvedDependency == null ? 43 : ((Object)$resolvedDependency).hashCode());
            return result;
        }
    }

    public static class DependencyNode {
        String groupId;
        String artifactId;
        String version;
        String scope;

        @Generated
        public String getGroupId() {
            return this.groupId;
        }

        @Generated
        public String getArtifactId() {
            return this.artifactId;
        }

        @Generated
        public String getVersion() {
            return this.version;
        }

        @Generated
        public String getScope() {
            return this.scope;
        }

        @Generated
        public DependencyNode(String groupId, String artifactId, String version, String scope) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.version = version;
            this.scope = scope;
        }
    }
}

