/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.toml;

import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.toml.SemanticallyEqual;
import org.openrewrite.toml.TableRowMatcher;
import org.openrewrite.toml.TomlParser;
import org.openrewrite.toml.TomlVisitor;
import org.openrewrite.toml.tree.Toml;
import org.openrewrite.toml.tree.TomlValue;

public final class ChangeTableRowValue
extends Recipe {
    @Option(displayName="Table name", description="The name of the TOML array table containing the row to update.", example="package.contributors")
    private final String tableName;
    @Option(displayName="Identifying key", description="The key within a table row to match on.", example="name")
    private final String identifyingKey;
    @Option(displayName="Identifying value", description="The value to match. Can be a regular expression if useRegex is true.", example="Alice Smith")
    private final String identifyingValue;
    @Option(displayName="Use regex", description="Whether to interpret the identifying value as a regular expression. Default is false.", required=false)
    private final @Nullable Boolean useRegex;
    @Option(displayName="Property key", description="The key of the property to update within the matched row.", example="email")
    private final String propertyKey;
    @Option(displayName="New value", description="The new value to set for the property. If null, the property will be removed.", example="\"alice.new@example.com\"", required=false)
    private final @Nullable String newValue;

    public String getDisplayName() {
        return "Change TOML table row value";
    }

    public String getDescription() {
        return "Change a value in a TOML table row when the identifying property matches the specified matcher.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new TomlVisitor<ExecutionContext>(){

            @Override
            public Toml visitTable(Toml.Table table, ExecutionContext ctx) {
                if (table.getName() == null || !ChangeTableRowValue.this.tableName.equals(table.getName().getName())) {
                    return super.visitTable(table, ctx);
                }
                if (!TableRowMatcher.hasMatchingKeyValue(table, ChangeTableRowValue.this.identifyingKey, ChangeTableRowValue.this.identifyingValue, ChangeTableRowValue.this.useRegex)) {
                    return super.visitTable(table, ctx);
                }
                return table.withValues(ListUtils.map(table.getValues(), value -> {
                    if (!(value instanceof Toml.KeyValue)) {
                        return value;
                    }
                    Toml.KeyValue kv = (Toml.KeyValue)value;
                    if (kv.getKey() instanceof Toml.Identifier && ChangeTableRowValue.this.propertyKey.equals(((Toml.Identifier)kv.getKey()).getName())) {
                        if (ChangeTableRowValue.this.newValue == null) {
                            return null;
                        }
                        Toml.KeyValue newKv = this.parseKeyValue(ChangeTableRowValue.this.propertyKey, ChangeTableRowValue.this.newValue);
                        if (newKv != null && !SemanticallyEqual.areEqual(kv, newKv)) {
                            return newKv.withPrefix(kv.getPrefix());
                        }
                    }
                    return value;
                }));
            }

            private @Nullable Toml.KeyValue parseKeyValue(String key, String value) {
                try {
                    TomlValue firstValue;
                    String tomlDoc = key + " = " + value.trim();
                    Toml.Document doc = new TomlParser().parse(tomlDoc).findFirst().map(Toml.Document.class::cast).orElse(null);
                    if (doc != null && !doc.getValues().isEmpty() && (firstValue = doc.getValues().get(0)) instanceof Toml.KeyValue) {
                        return (Toml.KeyValue)firstValue;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return null;
            }
        };
    }

    @Generated
    public ChangeTableRowValue(String tableName, String identifyingKey, String identifyingValue, @Nullable Boolean useRegex, String propertyKey, @Nullable String newValue) {
        this.tableName = tableName;
        this.identifyingKey = identifyingKey;
        this.identifyingValue = identifyingValue;
        this.useRegex = useRegex;
        this.propertyKey = propertyKey;
        this.newValue = newValue;
    }

    @Generated
    public String getTableName() {
        return this.tableName;
    }

    @Generated
    public String getIdentifyingKey() {
        return this.identifyingKey;
    }

    @Generated
    public String getIdentifyingValue() {
        return this.identifyingValue;
    }

    @Generated
    public @Nullable Boolean getUseRegex() {
        return this.useRegex;
    }

    @Generated
    public String getPropertyKey() {
        return this.propertyKey;
    }

    @Generated
    public @Nullable String getNewValue() {
        return this.newValue;
    }

    @NonNull
    @Generated
    public String toString() {
        return "ChangeTableRowValue(tableName=" + this.getTableName() + ", identifyingKey=" + this.getIdentifyingKey() + ", identifyingValue=" + this.getIdentifyingValue() + ", useRegex=" + this.getUseRegex() + ", propertyKey=" + this.getPropertyKey() + ", newValue=" + this.getNewValue() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeTableRowValue)) {
            return false;
        }
        ChangeTableRowValue other = (ChangeTableRowValue)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$useRegex = this.getUseRegex();
        Boolean other$useRegex = other.getUseRegex();
        if (this$useRegex == null ? other$useRegex != null : !((Object)this$useRegex).equals(other$useRegex)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        String this$identifyingKey = this.getIdentifyingKey();
        String other$identifyingKey = other.getIdentifyingKey();
        if (this$identifyingKey == null ? other$identifyingKey != null : !this$identifyingKey.equals(other$identifyingKey)) {
            return false;
        }
        String this$identifyingValue = this.getIdentifyingValue();
        String other$identifyingValue = other.getIdentifyingValue();
        if (this$identifyingValue == null ? other$identifyingValue != null : !this$identifyingValue.equals(other$identifyingValue)) {
            return false;
        }
        String this$propertyKey = this.getPropertyKey();
        String other$propertyKey = other.getPropertyKey();
        if (this$propertyKey == null ? other$propertyKey != null : !this$propertyKey.equals(other$propertyKey)) {
            return false;
        }
        String this$newValue = this.getNewValue();
        String other$newValue = other.getNewValue();
        return !(this$newValue == null ? other$newValue != null : !this$newValue.equals(other$newValue));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof ChangeTableRowValue;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $useRegex = this.getUseRegex();
        result = result * 59 + ($useRegex == null ? 43 : ((Object)$useRegex).hashCode());
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        String $identifyingKey = this.getIdentifyingKey();
        result = result * 59 + ($identifyingKey == null ? 43 : $identifyingKey.hashCode());
        String $identifyingValue = this.getIdentifyingValue();
        result = result * 59 + ($identifyingValue == null ? 43 : $identifyingValue.hashCode());
        String $propertyKey = this.getPropertyKey();
        result = result * 59 + ($propertyKey == null ? 43 : $propertyKey.hashCode());
        String $newValue = this.getNewValue();
        result = result * 59 + ($newValue == null ? 43 : $newValue.hashCode());
        return result;
    }
}

