/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.toml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.intellij.lang.annotations.Language;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markers;
import org.openrewrite.toml.SemanticallyEqual;
import org.openrewrite.toml.TableRowMatcher;
import org.openrewrite.toml.TomlParser;
import org.openrewrite.toml.TomlVisitor;
import org.openrewrite.toml.marker.ArrayTable;
import org.openrewrite.toml.tree.Space;
import org.openrewrite.toml.tree.Toml;
import org.openrewrite.toml.tree.TomlRightPadded;
import org.openrewrite.toml.tree.TomlValue;

public final class MergeTableRow
extends Recipe {
    @Option(displayName="Table name", description="The name of the TOML array table to merge into (e.g., 'package.contributors').", example="package.contributors")
    private final String tableName;
    @Option(displayName="TOML row snippet", description="The TOML key-value pairs to merge. Should contain the objectIdentifyingProperty.", example="name = \"Alice Smith\"\\nemail = \"alice@example.com\"")
    @Language(value="toml")
    private final String row;
    @Option(displayName="Object identifying property", description="The property name used to match existing rows. When a row with this property value exists, it will be merged; otherwise, a new row is inserted. When the original row has more properties than the incoming row, these original properties are preserved. Entries with null values in the incoming row will result in the removal of the property from the original row.", example="name")
    private final String identifyingKey;

    public String getDisplayName() {
        return "Merge TOML table row";
    }

    public String getDescription() {
        return "Merge a TOML row into an array table. If a row with the same identifying property exists, merge the values. Otherwise, insert a new row.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new TomlVisitor<ExecutionContext>(){

            @Override
            public Toml visitDocument(Toml.Document document, ExecutionContext ctx) {
                Toml.Document doc = (Toml.Document)super.visitDocument(document, ctx);
                if (doc != document) {
                    return doc;
                }
                List<Toml.KeyValue> keyValues = this.parseTomlRow(MergeTableRow.this.row);
                if (keyValues.isEmpty()) {
                    return doc;
                }
                String identifyingValue = TableRowMatcher.getKeyValue(keyValues, MergeTableRow.this.identifyingKey);
                if (identifyingValue == null) {
                    return doc;
                }
                for (TomlValue value : doc.getValues()) {
                    String tableIdentifyingValue;
                    Object table;
                    if (!(value instanceof Toml.Table) || ((Toml.Table)(table = (Toml.Table)value)).getName() == null || !MergeTableRow.this.tableName.equals(((Toml.Table)table).getName().getName()) || !identifyingValue.equals(tableIdentifyingValue = TableRowMatcher.getKeyValue((Toml.Table)table, MergeTableRow.this.identifyingKey))) continue;
                    return doc;
                }
                Toml.Identifier identifier = new Toml.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, MergeTableRow.this.tableName, MergeTableRow.this.tableName);
                ArrayList<TomlRightPadded<Toml>> values = new ArrayList<TomlRightPadded<Toml>>();
                for (Toml.KeyValue kv : keyValues) {
                    Toml.KeyValue kvWithPrefix = kv.withPrefix(Space.format("\n"));
                    values.add(new TomlRightPadded<Toml.KeyValue>(kvWithPrefix, Space.EMPTY, Markers.EMPTY));
                }
                Markers markers = Markers.EMPTY.add((Marker)new ArrayTable(Tree.randomId()));
                Toml.Table newTable = new Toml.Table(Tree.randomId(), Space.format("\n\n"), markers, new TomlRightPadded<Toml.Identifier>(identifier, Space.EMPTY, Markers.EMPTY), values);
                return doc.withValues(ListUtils.concat(doc.getValues(), (Object)newTable));
            }

            @Override
            public Toml visitTable(Toml.Table table, ExecutionContext ctx) {
                if (table.getName() == null || !MergeTableRow.this.tableName.equals(table.getName().getName())) {
                    return super.visitTable(table, ctx);
                }
                List<Toml.KeyValue> incomingKeyValues = this.parseTomlRow(MergeTableRow.this.row);
                if (incomingKeyValues.isEmpty()) {
                    return super.visitTable(table, ctx);
                }
                String identifyingValue = TableRowMatcher.getKeyValue(incomingKeyValues, MergeTableRow.this.identifyingKey);
                if (identifyingValue == null) {
                    return super.visitTable(table, ctx);
                }
                String tableIdentifyingValue = TableRowMatcher.getKeyValue(table, MergeTableRow.this.identifyingKey);
                if (identifyingValue.equals(tableIdentifyingValue)) {
                    return table.withValues(ListUtils.concatAll((List)ListUtils.map(table.getValues(), value -> {
                        if (!(value instanceof Toml.KeyValue)) {
                            return value;
                        }
                        Toml.KeyValue existingKv = (Toml.KeyValue)value;
                        for (int i = 0; i < incomingKeyValues.size(); ++i) {
                            Toml.KeyValue incomingKv = (Toml.KeyValue)incomingKeyValues.get(i);
                            if (!SemanticallyEqual.areEqual(existingKv.getKey(), incomingKv.getKey())) continue;
                            incomingKeyValues.remove(i);
                            if (incomingKv.getValue() == null) {
                                return null;
                            }
                            if (!SemanticallyEqual.areEqual(existingKv.getValue(), incomingKv.getValue())) {
                                return existingKv.withValue(incomingKv.getValue());
                            }
                            return existingKv;
                        }
                        return existingKv;
                    }), (List)ListUtils.map(incomingKeyValues, kv -> {
                        if (kv.getValue() != null) {
                            return kv;
                        }
                        return null;
                    })));
                }
                return super.visitTable(table, ctx);
            }

            private List<Toml.KeyValue> parseTomlRow(@Language(value="toml") String tomlContent) {
                try {
                    Toml.Document doc = new TomlParser().parse(tomlContent).findFirst().map(Toml.Document.class::cast).orElse(null);
                    if (doc != null && !doc.getValues().isEmpty()) {
                        ArrayList<Toml.KeyValue> result = new ArrayList<Toml.KeyValue>();
                        for (TomlValue value : doc.getValues()) {
                            if (!(value instanceof Toml.KeyValue)) continue;
                            result.add((Toml.KeyValue)value);
                        }
                        return result;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return Collections.emptyList();
            }
        };
    }

    @Generated
    public MergeTableRow(String tableName, @Language(value="toml") String row, String identifyingKey) {
        this.tableName = tableName;
        this.row = row;
        this.identifyingKey = identifyingKey;
    }

    @Generated
    public String getTableName() {
        return this.tableName;
    }

    @Language(value="toml")
    @Generated
    public String getRow() {
        return this.row;
    }

    @Generated
    public String getIdentifyingKey() {
        return this.identifyingKey;
    }

    @NonNull
    @Generated
    public String toString() {
        return "MergeTableRow(tableName=" + this.getTableName() + ", row=" + this.getRow() + ", identifyingKey=" + this.getIdentifyingKey() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MergeTableRow)) {
            return false;
        }
        MergeTableRow other = (MergeTableRow)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        String this$row = this.getRow();
        String other$row = other.getRow();
        if (this$row == null ? other$row != null : !this$row.equals(other$row)) {
            return false;
        }
        String this$identifyingKey = this.getIdentifyingKey();
        String other$identifyingKey = other.getIdentifyingKey();
        return !(this$identifyingKey == null ? other$identifyingKey != null : !this$identifyingKey.equals(other$identifyingKey));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof MergeTableRow;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        String $row = this.getRow();
        result = result * 59 + ($row == null ? 43 : $row.hashCode());
        String $identifyingKey = this.getIdentifyingKey();
        result = result * 59 + ($identifyingKey == null ? 43 : $identifyingKey.hashCode());
        return result;
    }
}

