/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.xml.trait;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.trait.SimpleTraitMatcher;
import org.openrewrite.trait.Trait;
import org.openrewrite.xml.XPathMatcher;
import org.openrewrite.xml.tree.Xml;

public final class Namespaced
implements Trait<Xml> {
    public static final String XML_SCHEMA_INSTANCE_URI = "http://www.w3.org/2001/XMLSchema-instance";
    private final Cursor cursor;

    public Optional<String> getName() {
        Optional<String> maybeName = Optional.empty();
        if (this.cursor.getValue() instanceof Xml.Tag) {
            maybeName = Optional.of(((Xml.Tag)this.cursor.getValue()).getName());
        } else if (this.cursor.getValue() instanceof Xml.Attribute) {
            Xml.Attribute attribute = (Xml.Attribute)this.cursor.getValue();
            maybeName = Optional.of(attribute.getKey().getName());
        }
        return maybeName;
    }

    public Optional<String> getLocalName() {
        Optional<String> maybeLocalName = Optional.empty();
        if (this.cursor.getValue() instanceof Xml.Tag) {
            Xml.Tag tag = (Xml.Tag)this.cursor.getValue();
            maybeLocalName = Optional.of(Namespaced.extractLocalName(tag.getName()));
        } else if (this.cursor.getValue() instanceof Xml.Attribute) {
            Xml.Attribute attribute = (Xml.Attribute)this.cursor.getValue();
            maybeLocalName = Optional.of(Namespaced.extractLocalName(attribute.getKeyAsString()));
        }
        return maybeLocalName;
    }

    public Optional<String> getNamespacePrefix() {
        String extractedNamespacePrefix = null;
        if (this.cursor.getValue() instanceof Xml.Tag) {
            Xml.Tag tag = (Xml.Tag)this.cursor.getValue();
            extractedNamespacePrefix = Namespaced.extractNamespacePrefix(tag.getName());
        } else if (this.cursor.getValue() instanceof Xml.Attribute) {
            Xml.Attribute attribute = (Xml.Attribute)this.cursor.getValue();
            extractedNamespacePrefix = Namespaced.extractNamespacePrefix(attribute.getKeyAsString());
        }
        return StringUtils.isBlank(extractedNamespacePrefix) ? Optional.empty() : Optional.of(extractedNamespacePrefix);
    }

    public Optional<String> getNamespaceUri() {
        return this.getNamespacePrefix().map(s -> this.getAllNamespaces().get(s));
    }

    public Map<String, String> getNamespaces() {
        Map<String, String> namespaces = Collections.emptyMap();
        if (this.cursor.getValue() instanceof Xml.Tag) {
            Xml.Tag tag = (Xml.Tag)this.cursor.getValue();
            if (!tag.getAttributes().isEmpty()) {
                namespaces = new LinkedHashMap<String, String>(tag.getAttributes().size());
                for (Xml.Attribute attribute : tag.getAttributes()) {
                    if (!Namespaced.isNamespaceDefinitionAttribute(attribute.getKeyAsString())) continue;
                    namespaces.put(Namespaced.extractPrefixFromNamespaceDefinition(attribute.getKeyAsString()), attribute.getValueAsString());
                }
            }
        } else if (this.cursor.getValue() instanceof Xml.Attribute) {
            Xml.Attribute attribute = (Xml.Attribute)this.cursor.getValue();
            namespaces = Collections.singletonMap(Namespaced.extractPrefixFromNamespaceDefinition(attribute.getKeyAsString()), attribute.getValueAsString());
        }
        return namespaces;
    }

    public List<Xml.Attribute> getSchemaLocations() {
        if (this.cursor.getValue() instanceof Xml.Tag) {
            Xml.Tag tag = (Xml.Tag)this.cursor.getValue();
            if (tag.getAttributes().isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<Xml.Attribute> schemaLocations = new ArrayList<Xml.Attribute>();
            Map<String, String> namespaces = this.getAllNamespaces();
            for (Xml.Attribute attribute : tag.getAttributes()) {
                if (!XML_SCHEMA_INSTANCE_URI.equals(namespaces.get(Namespaced.extractNamespacePrefix(attribute.getKeyAsString())))) continue;
                schemaLocations.add(attribute);
            }
            return schemaLocations;
        }
        return Collections.emptyList();
    }

    public List<Xml.Attribute> getAttributes() {
        if (this.cursor.getValue() instanceof Xml.Tag) {
            Xml.Tag tag = (Xml.Tag)this.cursor.getValue();
            return tag.getAttributes();
        }
        if (this.cursor.getValue() instanceof Xml.Attribute) {
            return Collections.singletonList((Xml.Attribute)this.cursor.getValue());
        }
        return Collections.emptyList();
    }

    public List<String> attributePrefixes() {
        return this.getAttributes().stream().map(Xml.Attribute::getKeyAsString).map(Namespaced::extractNamespacePrefix).filter(StringUtils::isNotEmpty).distinct().collect(Collectors.toList());
    }

    public Map<String, String> getAllNamespaces() {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(this.getNamespaces());
        if (this.cursor.getParent() != null) {
            result.putAll(new Namespaced(this.cursor.getParent()).getAllNamespaces());
        }
        return result;
    }

    public static boolean isNamespaceDefinitionAttribute(String name) {
        return name.startsWith("xmlns");
    }

    public static String getAttributeNameForPrefix(String namespacePrefix) {
        return namespacePrefix.isEmpty() ? "xmlns" : "xmlns:" + namespacePrefix;
    }

    public static @Nullable String extractPrefixFromNamespaceDefinition(String name) {
        if (!Namespaced.isNamespaceDefinitionAttribute(name)) {
            return null;
        }
        return "xmlns".equals(name) ? "" : Namespaced.extractLocalName(name);
    }

    public static String extractNamespacePrefix(String name) {
        int colon = name.indexOf(58);
        return colon == -1 ? "" : name.substring(0, colon);
    }

    public static String extractLocalName(String name) {
        int colon = name.indexOf(58);
        return colon == -1 ? name : name.substring(colon + 1);
    }

    public static Matcher matcher() {
        return new Matcher();
    }

    @Generated
    public Namespaced(Cursor cursor) {
        this.cursor = cursor;
    }

    @Generated
    public Cursor getCursor() {
        return this.cursor;
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Namespaced)) {
            return false;
        }
        Namespaced other = (Namespaced)o;
        Cursor this$cursor = this.getCursor();
        Cursor other$cursor = other.getCursor();
        return !(this$cursor == null ? other$cursor != null : !this$cursor.equals(other$cursor));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Cursor $cursor = this.getCursor();
        result = result * 59 + ($cursor == null ? 43 : $cursor.hashCode());
        return result;
    }

    @NonNull
    @Generated
    public String toString() {
        return "Namespaced(cursor=" + this.getCursor() + ")";
    }

    public static class Matcher
    extends SimpleTraitMatcher<Namespaced> {
        private @Nullable String prefix;
        private @Nullable String uri;
        private @Nullable XPathMatcher xPath;

        public Matcher prefix(@Nullable String prefix) {
            this.prefix = prefix;
            return this;
        }

        public Matcher uri(@Nullable String uri) {
            this.uri = uri;
            return this;
        }

        public Matcher xPath(@Nullable String xPath) {
            if (xPath != null) {
                this.xPath = new XPathMatcher(xPath);
            }
            return this;
        }

        public Matcher xPath(@Nullable XPathMatcher xPath) {
            this.xPath = xPath;
            return this;
        }

        protected @Nullable Namespaced test(Cursor cursor) {
            if (this.xPath != null && !this.xPath.matches(cursor)) {
                return null;
            }
            Namespaced namespaced = new Namespaced(cursor);
            if (this.uri != null || this.prefix != null) {
                Map<String, String> namespaces = namespaced.getNamespaces();
                if (this.uri != null && !namespaces.containsValue(this.uri) || this.prefix != null && !namespaces.containsKey(this.prefix)) {
                    return null;
                }
            }
            return namespaced;
        }
    }
}

