/* Generated By:JavaCC: Do not edit this line. NomParser.java */
/*   Copyright (C) 2003-2007  University of Manchester
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA. 
 *   (or see http://www.gnu.org/copyleft/lesser.html)
 */
package org.openscience.cdk.iupac.parser;

import java.io.StringReader;
import org.openscience.cdk.DefaultChemObjectBuilder;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.exception.*;
import java.util.*;

/**
 * A class partly generated by <a href="http://javacc.dev.java.net" target="_top">JavaCC</a> which breaks down the chemical name
 * into computable subparts and passes these parts to the MoleculeBuilder.
 *
 * @author David Robinson (University of Manchester)
 * @author Bhupinder Sandhu
 * @author Stephen Tomkinson
 *
 * @cdk.keyword IUPAC name
 * @deprecated The OPSIN (<a href="http://opsin.ch.cam.ac.uk/">http://opsin.ch.cam.ac.uk/</a>) tool
 *             offers a more comprehensive alternative to this parsers functionality. 
 */
public class NomParser implements NomParserConstants {
    //private variables needed throughout the program
    private static int mainChainPrefix;
    private static boolean isMainCyclic;

    /** The temporary vector of locations the current group/substituent is attached to */
    private static List<Token> tempLocation;

    /** The vector of attached functional groups, with an instance of AttachedGroup for each
     * functional group.
     */
    private static List<AttachedGroup> attachedGroups;

    /** The vector of attached substituent, with an instance of AttachedGroup for each
     * substituent.
     */
    private static List<AttachedGroup> attachedSubstituents;

    /**
     * Used in the build up of ancient Greek style prefixes
     */
    private static int currentNumber;

    /**
     * Parses the chemical name and returns the built molecule. It uses
     * the {@link DefaultChemObjectBuilder} to create a data model.
     *
     * @param stringToParse A case-insensitive name of the chemical to build.
     * @return A molecule which represents the interpretation of the name.
     * @throws ParseException Any error which occur in the parsing get wrapped
     * up in a ParseException and thrown.
     */
    public static IAtomContainer generate (String stringToParse) throws ParseException, CDKException {
        return generate(stringToParse, DefaultChemObjectBuilder.getInstance());
    }

    /**
     * Parses the chemical name and returns the built molecule. It uses the
     * given {@link IChemObjectBuilder} to create a data model.
     *
     * @param stringToParse A case-insensitive name of the chemical to build.
     * @return A molecule which represents the interpretation of the name.
     * @throws ParseException Any error which occur in the parsing get wrapped
     * up in a ParseException and thrown.
     */
    public static IAtomContainer generate (String stringToParse, IChemObjectBuilder builder) throws ParseException, CDKException
    {
        isMainCyclic = false;
        tempLocation = new ArrayList<Token>();
        attachedSubstituents = new ArrayList<AttachedGroup>();
        attachedGroups = new ArrayList<AttachedGroup>();
        currentNumber = 0;

        StringReader stringReader = new StringReader (stringToParse.toLowerCase() + "\u005cn");
        NomParser parser = new NomParser (stringReader);
        parser.completeChemicalName();

        //Scan substituents for a too high connection point
        checkConnections (attachedSubstituents.iterator());

        //Scan functional groups for a too high connection point
        checkConnections (attachedGroups.iterator());

        MoleculeBuilder moleculeBuilder = new MoleculeBuilder(builder);
        IAtomContainer returnedMolecule = moleculeBuilder.buildMolecule(mainChainPrefix, attachedSubstituents, attachedGroups, isMainCyclic, stringToParse);

        return returnedMolecule;
    }

    /**
     * Checks to ensure that all groups/substituents attached to the main chain
     * are connected to a valid atom which occurs on the main chain.
     *
     * @param vectorIterator An iterator which provides instances of AttachedGroup to check
     * @throws ParseException A tailored instance of ParseException so Nomen can display
     * the error to the user.
     */
    private static void checkConnections (Iterator<AttachedGroup> vectorIterator) throws ParseException
    {
        while (vectorIterator.hasNext())
        {
            AttachedGroup ag = vectorIterator.next();
            List<Token> locations = ag.getLocations();

            Iterator<Token> locationsIterator = locations.iterator();
            while (locationsIterator.hasNext())
            {
                Token tok =  locationsIterator.next();

                try
                {
                    if (Integer.parseInt(tok.image) > mainChainPrefix)
                    {
                        String mesg = "invalid attachment point " + Integer.parseInt(tok.image) + " must be below " + (mainChainPrefix + 1);
                        throw new ParseException(mesg);
                    }
                }
                catch (NumberFormatException nfe)
                {
                    //Do nothing, as this should never happen
                }
            }
        }
    }

/**
 * Stores "head tokens", the substituent prefix, in a vector of AttachedGroup objects.
 */
  void AddHeadToken() throws ParseException {
    attachedSubstituents.add (new AttachedGroup (tempLocation, currentNumber) );
    tempLocation = new Vector();
  }

  void MakeMainChainIntoSubstituent() throws ParseException {
    attachedSubstituents.add (new AttachedGroup (tempLocation, mainChainPrefix) );
    currentNumber = 0;
    mainChainPrefix = 0;
    tempLocation = new Vector();
  }

/**
 * Stores the functional groups in a vector of AttachedGroup objects.
 */
  void AddFunGroup() throws ParseException {
    Token tok;
    tok = getToken(-1);
    attachedGroups.add (new AttachedGroup (tempLocation, tok.image) );
    tempLocation = new Vector();
  }

/**
* Stores the functional group positions, the number of the atom they 
* connect to, in an array.
*/
  void AddFunGroupPos() throws ParseException {
    Token tok;
    tok = getToken(-1);
    tempLocation.add(tok);
  }

/**
* Adds to the position array a location of -1 to indicate no location was
* specified.
*/
  void AddUnknownFunGroupPos() throws ParseException {
    Token tok = new Token();
    tok.image = "-1";
    tempLocation.add(tok);
  }

/**
 * Store the mainChainPrefix token, the chain prefix of the longest carbon chain
 */
  void AddMainChain() throws ParseException {
    mainChainPrefix = currentNumber;
    currentNumber = 0;
  }

/**
 * Sets the main chain to be cyclic.
 */
  void SetMainCyclic() throws ParseException {
    isMainCyclic = true;
  }

/**
 * The general form all chemical names must follow.
 */
  final public void completeChemicalName() throws ParseException {
    if (jj_2_1(2)) {
      mainChainConstruct();
    } else {
      prefixConstruct();
      mainChainConstruct();
      jj_consume_token(EOL);
    }
  }

/**
 * Allows 1 or more prefixes
 */
  final public void prefixConstruct() throws ParseException {
    prefixType();
    label_1:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DASH:
        ;
        break;
      default:
        jj_la1[0] = jj_gen;
        break label_1;
      }
      jj_consume_token(DASH);
      prefixType();
    }
  }

  final public void prefixType() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CONSTANT:
      attachLocationSpecified();
      break;
    default:
      jj_la1[1] = jj_gen;
      AddUnknownFunGroupPos();
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case METH:
    case ETH:
    case PROP:
    case BUT:
    case UNDEC:
    case EICOS:
    case HENICOS:
    case HEN:
    case DO:
    case TRI:
    case TETR:
    case PENT:
    case HEX:
    case HEPT:
    case OCT:
    case NON:
    case DEC:
      subChain();
      break;
    case CHLORO:
    case FLUORO:
    case BROMO:
    case IODO:
    case NITRO:
    case OXO:
    case PHENYL:
    case AMINO:
    case HYDROXY:
      functionalGroupPrefix();
      break;
    default:
      jj_la1[2] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/** The substituent part of the prefix */
  final public void subChain() throws ParseException {
    chainPrefix();
    AddHeadToken();
    jj_consume_token(YL);
  }

/** 
 * An attach position has been specified using a 
 * comma seperated list followed by a dash
 */
  final public void attachLocationSpecified() throws ParseException {
    jj_consume_token(CONSTANT);
    AddFunGroupPos();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DASH:
      oneAttachLocation();
      break;
    case COMMA:
      twoOrThreeAttachLocations();
      break;
    default:
      jj_la1[3] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/**
 * Only one attach location specified, should be followed by a dash.
 */
  final public void oneAttachLocation() throws ParseException {
    jj_consume_token(DASH);
  }

/**
 * Two or three attach locations specidied, handle the second and if needed, the third one here.
 */
  final public void twoOrThreeAttachLocations() throws ParseException {
    jj_consume_token(COMMA);
    jj_consume_token(CONSTANT);
    AddFunGroupPos();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DASH:
      jj_consume_token(DASH);
      jj_consume_token(DI);
      break;
    case COMMA:
      jj_consume_token(COMMA);
      jj_consume_token(CONSTANT);
      AddFunGroupPos();
      jj_consume_token(DASH);
      jj_consume_token(TRI);
      break;
    default:
      jj_la1[4] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/**
 * A list of known tokens denoting a chain's length.
 */
  final public void chainPrefix() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case METH:
    case ETH:
    case PROP:
    case BUT:
    case UNDEC:
    case EICOS:
    case HENICOS:
    case DEC:
      specialCase();
      break;
    case HEN:
    case DO:
    case TRI:
    case TETR:
    case PENT:
    case HEX:
    case HEPT:
    case OCT:
    case NON:
      allBaseNumbers();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case HEN:
      case DO:
      case TRI:
      case TETR:
      case PENT:
      case HEX:
      case HEPT:
      case OCT:
      case NON:
      case DEC:
      case COS:
      case CONT:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case HEN:
        case DO:
        case TRI:
        case TETR:
        case PENT:
        case HEX:
        case HEPT:
        case OCT:
        case NON:
          tensWithUnits();
          break;
        case DEC:
        case COS:
        case CONT:
          tensNoUnits();
          break;
        default:
          jj_la1[5] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[6] = jj_gen;
        ;
      }
      break;
    default:
      jj_la1[7] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/** Deal with special cases where the rules don't apply. */
  final public void specialCase() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case METH:
      jj_consume_token(METH);
              currentNumber = 1;
      break;
    case ETH:
      jj_consume_token(ETH);
             currentNumber = 2;
      break;
    case PROP:
      jj_consume_token(PROP);
              currentNumber = 3;
      break;
    case BUT:
      jj_consume_token(BUT);
             currentNumber = 4;
      break;
    case DEC:
      jj_consume_token(DEC);
             currentNumber = 10;
      break;
    case UNDEC:
      jj_consume_token(UNDEC);
               currentNumber = 11;
      break;
    case EICOS:
      jj_consume_token(EICOS);
               currentNumber = 20;
      break;
    case HENICOS:
      jj_consume_token(HENICOS);
                 currentNumber = 21;
      break;
    default:
      jj_la1[8] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/** The usual numbers .*/
  final public void allBaseNumbers() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case HEN:
      jj_consume_token(HEN);
             currentNumber = 1;
      break;
    case DO:
      jj_consume_token(DO);
            currentNumber = 2;
      break;
    case TRI:
      jj_consume_token(TRI);
             currentNumber = 3;
      break;
    case TETR:
      jj_consume_token(TETR);
              currentNumber = 4;
      break;
    case PENT:
      jj_consume_token(PENT);
              currentNumber = 5;
      break;
    case HEX:
      jj_consume_token(HEX);
             currentNumber = 6;
      break;
    case HEPT:
      jj_consume_token(HEPT);
              currentNumber = 7;
      break;
    case OCT:
      jj_consume_token(OCT);
             currentNumber = 8;
      break;
    case NON:
      jj_consume_token(NON);
             currentNumber = 9;
      break;
    default:
      jj_la1[9] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/** Deal with fragments refering to the positioning of the base numbers (denoting their magnitude) */
  final public void tensNoUnits() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DEC:
      jj_consume_token(DEC);
            currentNumber += 10;
      break;
    case COS:
      jj_consume_token(COS);
            currentNumber += 20;
      break;
    case CONT:
      jj_consume_token(CONT);
             currentNumber *= 10;
      break;
    default:
      jj_la1[10] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/** 
 * Deals with numbers above 30 where the base numbers set appear twice.
 * For example, in the tens and the units. */
  final public void tensWithUnits() throws ParseException {
    int tempBackup;
      tempBackup = currentNumber;
    allBaseNumbers();
    jj_consume_token(CONT);
      currentNumber *= 10; currentNumber += tempBackup;
  }

/** The functional group part of the prefix */
  final public void functionalGroupPrefix() throws ParseException {
    prefixFunctionalGroups();
    AddFunGroup();
  }

/**
 * Main chains are compulsary and consist of an optional "cyclo", a length prefix and
 * a posfix denoting functional groups.
 */
  final public void mainChainConstruct() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CYCLO:
      cycle();
      break;
    default:
      jj_la1[11] = jj_gen;
      ;
    }
    mainChainPrefix();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case YL:
      jj_consume_token(YL);
      AddUnknownFunGroupPos();
      MakeMainChainIntoSubstituent();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LITHIUM:
      case SODIUM:
      case POTASSIUM:
      case RUBIDIUM:
      case CESIUM:
      case FRANCIUM:
      case BERYLLIUM:
      case MAGNESIUM:
      case CALCIUM:
      case STRONTIUM:
      case BARIUM:
      case RADIUM:
      case SCANDIUM:
      case YTTRIUM:
      case LANTHANUM:
      case ACTINIUM:
      case TITANIUM:
      case ZIRCONIUM:
      case HAFNIUM:
      case RUTHERFORDIUM:
      case VANADIUM:
      case NIOBIUM:
      case TANTALUM:
      case DUBNIUM:
      case CHROMIUM:
      case MOLYBDENUM:
      case TUNGSTEN:
      case SEABORGIUM:
      case MANGANESE:
      case TECHNETIUM:
      case RHENIUM:
      case BOHRIUM:
      case IRON:
      case RUTHENIUM:
      case OSMIUM:
      case HASSIUM:
      case COBALT:
      case RHODIUM:
      case IRIDIUM:
      case MEITMERIUM:
      case NICKEL:
      case PALLADIUM:
      case PLATINUM:
      case COPPER:
      case SILVER:
      case GOLD:
      case ZINC:
      case CADMIUM:
      case MECURY:
      case ALUMINIUM:
      case GALLIUM:
      case INDIUM:
      case THALLIUM:
      case GERMAINIUM:
      case TIN:
      case LEAD:
      case ARSENIC:
      case ANTIMONY:
      case BISMUTH:
      case SELENIUM:
      case TELLURIUM:
      case POLONIUM:
      case CERIUM:
      case PRASEODYMIUM:
      case NEODYMIUM:
      case PROMETHIUM:
      case SANARIUM:
      case EUROPIUM:
      case GADOLINIUM:
      case TERBIUM:
      case DYSPROSIUM:
      case HOLMIUM:
      case ERBIUM:
      case THULIUM:
      case YTTERBIUM:
      case LUTETIUM:
      case THORIUM:
      case PROTACTINIUM:
      case URANIUM:
      case NEPTUNIUM:
      case PLUTONIUM:
      case AMERCIUM:
      case CURIUM:
      case BERKELIUM:
      case CALIFORNIUM:
      case EINSTEINIUM:
      case FERMIUM:
      case MENDELEVIUM:
      case NOBELIUM:
      case LAWRENCIUM:
        prioritySubstituents();
        break;
      case METH:
      case ETH:
      case PROP:
      case BUT:
      case UNDEC:
      case EICOS:
      case HENICOS:
      case HEN:
      case DO:
      case TRI:
      case TETR:
      case PENT:
      case HEX:
      case HEPT:
      case OCT:
      case NON:
      case DEC:
        mainChainPrefix();
        jj_consume_token(AN);
        prioritySubstituentsFunGroups();
        break;
      default:
        jj_la1[12] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      AddUnknownFunGroupPos();
      AddFunGroup();
      break;
    default:
      jj_la1[13] = jj_gen;
      bondType();
      mainChainSuffix();
    }
  }

/**
 * Deals with cyclic main chains.
 */
  final public void cycle() throws ParseException {
    jj_consume_token(CYCLO);
    SetMainCyclic();
  }

/**
 * Deal with the main chain's length.
 */
  final public void mainChainPrefix() throws ParseException {
    chainPrefix();
    AddMainChain();
  }

/**
 * Tokens which affect the bond order of the first bond. 
 */
  final public void bondType() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case AN:
      jj_consume_token(AN);
      AddUnknownFunGroupPos();
      break;
    default:
      jj_la1[16] = jj_gen;
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DASH:
        jj_consume_token(DASH);
        attachLocationSpecified();
        break;
      default:
        jj_la1[14] = jj_gen;
        AddUnknownFunGroupPos();
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EN:
        jj_consume_token(EN);
        break;
      case YN:
        jj_consume_token(YN);
        break;
      default:
        jj_la1[15] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    AddFunGroup();
  }

/**
 * Figure out the functional group by the main chain's suffix.
 */
  final public void mainChainSuffix() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case E:
    case OICACID:
    case OYLCHLORIDE:
    case AL:
    case AMIDE:
    case AMINE:
    case ONE:
    case OATE:
      endFunctionalGroups();
      break;
    case DASH:
    case OL:
      connectingFunctionalGroupsConstruct();
      break;
    default:
      jj_la1[17] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/**
 * Functional groups which occur at the end of the main chain and need 
 * a connecting "an". 
 */
  final public void endFunctionalGroups() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case E:
      jj_consume_token(E);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NITRILE:
        jj_consume_token(NITRILE);
        break;
      default:
        jj_la1[18] = jj_gen;
        ;
      }
      break;
    case AMIDE:
      jj_consume_token(AMIDE);
      break;
    case AMINE:
      jj_consume_token(AMINE);
      break;
    case OATE:
      jj_consume_token(OATE);
      break;
    case ONE:
      jj_consume_token(ONE);
      break;
    case OICACID:
      jj_consume_token(OICACID);
      break;
    case OYLCHLORIDE:
      jj_consume_token(OYLCHLORIDE);
      break;
    case AL:
      jj_consume_token(AL);
      break;
    default:
      jj_la1[19] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    AddUnknownFunGroupPos();
    AddFunGroup();
  }

/**
 * The layout of a functional group(s) which can connect anywhere.
 * No number specified, or a number list specified.
 */
  final public void connectingFunctionalGroupsConstruct() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case OL:
      connectingFunctionalGroupSuffix();
      AddUnknownFunGroupPos();
      break;
    case DASH:
      jj_consume_token(DASH);
      attachLocationSpecified();
      connectingFunctionalGroupSuffix();
      break;
    default:
      jj_la1[20] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    AddFunGroup();
  }

/**
 * Functional groups suffixs for groups which can be connected anywhere 
 * along the main chain.
 */
  final public void connectingFunctionalGroupSuffix() throws ParseException {
    jj_consume_token(OL);
  }

  final public void prefixFunctionalGroups() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CHLORO:
      jj_consume_token(CHLORO);
      break;
    case BROMO:
      jj_consume_token(BROMO);
      break;
    case IODO:
      jj_consume_token(IODO);
      break;
    case FLUORO:
      jj_consume_token(FLUORO);
      break;
    case NITRO:
      jj_consume_token(NITRO);
      break;
    case OXO:
      jj_consume_token(OXO);
      break;
    case PHENYL:
      jj_consume_token(PHENYL);
      break;
    case AMINO:
      jj_consume_token(AMINO);
      break;
    case HYDROXY:
      jj_consume_token(HYDROXY);
      break;
    default:
      jj_la1[21] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/**
 * Things which have sub chains branching off them and the molecule does have a main chain.
 */
  final public void prioritySubstituentsFunGroups() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case AMINE:
      jj_consume_token(AMINE);
      break;
    case AMIDE:
      jj_consume_token(AMIDE);
      break;
    case OATE:
      jj_consume_token(OATE);
      break;
    case ONE:
      jj_consume_token(ONE);
      break;
    default:
      jj_la1[22] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/**
 * Things which have sub chains branching off them but the molecule has no main chain.
 */
  final public void prioritySubstituents() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LITHIUM:
    case SODIUM:
    case POTASSIUM:
    case RUBIDIUM:
    case CESIUM:
    case FRANCIUM:
      groupOneMetals();
      break;
    case BERYLLIUM:
    case MAGNESIUM:
    case CALCIUM:
    case STRONTIUM:
    case BARIUM:
    case RADIUM:
      groupTwoMetals();
      break;
    case SCANDIUM:
    case YTTRIUM:
    case LANTHANUM:
    case ACTINIUM:
    case TITANIUM:
    case ZIRCONIUM:
    case HAFNIUM:
    case RUTHERFORDIUM:
    case VANADIUM:
    case NIOBIUM:
    case TANTALUM:
    case DUBNIUM:
    case CHROMIUM:
    case MOLYBDENUM:
    case TUNGSTEN:
    case SEABORGIUM:
    case MANGANESE:
    case TECHNETIUM:
    case RHENIUM:
    case BOHRIUM:
    case IRON:
    case RUTHENIUM:
    case OSMIUM:
    case HASSIUM:
    case COBALT:
    case RHODIUM:
    case IRIDIUM:
    case MEITMERIUM:
    case NICKEL:
    case PALLADIUM:
    case PLATINUM:
    case COPPER:
    case SILVER:
    case GOLD:
    case ZINC:
    case CADMIUM:
    case MECURY:
      dBlockMetals();
      break;
    case ALUMINIUM:
    case GALLIUM:
    case INDIUM:
    case THALLIUM:
    case GERMAINIUM:
    case TIN:
    case LEAD:
    case ARSENIC:
    case ANTIMONY:
    case BISMUTH:
    case SELENIUM:
    case TELLURIUM:
    case POLONIUM:
      pBlockMetals();
      break;
    case CERIUM:
    case PRASEODYMIUM:
    case NEODYMIUM:
    case PROMETHIUM:
    case SANARIUM:
    case EUROPIUM:
    case GADOLINIUM:
    case TERBIUM:
    case DYSPROSIUM:
    case HOLMIUM:
    case ERBIUM:
    case THULIUM:
    case YTTERBIUM:
    case LUTETIUM:
    case THORIUM:
    case PROTACTINIUM:
    case URANIUM:
    case NEPTUNIUM:
    case PLUTONIUM:
    case AMERCIUM:
    case CURIUM:
    case BERKELIUM:
    case CALIFORNIUM:
    case EINSTEINIUM:
    case FERMIUM:
    case MENDELEVIUM:
    case NOBELIUM:
    case LAWRENCIUM:
      fBlockMetals();
      break;
    default:
      jj_la1[23] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void groupOneMetals() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LITHIUM:
      jj_consume_token(LITHIUM);
      break;
    case SODIUM:
      jj_consume_token(SODIUM);
      break;
    case POTASSIUM:
      jj_consume_token(POTASSIUM);
      break;
    case RUBIDIUM:
      jj_consume_token(RUBIDIUM);
      break;
    case CESIUM:
      jj_consume_token(CESIUM);
      break;
    case FRANCIUM:
      jj_consume_token(FRANCIUM);
      break;
    default:
      jj_la1[24] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void groupTwoMetals() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case BERYLLIUM:
      jj_consume_token(BERYLLIUM);
      break;
    case MAGNESIUM:
      jj_consume_token(MAGNESIUM);
      break;
    case CALCIUM:
      jj_consume_token(CALCIUM);
      break;
    case STRONTIUM:
      jj_consume_token(STRONTIUM);
      break;
    case BARIUM:
      jj_consume_token(BARIUM);
      break;
    case RADIUM:
      jj_consume_token(RADIUM);
      break;
    default:
      jj_la1[25] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void dBlockMetals() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SCANDIUM:
      jj_consume_token(SCANDIUM);
      break;
    case YTTRIUM:
      jj_consume_token(YTTRIUM);
      break;
    case LANTHANUM:
      jj_consume_token(LANTHANUM);
      break;
    case ACTINIUM:
      jj_consume_token(ACTINIUM);
      break;
    case TITANIUM:
      jj_consume_token(TITANIUM);
      break;
    case ZIRCONIUM:
      jj_consume_token(ZIRCONIUM);
      break;
    case HAFNIUM:
      jj_consume_token(HAFNIUM);
      break;
    case RUTHERFORDIUM:
      jj_consume_token(RUTHERFORDIUM);
      break;
    case VANADIUM:
      jj_consume_token(VANADIUM);
      break;
    case NIOBIUM:
      jj_consume_token(NIOBIUM);
      break;
    case TANTALUM:
      jj_consume_token(TANTALUM);
      break;
    case DUBNIUM:
      jj_consume_token(DUBNIUM);
      break;
    case CHROMIUM:
      jj_consume_token(CHROMIUM);
      break;
    case MOLYBDENUM:
      jj_consume_token(MOLYBDENUM);
      break;
    case TUNGSTEN:
      jj_consume_token(TUNGSTEN);
      break;
    case SEABORGIUM:
      jj_consume_token(SEABORGIUM);
      break;
    case MANGANESE:
      jj_consume_token(MANGANESE);
      break;
    case TECHNETIUM:
      jj_consume_token(TECHNETIUM);
      break;
    case RHENIUM:
      jj_consume_token(RHENIUM);
      break;
    case BOHRIUM:
      jj_consume_token(BOHRIUM);
      break;
    case IRON:
      jj_consume_token(IRON);
      break;
    case RUTHENIUM:
      jj_consume_token(RUTHENIUM);
      break;
    case OSMIUM:
      jj_consume_token(OSMIUM);
      break;
    case HASSIUM:
      jj_consume_token(HASSIUM);
      break;
    case COBALT:
      jj_consume_token(COBALT);
      break;
    case RHODIUM:
      jj_consume_token(RHODIUM);
      break;
    case IRIDIUM:
      jj_consume_token(IRIDIUM);
      break;
    case MEITMERIUM:
      jj_consume_token(MEITMERIUM);
      break;
    case NICKEL:
      jj_consume_token(NICKEL);
      break;
    case PALLADIUM:
      jj_consume_token(PALLADIUM);
      break;
    case PLATINUM:
      jj_consume_token(PLATINUM);
      break;
    case COPPER:
      jj_consume_token(COPPER);
      break;
    case SILVER:
      jj_consume_token(SILVER);
      break;
    case GOLD:
      jj_consume_token(GOLD);
      break;
    case ZINC:
      jj_consume_token(ZINC);
      break;
    case CADMIUM:
      jj_consume_token(CADMIUM);
      break;
    case MECURY:
      jj_consume_token(MECURY);
      break;
    default:
      jj_la1[26] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void pBlockMetals() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ALUMINIUM:
      jj_consume_token(ALUMINIUM);
      break;
    case GALLIUM:
      jj_consume_token(GALLIUM);
      break;
    case INDIUM:
      jj_consume_token(INDIUM);
      break;
    case THALLIUM:
      jj_consume_token(THALLIUM);
      break;
    case GERMAINIUM:
      jj_consume_token(GERMAINIUM);
      break;
    case TIN:
      jj_consume_token(TIN);
      break;
    case LEAD:
      jj_consume_token(LEAD);
      break;
    case ARSENIC:
      jj_consume_token(ARSENIC);
      break;
    case ANTIMONY:
      jj_consume_token(ANTIMONY);
      break;
    case BISMUTH:
      jj_consume_token(BISMUTH);
      break;
    case SELENIUM:
      jj_consume_token(SELENIUM);
      break;
    case TELLURIUM:
      jj_consume_token(TELLURIUM);
      break;
    case POLONIUM:
      jj_consume_token(POLONIUM);
      break;
    default:
      jj_la1[27] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void fBlockMetals() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CERIUM:
      jj_consume_token(CERIUM);
      break;
    case PRASEODYMIUM:
      jj_consume_token(PRASEODYMIUM);
      break;
    case NEODYMIUM:
      jj_consume_token(NEODYMIUM);
      break;
    case PROMETHIUM:
      jj_consume_token(PROMETHIUM);
      break;
    case SANARIUM:
      jj_consume_token(SANARIUM);
      break;
    case EUROPIUM:
      jj_consume_token(EUROPIUM);
      break;
    case GADOLINIUM:
      jj_consume_token(GADOLINIUM);
      break;
    case TERBIUM:
      jj_consume_token(TERBIUM);
      break;
    case DYSPROSIUM:
      jj_consume_token(DYSPROSIUM);
      break;
    case HOLMIUM:
      jj_consume_token(HOLMIUM);
      break;
    case ERBIUM:
      jj_consume_token(ERBIUM);
      break;
    case THULIUM:
      jj_consume_token(THULIUM);
      break;
    case YTTERBIUM:
      jj_consume_token(YTTERBIUM);
      break;
    case LUTETIUM:
      jj_consume_token(LUTETIUM);
      break;
    case THORIUM:
      jj_consume_token(THORIUM);
      break;
    case PROTACTINIUM:
      jj_consume_token(PROTACTINIUM);
      break;
    case URANIUM:
      jj_consume_token(URANIUM);
      break;
    case NEPTUNIUM:
      jj_consume_token(NEPTUNIUM);
      break;
    case PLUTONIUM:
      jj_consume_token(PLUTONIUM);
      break;
    case AMERCIUM:
      jj_consume_token(AMERCIUM);
      break;
    case CURIUM:
      jj_consume_token(CURIUM);
      break;
    case BERKELIUM:
      jj_consume_token(BERKELIUM);
      break;
    case CALIFORNIUM:
      jj_consume_token(CALIFORNIUM);
      break;
    case EINSTEINIUM:
      jj_consume_token(EINSTEINIUM);
      break;
    case FERMIUM:
      jj_consume_token(FERMIUM);
      break;
    case MENDELEVIUM:
      jj_consume_token(MENDELEVIUM);
      break;
    case NOBELIUM:
      jj_consume_token(NOBELIUM);
      break;
    case LAWRENCIUM:
      jj_consume_token(LAWRENCIUM);
      break;
    default:
      jj_la1[28] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  private boolean jj_2_1(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_1(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  private boolean jj_3R_31() {
    if (jj_3R_10()) return true;
    return false;
  }

  private boolean jj_3R_7() {
    if (jj_3R_9()) return true;
    return false;
  }

  private boolean jj_3R_6() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_7()) {
    jj_scanpos = xsp;
    if (jj_3R_8()) return true;
    }
    return false;
  }

  private boolean jj_3R_4() {
    if (jj_3R_6()) return true;
    if (true) { jj_la = 0; jj_scanpos = jj_lastpos; return false;}
    return false;
  }

  private boolean jj_3R_35() {
    if (jj_scan_token(CONT)) return true;
    return false;
  }

  private boolean jj_3R_34() {
    if (jj_scan_token(COS)) return true;
    return false;
  }

  private boolean jj_3R_33() {
    if (jj_scan_token(DEC)) return true;
    return false;
  }

  private boolean jj_3R_32() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_33()) {
    jj_scanpos = xsp;
    if (jj_3R_34()) {
    jj_scanpos = xsp;
    if (jj_3R_35()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_5() {
    if (jj_scan_token(CYCLO)) return true;
    if (true) { jj_la = 0; jj_scanpos = jj_lastpos; return false;}
    return false;
  }

  private boolean jj_3R_29() {
    if (jj_3R_31()) return true;
    return false;
  }

  private boolean jj_3R_11() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_29()) {
    jj_scanpos = xsp;
    if (jj_3R_30()) return true;
    }
    return false;
  }

  private boolean jj_3R_28() {
    if (jj_scan_token(NON)) return true;
    return false;
  }

  private boolean jj_3R_27() {
    if (jj_scan_token(OCT)) return true;
    return false;
  }

  private boolean jj_3R_26() {
    if (jj_scan_token(HEPT)) return true;
    return false;
  }

  private boolean jj_3R_25() {
    if (jj_scan_token(HEX)) return true;
    return false;
  }

  private boolean jj_3R_24() {
    if (jj_scan_token(PENT)) return true;
    return false;
  }

  private boolean jj_3R_23() {
    if (jj_scan_token(TETR)) return true;
    return false;
  }

  private boolean jj_3R_22() {
    if (jj_scan_token(TRI)) return true;
    return false;
  }

  private boolean jj_3R_3() {
    if (jj_3R_5()) return true;
    return false;
  }

  private boolean jj_3R_21() {
    if (jj_scan_token(DO)) return true;
    return false;
  }

  private boolean jj_3_1() {
    if (jj_3R_2()) return true;
    return false;
  }

  private boolean jj_3R_2() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_3()) jj_scanpos = xsp;
    if (jj_3R_4()) return true;
    return false;
  }

  private boolean jj_3R_20() {
    if (jj_scan_token(HEN)) return true;
    return false;
  }

  private boolean jj_3R_10() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_20()) {
    jj_scanpos = xsp;
    if (jj_3R_21()) {
    jj_scanpos = xsp;
    if (jj_3R_22()) {
    jj_scanpos = xsp;
    if (jj_3R_23()) {
    jj_scanpos = xsp;
    if (jj_3R_24()) {
    jj_scanpos = xsp;
    if (jj_3R_25()) {
    jj_scanpos = xsp;
    if (jj_3R_26()) {
    jj_scanpos = xsp;
    if (jj_3R_27()) {
    jj_scanpos = xsp;
    if (jj_3R_28()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_8() {
    if (jj_3R_10()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_11()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_19() {
    if (jj_scan_token(HENICOS)) return true;
    return false;
  }

  private boolean jj_3R_18() {
    if (jj_scan_token(EICOS)) return true;
    return false;
  }

  private boolean jj_3R_17() {
    if (jj_scan_token(UNDEC)) return true;
    return false;
  }

  private boolean jj_3R_16() {
    if (jj_scan_token(DEC)) return true;
    return false;
  }

  private boolean jj_3R_15() {
    if (jj_scan_token(BUT)) return true;
    return false;
  }

  private boolean jj_3R_14() {
    if (jj_scan_token(PROP)) return true;
    return false;
  }

  private boolean jj_3R_13() {
    if (jj_scan_token(ETH)) return true;
    return false;
  }

  private boolean jj_3R_9() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_12()) {
    jj_scanpos = xsp;
    if (jj_3R_13()) {
    jj_scanpos = xsp;
    if (jj_3R_14()) {
    jj_scanpos = xsp;
    if (jj_3R_15()) {
    jj_scanpos = xsp;
    if (jj_3R_16()) {
    jj_scanpos = xsp;
    if (jj_3R_17()) {
    jj_scanpos = xsp;
    if (jj_3R_18()) {
    jj_scanpos = xsp;
    if (jj_3R_19()) return true;
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_12() {
    if (jj_scan_token(METH)) return true;
    return false;
  }

  private boolean jj_3R_30() {
    if (jj_3R_32()) return true;
    return false;
  }

  /** Generated Token Manager. */
  public NomParserTokenManager token_source;
  SimpleCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  private int jj_gen;
  final private int[] jj_la1 = new int[29];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static private int[] jj_la1_2;
  static private int[] jj_la1_3;
  static private int[] jj_la1_4;
  static {
      jj_la1_init_0();
      jj_la1_init_1();
      jj_la1_init_2();
      jj_la1_init_3();
      jj_la1_init_4();
   }
   private static void jj_la1_init_0() {
      jj_la1_0 = new int[] {0x10,0x4,0x7fffc0,0x30,0x30,0x1ffe000,0x1ffe000,0x7fffc0,0x401fc0,0x3fe000,0x1c00000,0x0,0x7fffc0,0x40000000,0x10,0x30000000,0x8000000,0x10,0x0,0x0,0x10,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
   private static void jj_la1_init_1() {
      jj_la1_1 = new int[] {0x0,0x0,0x9fe,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1,0xffc00000,0x0,0x0,0x0,0x0,0x3ef000,0x10000,0x3ed000,0x2000,0x9fe,0x3c0000,0xffc00000,0xfc00000,0xf0000000,0x0,0x0,0x0,};
   }
   private static void jj_la1_init_2() {
      jj_la1_2 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffffffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffffffff,0x0,0x3,0xfffffffc,0x0,0x0,};
   }
   private static void jj_la1_init_3() {
      jj_la1_3 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffffffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffffffff,0x0,0x0,0x7f,0xfff80,0xfff00000,};
   }
   private static void jj_la1_init_4() {
      jj_la1_4 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffff,0x0,0x0,0x0,0x0,0xffff,};
   }
  final private JJCalls[] jj_2_rtns = new JJCalls[1];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  /** Constructor with InputStream. */
  public NomParser(java.io.InputStream stream) {
     this(stream, null);
  }
  /** Constructor with InputStream and supplied encoding */
  public NomParser(java.io.InputStream stream, String encoding) {
    try { jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source = new NomParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 29; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream) {
     ReInit(stream, null);
  }
  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream, String encoding) {
    try { jj_input_stream.ReInit(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 29; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor. */
  public NomParser(java.io.Reader stream) {
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new NomParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 29; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 29; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor with generated Token Manager. */
  public NomParser(NomParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 29; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(NomParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 29; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  static private final class LookaheadSuccess extends java.lang.Error { }
  final private LookaheadSuccess jj_ls = new LookaheadSuccess();
  private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    if (jj_scanpos.kind != kind) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
    return false;
  }


/** Get the next Token. */
  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) return;
    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];
      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }
      jj_entries_loop: for (java.util.Iterator<?> it = jj_expentries.iterator(); it.hasNext();) {
        int[] oldentry = (int[])(it.next());
        if (oldentry.length == jj_expentry.length) {
          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              continue jj_entries_loop;
            }
          }
          jj_expentries.add(jj_expentry);
          break jj_entries_loop;
        }
      }
      if (pos != 0) jj_lasttokens[(jj_endpos = pos) - 1] = kind;
    }
  }

  /** Generate ParseException. */
  public ParseException generateParseException() {
    jj_expentries.clear();
    boolean[] la1tokens = new boolean[144];
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 29; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
          if ((jj_la1_2[i] & (1<<j)) != 0) {
            la1tokens[64+j] = true;
          }
          if ((jj_la1_3[i] & (1<<j)) != 0) {
            la1tokens[96+j] = true;
          }
          if ((jj_la1_4[i] & (1<<j)) != 0) {
            la1tokens[128+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 144; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.add(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = jj_expentries.get(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

  private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 1; i++) {
    try {
      JJCalls p = jj_2_rtns[i];
      do {
        if (p.gen > jj_gen) {
          jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
          switch (i) {
            case 0: jj_3_1(); break;
          }
        }
        p = p.next;
      } while (p != null);
      } catch(LookaheadSuccess ls) { }
    }
    jj_rescan = false;
  }

  private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; p.first = token; p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

}
