/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.atomic;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.qsar.AbstractAtomicDescriptor;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.result.DoubleResult;
import org.openscience.cdk.qsar.result.IDescriptorResult;
import org.openscience.cdk.tools.HOSECodeGenerator;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.LonePairElectronChecker;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

public class IPAtomicHOSEDescriptor
extends AbstractAtomicDescriptor {
    private static final String[] NAMES = new String[]{"ipAtomicHOSE"};
    int maxSpheresToUse = 10;
    private IPdb db = new IPdb();

    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#ionizationPotential", ((Object)((Object)this)).getClass().getName(), "The Chemistry Development Kit");
    }

    public void setParameters(Object[] params) throws CDKException {
    }

    public Object[] getParameters() {
        return null;
    }

    public String[] getDescriptorNames() {
        return NAMES;
    }

    public DescriptorValue calculate(IAtom atom, IAtomContainer container) {
        String originalAtomtypeName = atom.getAtomTypeName();
        Integer originalNeighborCount = atom.getFormalNeighbourCount();
        Integer originalValency = atom.getValency();
        Double originalBondOrderSum = atom.getBondOrderSum();
        IBond.Order originalMaxBondOrder = atom.getMaxBondOrder();
        IAtomType.Hybridization originalHybridization = atom.getHybridization();
        if (!this.isCachedAtomContainer(container)) {
            try {
                AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms((IAtomContainer)container);
                LonePairElectronChecker lpcheck = new LonePairElectronChecker();
                lpcheck.saturate(container);
            }
            catch (CDKException e) {
                return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), (IDescriptorResult)new DoubleResult(Double.NaN), NAMES, (Exception)((Object)e));
            }
        }
        double value = this.db.extractIP(container, atom);
        atom.setAtomTypeName(originalAtomtypeName);
        atom.setFormalNeighbourCount(originalNeighborCount);
        atom.setValency(originalValency);
        atom.setHybridization(originalHybridization);
        atom.setMaxBondOrder(originalMaxBondOrder);
        atom.setBondOrderSum(originalBondOrderSum);
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), (IDescriptorResult)new DoubleResult(value), NAMES);
    }

    private boolean familyHalogen(IAtom atom) {
        String symbol = atom.getSymbol();
        return symbol.equals("F") || symbol.equals("Cl") || symbol.equals("Br") || symbol.equals("I");
    }

    public String[] getParameterNames() {
        return new String[0];
    }

    public Object getParameterType(String name) {
        return null;
    }

    private static List<String> extractInfo(String str) {
        int end;
        int beg = 0;
        int len = str.length();
        ArrayList<String> parts = new ArrayList<String>();
        for (end = 0; end < len && !Character.isSpaceChar(str.charAt(end)); ++end) {
        }
        parts.add(str.substring(beg, end));
        while (end < len && Character.isSpaceChar(str.charAt(end))) {
            ++end;
        }
        beg = end;
        while (end < len && !Character.isSpaceChar(str.charAt(end))) {
            ++end;
        }
        parts.add(str.substring(beg, end));
        return parts;
    }

    private class IPdb {
        public static final String X_IP_HOSE_DB = "/org/openscience/cdk/qsar/descriptors/atomic/data/X_IP_HOSE.db";
        public static final String X_IP_HOSE_DB_S = "/org/openscience/cdk/qsar/descriptors/atomic/data/X_IP_HOSE_S.db";

        public double extractIP(IAtomContainer container, IAtom atom) {
            HashMap<String, Double> hoseVSenergyS;
            HashMap<String, Double> hoseVSenergy;
            block65: {
                if (IPAtomicHOSEDescriptor.this.familyHalogen(atom)) {
                    Throwable throwable;
                    BufferedReader insr2;
                    Throwable throwable2;
                    InputStream ins;
                    try {
                        ins = this.getClass().getResourceAsStream(X_IP_HOSE_DB);
                        throwable2 = null;
                        try {
                            insr2 = new BufferedReader(new InputStreamReader(ins));
                            throwable = null;
                            try {
                                hoseVSenergy = this.extractAttributes(insr2);
                            }
                            catch (Throwable throwable3) {
                                throwable = throwable3;
                                throw throwable3;
                            }
                            finally {
                                if (insr2 != null) {
                                    if (throwable != null) {
                                        try {
                                            insr2.close();
                                        }
                                        catch (Throwable throwable4) {
                                            throwable.addSuppressed(throwable4);
                                        }
                                    } else {
                                        insr2.close();
                                    }
                                }
                            }
                        }
                        catch (Throwable insr2) {
                            throwable2 = insr2;
                            throw insr2;
                        }
                        finally {
                            if (ins != null) {
                                if (throwable2 != null) {
                                    try {
                                        ins.close();
                                    }
                                    catch (Throwable insr2) {
                                        throwable2.addSuppressed(insr2);
                                    }
                                } else {
                                    ins.close();
                                }
                            }
                        }
                    }
                    catch (IOException e) {
                        LoggingToolFactory.createLoggingTool(this.getClass()).error((Object)e);
                        return 0.0;
                    }
                    try {
                        ins = this.getClass().getResourceAsStream(X_IP_HOSE_DB_S);
                        throwable2 = null;
                        try {
                            insr2 = new BufferedReader(new InputStreamReader(ins));
                            throwable = null;
                            try {
                                hoseVSenergyS = this.extractAttributes(insr2);
                                break block65;
                            }
                            catch (Throwable throwable5) {
                                throwable = throwable5;
                                throw throwable5;
                            }
                            finally {
                                if (insr2 != null) {
                                    if (throwable != null) {
                                        try {
                                            insr2.close();
                                        }
                                        catch (Throwable throwable6) {
                                            throwable.addSuppressed(throwable6);
                                        }
                                    } else {
                                        insr2.close();
                                    }
                                }
                            }
                        }
                        catch (Throwable insr3) {
                            throwable2 = insr3;
                            throw insr3;
                        }
                        finally {
                            if (ins != null) {
                                if (throwable2 != null) {
                                    try {
                                        ins.close();
                                    }
                                    catch (Throwable insr3) {
                                        throwable2.addSuppressed(insr3);
                                    }
                                } else {
                                    ins.close();
                                }
                            }
                        }
                    }
                    catch (IOException e) {
                        LoggingToolFactory.createLoggingTool(this.getClass()).error((Object)e);
                        return 0.0;
                    }
                }
                return 0.0;
            }
            try {
                HOSECodeGenerator hcg = new HOSECodeGenerator();
                int exactSphere = 0;
                String hoseCode = "";
                for (int spheres = IPAtomicHOSEDescriptor.this.maxSpheresToUse; spheres > 0; --spheres) {
                    hcg.getSpheres(container, atom, spheres, true);
                    List atoms = hcg.getNodesInSphere(spheres);
                    if (atoms.size() == 0) continue;
                    exactSphere = spheres;
                    hoseCode = hcg.getHOSECode(container, atom, spheres, true);
                    if (hoseVSenergy.containsKey(hoseCode)) {
                        return hoseVSenergy.get(hoseCode);
                    }
                    if (!hoseVSenergyS.containsKey(hoseCode)) break;
                    return hoseVSenergyS.get(hoseCode);
                }
                for (int i = 0; i < 3; ++i) {
                    for (int plusMinus = 0; plusMinus < 2; ++plusMinus) {
                        int sign = -1;
                        if (plusMinus == 1) {
                            sign = 1;
                        }
                        StringTokenizer st = new StringTokenizer(hoseCode, "()/");
                        StringBuilder hoseCodeBuffer = new StringBuilder();
                        int sum = exactSphere + sign * (i + 1);
                        for (int k = 0; k < sum; ++k) {
                            if (st.hasMoreTokens()) {
                                String partcode = st.nextToken();
                                hoseCodeBuffer.append(partcode);
                            }
                            if (k == 0) {
                                hoseCodeBuffer.append('(');
                                continue;
                            }
                            if (k == 3) {
                                hoseCodeBuffer.append(')');
                                continue;
                            }
                            hoseCodeBuffer.append('/');
                        }
                        String hoseCodeBU = hoseCodeBuffer.toString();
                        if (!hoseVSenergyS.containsKey(hoseCodeBU)) continue;
                        return hoseVSenergyS.get(hoseCodeBU);
                    }
                }
            }
            catch (CDKException e) {
                e.printStackTrace();
            }
            return 0.0;
        }

        private HashMap<String, Double> extractAttributes(BufferedReader input) {
            HashMap<String, Double> hoseVSenergy = new HashMap<String, Double>();
            try {
                String line;
                while ((line = input.readLine()) != null) {
                    List values;
                    if (line.startsWith("#") || ((String)(values = IPAtomicHOSEDescriptor.extractInfo(line)).get(1)).equals("")) continue;
                    hoseVSenergy.put((String)values.get(0), Double.valueOf((String)values.get(1)));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return hoseVSenergy;
        }
    }
}

