/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/*
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

//----------------------------------------------------
// THIS CODE IS GENERATED. MANUAL EDITS WILL BE LOST.
//----------------------------------------------------

package org.opensearch.client.opensearch.security;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Generated;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

// typedef: security.validate.Request

/**
 * Checks whether the v6 security configuration is valid and ready to be migrated to v7.
 */
@Generated("org.opensearch.client.codegen.CodeGenerator")
public final class ValidateRequest extends RequestBase implements ToCopyableBuilder<ValidateRequest.Builder, ValidateRequest> {

    @Nullable
    private final Boolean acceptInvalid;

    // ---------------------------------------------------------------------------------------------

    private ValidateRequest(Builder builder) {
        super(builder);
        this.acceptInvalid = builder.acceptInvalid;
    }

    public static ValidateRequest of(Function<ValidateRequest.Builder, ObjectBuilder<ValidateRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    /**
     * Whether an invalid v6 configuration should be allowed.
     * <p>
     * API name: {@code accept_invalid}
     * </p>
     */
    @Nullable
    public final Boolean acceptInvalid() {
        return this.acceptInvalid;
    }

    // ---------------------------------------------------------------------------------------------

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    /**
     * Builder for {@link ValidateRequest}.
     */
    public static class Builder extends RequestBase.AbstractBuilder<Builder> implements CopyableBuilder<Builder, ValidateRequest> {
        @Nullable
        private Boolean acceptInvalid;

        public Builder() {}

        private Builder(ValidateRequest o) {
            super(o);
            this.acceptInvalid = o.acceptInvalid;
        }

        private Builder(Builder o) {
            super(o);
            this.acceptInvalid = o.acceptInvalid;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        /**
         * Whether an invalid v6 configuration should be allowed.
         * <p>
         * API name: {@code accept_invalid}
         * </p>
         */
        @Nonnull
        public final Builder acceptInvalid(@Nullable Boolean value) {
            this.acceptInvalid = value;
            return this;
        }

        /**
         * Builds a {@link ValidateRequest}.
         *
         * @throws NullPointerException if some of the required fields are null.
         */
        @Override
        @Nonnull
        public ValidateRequest build() {
            _checkSingleUse();

            return new ValidateRequest(this);
        }
    }

    // ---------------------------------------------------------------------------------------------

    @Override
    protected void applyQueryParameters(@Nonnull Map<String, String> params) {
        super.applyQueryParameters(params);
        if (this.acceptInvalid != null) {
            params.put("accept_invalid", String.valueOf(this.acceptInvalid));
        }
    }

    /**
     * Endpoint "{@code security.validate}".
     */
    public static final Endpoint<ValidateRequest, ValidateResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<>(
        // Request method
        request -> "GET",
        // Request path
        request -> "/_plugins/_security/api/validate",
        // Request parameters
        request -> {
            Map<String, String> params = new HashMap<>();
            request.applyQueryParameters(params);
            return params;
        },
        SimpleEndpoint.emptyMap(),
        false,
        ValidateResponse._DESERIALIZER
    );

    @Override
    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.acceptInvalid);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || this.getClass() != o.getClass()) return false;
        ValidateRequest other = (ValidateRequest) o;
        return Objects.equals(this.acceptInvalid, other.acceptInvalid);
    }
}
