/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.indices;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.util.CollectionUtil;
import org.opensearch.cluster.metadata.AliasMetadata;
import org.opensearch.cluster.metadata.MappingMetadata;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.common.xcontent.XContentParserUtils;

public class GetIndexResponse {
    private Map<String, MappingMetadata> mappings;
    private Map<String, List<AliasMetadata>> aliases;
    private Map<String, Settings> settings;
    private Map<String, Settings> defaultSettings;
    private Map<String, String> dataStreams;
    private String[] indices;

    GetIndexResponse(String[] indices, Map<String, MappingMetadata> mappings, Map<String, List<AliasMetadata>> aliases, Map<String, Settings> settings, Map<String, Settings> defaultSettings, Map<String, String> dataStreams) {
        this.indices = indices;
        Arrays.sort(indices);
        if (mappings != null) {
            this.mappings = mappings;
        }
        if (aliases != null) {
            this.aliases = aliases;
        }
        if (settings != null) {
            this.settings = settings;
        }
        if (defaultSettings != null) {
            this.defaultSettings = defaultSettings;
        }
        if (dataStreams != null) {
            this.dataStreams = dataStreams;
        }
    }

    public String[] getIndices() {
        return this.indices;
    }

    public Map<String, MappingMetadata> getMappings() {
        return this.mappings;
    }

    public Map<String, List<AliasMetadata>> getAliases() {
        return this.aliases;
    }

    public Map<String, Settings> getDefaultSettings() {
        return this.defaultSettings;
    }

    public Map<String, Settings> getSettings() {
        return this.settings;
    }

    public Map<String, String> getDataStreams() {
        return this.dataStreams;
    }

    public String getSetting(String index, String setting) {
        Settings indexSettings = this.settings.get(index);
        if (setting != null) {
            if (indexSettings != null && indexSettings.hasValue(setting)) {
                return indexSettings.get(setting);
            }
            Settings defaultIndexSettings = this.defaultSettings.get(index);
            if (defaultIndexSettings != null) {
                return defaultIndexSettings.get(setting);
            }
            return null;
        }
        return null;
    }

    private static List<AliasMetadata> parseAliases(XContentParser parser) throws IOException {
        ArrayList<AliasMetadata> indexAliases = new ArrayList<AliasMetadata>();
        while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.FIELD_NAME, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
            indexAliases.add(AliasMetadata.Builder.fromXContent((XContentParser)parser));
        }
        return indexAliases;
    }

    private static MappingMetadata parseMappings(XContentParser parser) throws IOException {
        return new MappingMetadata("_doc", parser.map());
    }

    private static IndexEntry parseIndexEntry(XContentParser parser) throws IOException {
        List<AliasMetadata> indexAliases = null;
        MappingMetadata indexMappings = null;
        Settings indexSettings = null;
        Settings indexDefaultSettings = null;
        String dataStream = null;
        block12: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.FIELD_NAME, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
            parser.nextToken();
            if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
                switch (parser.currentName()) {
                    case "aliases": {
                        indexAliases = GetIndexResponse.parseAliases(parser);
                        continue block12;
                    }
                    case "mappings": {
                        indexMappings = GetIndexResponse.parseMappings(parser);
                        continue block12;
                    }
                    case "settings": {
                        indexSettings = Settings.fromXContent((XContentParser)parser);
                        continue block12;
                    }
                    case "defaults": {
                        indexDefaultSettings = Settings.fromXContent((XContentParser)parser);
                        continue block12;
                    }
                }
                parser.skipChildren();
                continue;
            }
            if (parser.currentToken() == XContentParser.Token.VALUE_STRING) {
                if (parser.currentName().equals("data_stream")) {
                    dataStream = parser.text();
                }
                parser.skipChildren();
                continue;
            }
            if (parser.currentToken() != XContentParser.Token.START_ARRAY) continue;
            parser.skipChildren();
        }
        return new IndexEntry(indexAliases, indexMappings, indexSettings, indexDefaultSettings, dataStream);
    }

    public static GetIndexResponse fromXContent(XContentParser parser) throws IOException {
        HashMap<String, List<AliasMetadata>> aliases = new HashMap<String, List<AliasMetadata>>();
        HashMap<String, MappingMetadata> mappings = new HashMap<String, MappingMetadata>();
        HashMap<String, Settings> settings = new HashMap<String, Settings>();
        HashMap<String, Settings> defaultSettings = new HashMap<String, Settings>();
        HashMap<String, String> dataStreams = new HashMap<String, String>();
        ArrayList<String> indices = new ArrayList<String>();
        if (parser.currentToken() == null) {
            parser.nextToken();
        }
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        parser.nextToken();
        while (!parser.isClosed()) {
            if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
                String indexName = parser.currentName();
                indices.add(indexName);
                IndexEntry indexEntry = GetIndexResponse.parseIndexEntry(parser);
                CollectionUtil.timSort(indexEntry.indexAliases, Comparator.comparing(AliasMetadata::alias));
                aliases.put(indexName, Collections.unmodifiableList(indexEntry.indexAliases));
                mappings.put(indexName, indexEntry.indexMappings);
                settings.put(indexName, indexEntry.indexSettings);
                if (!indexEntry.indexDefaultSettings.isEmpty()) {
                    defaultSettings.put(indexName, indexEntry.indexDefaultSettings);
                }
                if (indexEntry.dataStream == null) continue;
                dataStreams.put(indexName, indexEntry.dataStream);
                continue;
            }
            if (parser.currentToken() == XContentParser.Token.START_ARRAY) {
                parser.skipChildren();
                continue;
            }
            parser.nextToken();
        }
        return new GetIndexResponse(indices.toArray(new String[0]), mappings, aliases, settings, defaultSettings, dataStreams);
    }

    private static class IndexEntry {
        List<AliasMetadata> indexAliases = new ArrayList<AliasMetadata>();
        MappingMetadata indexMappings;
        Settings indexSettings = Settings.EMPTY;
        Settings indexDefaultSettings = Settings.EMPTY;
        String dataStream;

        IndexEntry(List<AliasMetadata> indexAliases, MappingMetadata indexMappings, Settings indexSettings, Settings indexDefaultSettings, String dataStream) {
            if (indexAliases != null) {
                this.indexAliases = indexAliases;
            }
            if (indexMappings != null) {
                this.indexMappings = indexMappings;
            }
            if (indexSettings != null) {
                this.indexSettings = indexSettings;
            }
            if (indexDefaultSettings != null) {
                this.indexDefaultSettings = indexDefaultSettings;
            }
            if (dataStream != null) {
                this.dataStream = dataStream;
            }
        }
    }
}

