/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.reindex;

import java.util.Map;
import org.opensearch.action.bulk.BulkItemResponse;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.index.reindex.BulkByScrollResponse;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestResponse;
import org.opensearch.rest.RestStatus;
import org.opensearch.rest.action.RestBuilderListener;

public class BulkIndexByScrollResponseContentListener
extends RestBuilderListener<BulkByScrollResponse> {
    private final Map<String, String> params;

    public BulkIndexByScrollResponseContentListener(RestChannel channel, Map<String, String> params) {
        super(channel);
        this.params = params;
    }

    public RestResponse buildResponse(BulkByScrollResponse response, XContentBuilder builder) throws Exception {
        builder.startObject();
        response.toXContent(builder, (ToXContent.Params)new ToXContent.DelegatingMapParams(this.params, (ToXContent.Params)this.channel.request()));
        builder.endObject();
        return new BytesRestResponse(this.getStatus(response), builder);
    }

    private RestStatus getStatus(BulkByScrollResponse response) {
        RestStatus status = RestStatus.OK;
        if (response.isTimedOut()) {
            status = RestStatus.REQUEST_TIMEOUT;
        }
        for (BulkItemResponse.Failure failure : response.getBulkFailures()) {
            if (failure.getStatus().getStatus() <= status.getStatus()) continue;
            status = failure.getStatus();
        }
        for (BulkItemResponse.Failure failure : response.getSearchFailures()) {
            RestStatus failureStatus = failure.getStatus();
            if (failureStatus.getStatus() <= status.getStatus()) continue;
            status = failureStatus;
        }
        return status;
    }
}

