/*
 * Decompiled with CFR 0.152.
 */
package org.opensky.libadsb;

import org.opensky.libadsb.exceptions.BadFormatException;
import org.opensky.libadsb.exceptions.UnspecifiedFormatError;
import org.opensky.libadsb.msgs.AirborneOperationalStatusV1Msg;
import org.opensky.libadsb.msgs.AirborneOperationalStatusV2Msg;
import org.opensky.libadsb.msgs.AirbornePositionV0Msg;
import org.opensky.libadsb.msgs.AirspeedHeadingMsg;
import org.opensky.libadsb.msgs.AllCallReply;
import org.opensky.libadsb.msgs.AltitudeReply;
import org.opensky.libadsb.msgs.CommBAltitudeReply;
import org.opensky.libadsb.msgs.CommBIdentifyReply;
import org.opensky.libadsb.msgs.CommDExtendedLengthMsg;
import org.opensky.libadsb.msgs.EmergencyOrPriorityStatusMsg;
import org.opensky.libadsb.msgs.ExtendedSquitter;
import org.opensky.libadsb.msgs.IdentificationMsg;
import org.opensky.libadsb.msgs.IdentifyReply;
import org.opensky.libadsb.msgs.LongACAS;
import org.opensky.libadsb.msgs.MilitaryExtendedSquitter;
import org.opensky.libadsb.msgs.ModeSReply;
import org.opensky.libadsb.msgs.OperationalStatusV0Msg;
import org.opensky.libadsb.msgs.ShortACAS;
import org.opensky.libadsb.msgs.SurfaceOperationalStatusV1Msg;
import org.opensky.libadsb.msgs.SurfaceOperationalStatusV2Msg;
import org.opensky.libadsb.msgs.SurfacePositionV0Msg;
import org.opensky.libadsb.msgs.TCASResolutionAdvisoryMsg;
import org.opensky.libadsb.msgs.TargetStateAndStatusMsg;
import org.opensky.libadsb.msgs.VelocityOverGroundMsg;

public class Decoder {
    public static ModeSReply genericDecoder(byte[] raw_message) throws BadFormatException, UnspecifiedFormatError {
        return Decoder.genericDecoder(new ModeSReply(raw_message));
    }

    public static ModeSReply genericDecoder(byte[] raw_message, boolean noCRC) throws BadFormatException, UnspecifiedFormatError {
        return Decoder.genericDecoder(new ModeSReply(raw_message, noCRC));
    }

    public static ModeSReply genericDecoder(String raw_message) throws BadFormatException, UnspecifiedFormatError {
        return Decoder.genericDecoder(new ModeSReply(raw_message));
    }

    public static ModeSReply genericDecoder(String raw_message, boolean noCRC) throws BadFormatException, UnspecifiedFormatError {
        return Decoder.genericDecoder(new ModeSReply(raw_message, noCRC));
    }

    public static ModeSReply genericDecoder(ModeSReply modes) throws BadFormatException, UnspecifiedFormatError {
        switch (modes.getDownlinkFormat()) {
            case 0: {
                return new ShortACAS(modes);
            }
            case 4: {
                return new AltitudeReply(modes);
            }
            case 5: {
                return new IdentifyReply(modes);
            }
            case 11: {
                return new AllCallReply(modes);
            }
            case 16: {
                return new LongACAS(modes);
            }
            case 17: 
            case 18: 
            case 19: {
                if (modes.getDownlinkFormat() == 17 || modes.getDownlinkFormat() == 18 && modes.getFirstField() < 2 || modes.getDownlinkFormat() == 19 && modes.getFirstField() == 0) {
                    int subtype2;
                    ExtendedSquitter es1090 = new ExtendedSquitter(modes);
                    byte ftc = es1090.getFormatTypeCode();
                    if (ftc >= 1 && ftc <= 4) {
                        return new IdentificationMsg(es1090);
                    }
                    if (ftc >= 5 && ftc <= 8) {
                        return new SurfacePositionV0Msg(es1090);
                    }
                    if (ftc >= 9 && ftc <= 18 || ftc >= 20 && ftc <= 22) {
                        return new AirbornePositionV0Msg(es1090);
                    }
                    if (ftc == 19) {
                        subtype2 = es1090.getMessage()[0] & 7;
                        if (subtype2 == 1 || subtype2 == 2) {
                            return new VelocityOverGroundMsg(es1090);
                        }
                        if (subtype2 == 3 || subtype2 == 4) {
                            return new AirspeedHeadingMsg(es1090);
                        }
                    }
                    if (ftc == 28) {
                        subtype2 = es1090.getMessage()[0] & 7;
                        if (subtype2 == 1) {
                            return new EmergencyOrPriorityStatusMsg(es1090);
                        }
                        if (subtype2 == 2) {
                            return new TCASResolutionAdvisoryMsg(es1090);
                        }
                    }
                    if (ftc == 29 && (subtype2 = es1090.getMessage()[0] >>> 1 & 3) == 1) {
                        return new TargetStateAndStatusMsg(es1090);
                    }
                    if (ftc == 31) {
                        subtype2 = es1090.getMessage()[0] & 7;
                        int version = es1090.getMessage()[5] >>> 5;
                        if (subtype2 == 0) {
                            switch (version) {
                                case 0: {
                                    return new OperationalStatusV0Msg(es1090);
                                }
                                case 1: {
                                    return new AirborneOperationalStatusV1Msg(es1090);
                                }
                                case 2: {
                                    return new AirborneOperationalStatusV2Msg(es1090);
                                }
                            }
                        } else if (subtype2 == 1) {
                            switch (version) {
                                case 0: {
                                    return new OperationalStatusV0Msg(es1090);
                                }
                                case 1: {
                                    return new SurfaceOperationalStatusV1Msg(es1090);
                                }
                                case 2: {
                                    return new SurfaceOperationalStatusV2Msg(es1090);
                                }
                            }
                        }
                    }
                    return es1090;
                }
                if (modes.getDownlinkFormat() == 18 && modes.getFirstField() == 6) {
                    return modes;
                }
                if (modes.getDownlinkFormat() == 18 && modes.getFirstField() < 4 || modes.getDownlinkFormat() == 18 && modes.getFirstField() == 5) {
                    return modes;
                }
                if (modes.getDownlinkFormat() == 18 && modes.getFirstField() == 4) {
                    return modes;
                }
                if (modes.getDownlinkFormat() == 19) {
                    return new MilitaryExtendedSquitter(modes);
                }
                return modes;
            }
            case 20: {
                return new CommBAltitudeReply(modes);
            }
            case 21: {
                return new CommBIdentifyReply(modes);
            }
        }
        if (modes.getDownlinkFormat() >= 24) {
            return new CommDExtendedLengthMsg(modes);
        }
        return modes;
    }
}

