/*
 * Decompiled with CFR 0.152.
 */
package org.opensky.libadsb;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.opensky.libadsb.Position;
import org.opensky.libadsb.PositionDecoder;
import org.opensky.libadsb.exceptions.BadFormatException;
import org.opensky.libadsb.exceptions.UnspecifiedFormatError;
import org.opensky.libadsb.msgs.AirborneOperationalStatusV1Msg;
import org.opensky.libadsb.msgs.AirborneOperationalStatusV2Msg;
import org.opensky.libadsb.msgs.AirbornePositionV0Msg;
import org.opensky.libadsb.msgs.AirbornePositionV1Msg;
import org.opensky.libadsb.msgs.AirbornePositionV2Msg;
import org.opensky.libadsb.msgs.AirspeedHeadingMsg;
import org.opensky.libadsb.msgs.AllCallReply;
import org.opensky.libadsb.msgs.AltitudeReply;
import org.opensky.libadsb.msgs.CommBAltitudeReply;
import org.opensky.libadsb.msgs.CommBIdentifyReply;
import org.opensky.libadsb.msgs.CommDExtendedLengthMsg;
import org.opensky.libadsb.msgs.EmergencyOrPriorityStatusMsg;
import org.opensky.libadsb.msgs.ExtendedSquitter;
import org.opensky.libadsb.msgs.IdentificationMsg;
import org.opensky.libadsb.msgs.IdentifyReply;
import org.opensky.libadsb.msgs.LongACAS;
import org.opensky.libadsb.msgs.MilitaryExtendedSquitter;
import org.opensky.libadsb.msgs.ModeSReply;
import org.opensky.libadsb.msgs.OperationalStatusV0Msg;
import org.opensky.libadsb.msgs.ShortACAS;
import org.opensky.libadsb.msgs.SurfaceOperationalStatusV1Msg;
import org.opensky.libadsb.msgs.SurfaceOperationalStatusV2Msg;
import org.opensky.libadsb.msgs.SurfacePositionV0Msg;
import org.opensky.libadsb.msgs.SurfacePositionV1Msg;
import org.opensky.libadsb.msgs.SurfacePositionV2Msg;
import org.opensky.libadsb.msgs.TCASResolutionAdvisoryMsg;
import org.opensky.libadsb.msgs.TargetStateAndStatusMsg;
import org.opensky.libadsb.msgs.VelocityOverGroundMsg;

public class ModeSDecoder {
    private Map<Integer, DecoderData> decoderData = new HashMap<Integer, DecoderData>();
    private int afterLastCleanup;
    private long latestTimestamp;

    public ModeSReply decode(ModeSReply modes) throws BadFormatException, UnspecifiedFormatError {
        if (++this.afterLastCleanup > 1000000 && this.decoderData.size() > 30000) {
            this.gc();
        }
        switch (modes.getDownlinkFormat()) {
            case 0: {
                return new ShortACAS(modes);
            }
            case 4: {
                return new AltitudeReply(modes);
            }
            case 5: {
                return new IdentifyReply(modes);
            }
            case 11: {
                return new AllCallReply(modes);
            }
            case 16: {
                return new LongACAS(modes);
            }
            case 17: 
            case 18: 
            case 19: {
                if (modes.getDownlinkFormat() == 17 || modes.getDownlinkFormat() == 18 && modes.getFirstField() < 2 || modes.getDownlinkFormat() == 19 && modes.getFirstField() == 0) {
                    int subtype2;
                    byte ftc;
                    ExtendedSquitter es1090 = new ExtendedSquitter(modes);
                    DecoderData dd = this.decoderData.get(modes.getTransponderAddress());
                    if (dd == null) {
                        dd = new DecoderData();
                        this.decoderData.put(modes.getTransponderAddress(), dd);
                    }
                    if ((ftc = es1090.getFormatTypeCode()) >= 1 && ftc <= 4) {
                        return new IdentificationMsg(es1090);
                    }
                    if (ftc >= 5 && ftc <= 8) {
                        switch (dd.adsbVersion) {
                            case 0: {
                                return new SurfacePositionV0Msg(es1090);
                            }
                            case 1: {
                                SurfacePositionV1Msg s1 = new SurfacePositionV1Msg(es1090);
                                s1.setNICSupplementA(dd.nicSupplA);
                                return s1;
                            }
                            case 2: {
                                SurfacePositionV2Msg s2 = new SurfacePositionV2Msg(es1090);
                                s2.setNICSupplementA(dd.nicSupplA);
                                s2.setNICSupplementC(dd.nicSupplC);
                                return s2;
                            }
                        }
                        return new SurfacePositionV0Msg(es1090);
                    }
                    if (ftc >= 9 && ftc <= 18 || ftc >= 20 && ftc <= 22) {
                        switch (dd.adsbVersion) {
                            case 0: {
                                return new AirbornePositionV0Msg(es1090);
                            }
                            case 1: {
                                AirbornePositionV1Msg a1 = new AirbornePositionV1Msg(es1090);
                                a1.setNICSupplementA(dd.nicSupplA);
                                return a1;
                            }
                            case 2: {
                                AirbornePositionV2Msg a2 = new AirbornePositionV2Msg(es1090);
                                a2.setNICSupplementA(dd.nicSupplA);
                                return a2;
                            }
                        }
                        return new AirbornePositionV0Msg(es1090);
                    }
                    if (ftc == 19) {
                        subtype2 = es1090.getMessage()[0] & 7;
                        if (subtype2 == 1 || subtype2 == 2) {
                            VelocityOverGroundMsg velocity = new VelocityOverGroundMsg(es1090);
                            if (velocity.hasGeoMinusBaroInfo()) {
                                dd.geoMinusBaro = velocity.getGeoMinusBaro();
                            }
                            return velocity;
                        }
                        if (subtype2 == 3 || subtype2 == 4) {
                            AirspeedHeadingMsg airspeed = new AirspeedHeadingMsg(es1090);
                            if (airspeed.hasGeoMinusBaroInfo()) {
                                dd.geoMinusBaro = airspeed.getGeoMinusBaro();
                            }
                            return airspeed;
                        }
                    }
                    if (ftc == 28) {
                        subtype2 = es1090.getMessage()[0] & 7;
                        if (subtype2 == 1) {
                            return new EmergencyOrPriorityStatusMsg(es1090);
                        }
                        if (subtype2 == 2) {
                            return new TCASResolutionAdvisoryMsg(es1090);
                        }
                    }
                    if (ftc == 29) {
                        boolean hasMe11Bit;
                        subtype2 = es1090.getMessage()[0] >>> 1 & 3;
                        boolean bl = hasMe11Bit = (es1090.getMessage()[1] & 0x20) != 0;
                        if (!(subtype2 != 1 || dd.adsbVersion <= 0 && hasMe11Bit)) {
                            return new TargetStateAndStatusMsg(es1090);
                        }
                    }
                    if (ftc == 31) {
                        subtype2 = es1090.getMessage()[0] & 7;
                        dd.adsbVersion = (byte)(es1090.getMessage()[5] >>> 5 & 7);
                        if (subtype2 == 0) {
                            switch (dd.adsbVersion) {
                                case 0: {
                                    return new OperationalStatusV0Msg(es1090);
                                }
                                case 1: {
                                    AirborneOperationalStatusV1Msg s1 = new AirborneOperationalStatusV1Msg(es1090);
                                    dd.nicSupplA = s1.hasNICSupplementA();
                                    return s1;
                                }
                                case 2: {
                                    AirborneOperationalStatusV2Msg s2 = new AirborneOperationalStatusV2Msg(es1090);
                                    dd.nicSupplA = s2.hasNICSupplementA();
                                    return s2;
                                }
                            }
                            throw new BadFormatException("Airborne operational status has invalid version: " + dd.adsbVersion);
                        }
                        if (subtype2 == 1) {
                            switch (dd.adsbVersion) {
                                case 0: {
                                    return new OperationalStatusV0Msg(es1090);
                                }
                                case 1: {
                                    SurfaceOperationalStatusV1Msg s1 = new SurfaceOperationalStatusV1Msg(es1090);
                                    dd.nicSupplA = s1.hasNICSupplementA();
                                    dd.nicSupplC = s1.getNICSupplementC();
                                    return s1;
                                }
                                case 2: {
                                    SurfaceOperationalStatusV2Msg s2 = new SurfaceOperationalStatusV2Msg(es1090);
                                    dd.nicSupplA = s2.hasNICSupplementA();
                                    dd.nicSupplC = s2.getNICSupplementC();
                                    return s2;
                                }
                            }
                            throw new BadFormatException("Surface operational status has invalid version: " + dd.adsbVersion);
                        }
                    }
                    return es1090;
                }
                if (modes.getDownlinkFormat() == 18 && modes.getFirstField() == 6) {
                    return modes;
                }
                if (modes.getDownlinkFormat() == 18 && modes.getFirstField() < 4 || modes.getDownlinkFormat() == 18 && modes.getFirstField() == 5) {
                    return modes;
                }
                if (modes.getDownlinkFormat() == 18 && modes.getFirstField() == 4) {
                    return modes;
                }
                if (modes.getDownlinkFormat() == 19) {
                    return new MilitaryExtendedSquitter(modes);
                }
                return modes;
            }
            case 20: {
                return new CommBAltitudeReply(modes);
            }
            case 21: {
                return new CommBIdentifyReply(modes);
            }
        }
        if (modes.getDownlinkFormat() >= 24) {
            return new CommDExtendedLengthMsg(modes);
        }
        return modes;
    }

    public <T extends SurfacePositionV0Msg> Position decodePosition(long time, T surfPos, Position receiverPos) {
        this.latestTimestamp = Math.max(this.latestTimestamp, time);
        DecoderData dd = this.decoderData.get(surfPos.getTransponderAddress());
        if (dd == null) {
            dd = new DecoderData();
            this.decoderData.put(surfPos.getTransponderAddress(), dd);
        }
        return dd.posDec.decodePosition((double)(time / 1000L), surfPos, receiverPos);
    }

    public <T extends AirbornePositionV0Msg> Position decodePosition(long time, T airPos, Position receiverPos) {
        this.latestTimestamp = Math.max(this.latestTimestamp, time);
        DecoderData dd = this.decoderData.get(airPos.getTransponderAddress());
        if (dd == null) {
            dd = new DecoderData();
            this.decoderData.put(airPos.getTransponderAddress(), dd);
        }
        return dd.posDec.decodePosition((double)(time / 1000L), receiverPos, airPos);
    }

    public <T extends ModeSReply> byte getAdsbVersion(T reply) {
        if (reply == null) {
            return 0;
        }
        DecoderData dd = this.decoderData.get(reply.getTransponderAddress());
        return dd == null ? (byte)0 : dd.adsbVersion;
    }

    public <T extends ModeSReply> Integer getGeoMinusBaro(T reply) {
        if (reply == null) {
            return null;
        }
        DecoderData dd = this.decoderData.get(reply.getTransponderAddress());
        return dd == null ? null : dd.geoMinusBaro;
    }

    public ModeSReply decode(byte[] raw_message) throws BadFormatException, UnspecifiedFormatError {
        return this.decode(new ModeSReply(raw_message));
    }

    public ModeSReply decode(byte[] raw_message, boolean noCRC) throws BadFormatException, UnspecifiedFormatError {
        return this.decode(new ModeSReply(raw_message, noCRC));
    }

    public ModeSReply decode(String raw_message) throws BadFormatException, UnspecifiedFormatError {
        return this.decode(new ModeSReply(raw_message));
    }

    public ModeSReply decode(String raw_message, boolean noCRC) throws BadFormatException, UnspecifiedFormatError {
        return this.decode(new ModeSReply(raw_message, noCRC));
    }

    public static <T extends ModeSReply> boolean isAirbornePosition(T reply) {
        if (reply == null) {
            return false;
        }
        ModeSReply.subtype t = reply.getType();
        return t == ModeSReply.subtype.ADSB_AIRBORN_POSITION_V0 || t == ModeSReply.subtype.ADSB_AIRBORN_POSITION_V1 || t == ModeSReply.subtype.ADSB_AIRBORN_POSITION_V2;
    }

    public static <T extends ModeSReply> boolean isSurfacePosition(T reply) {
        if (reply == null) {
            return false;
        }
        ModeSReply.subtype t = reply.getType();
        return t == ModeSReply.subtype.ADSB_SURFACE_POSITION_V0 || t == ModeSReply.subtype.ADSB_SURFACE_POSITION_V1 || t == ModeSReply.subtype.ADSB_SURFACE_POSITION_V2;
    }

    public static <T extends ModeSReply> boolean isPosition(T reply) {
        return ModeSDecoder.isAirbornePosition(reply) || ModeSDecoder.isSurfacePosition(reply);
    }

    public void gc() {
        ArrayList<Integer> toRemove = new ArrayList<Integer>();
        for (Integer transponder : this.decoderData.keySet()) {
            if (!(this.decoderData.get((Object)transponder).posDec.getLastUsedTime() < (double)(this.latestTimestamp - 3600000L))) continue;
            toRemove.add(transponder);
        }
        for (Integer transponder : toRemove) {
            this.decoderData.remove(transponder);
        }
    }

    private static class DecoderData {
        byte adsbVersion = 0;
        boolean nicSupplA;
        boolean nicSupplC;
        Integer geoMinusBaro;
        PositionDecoder posDec = new PositionDecoder();

        private DecoderData() {
        }
    }
}

