/*
 * Decompiled with CFR 0.152.
 */
package org.opensky.libadsb;

import java.io.Serializable;
import org.opensky.libadsb.tools;

public class Position
implements Serializable {
    private static final long serialVersionUID = 1562401753853965728L;
    private static final double a = 6378137.0;
    private static final double f = 0.0033528106647474805;
    private static final double b = 6356752.314245179;
    private static final double e2 = 0.0066943799901413165;
    private Double longitude;
    private Double latitude;
    private Double altitude;
    private boolean reasonable;

    public Position() {
        this.longitude = null;
        this.latitude = null;
        this.altitude = null;
        this.setReasonable(true);
    }

    public Position(Double lon, Double lat, Double alt) {
        this.longitude = lon;
        this.latitude = lat;
        this.altitude = alt;
        this.setReasonable(true);
    }

    public Double getLongitude() {
        return this.longitude;
    }

    public void setLongitude(Double longitude) {
        this.longitude = longitude;
    }

    public Double getLatitude() {
        return this.latitude;
    }

    public void setLatitude(Double latitude) {
        this.latitude = latitude;
    }

    public Double getAltitude() {
        return this.altitude;
    }

    public void setAltitude(Double altitude) {
        this.altitude = altitude;
    }

    public Double haversine(Position other) {
        double lon0r = Math.toRadians(this.longitude);
        double lat0r = Math.toRadians(this.latitude);
        double lon1r = Math.toRadians(other.longitude);
        double lat1r = Math.toRadians(other.latitude);
        double a = Math.pow(Math.sin((lat1r - lat0r) / 2.0), 2.0);
        double b = Math.cos(lat0r) * Math.cos(lat1r) * Math.pow(Math.sin((lon1r - lon0r) / 2.0), 2.0);
        return 1.2742E7 * Math.asin(Math.sqrt(a + b));
    }

    public double[] toECEF() {
        double lon0r = Math.toRadians(this.longitude);
        double lat0r = Math.toRadians(this.latitude);
        double height = tools.feet2Meters(this.altitude);
        double v = 6378137.0 / Math.sqrt(1.0 - 0.0066943799901413165 * Math.sin(lat0r) * Math.sin(lat0r));
        return new double[]{(v + height) * Math.cos(lat0r) * Math.cos(lon0r), (v + height) * Math.cos(lat0r) * Math.sin(lon0r), (v * 0.9933056200098587 + height) * Math.sin(lat0r)};
    }

    public static Position fromECEF(double x, double y, double z) {
        double p = Math.sqrt(x * x + y * y);
        double th = Math.atan2(6378137.0 * z, 6356752.314245179 * p);
        double lon = Math.atan2(y, x);
        double lat = Math.atan2(z + 42841.31151331357 * Math.pow(Math.sin(th), 3.0), p - 42697.67270717997 * Math.pow(Math.cos(th), 3.0));
        double N = 6378137.0 / Math.sqrt(1.0 - Math.pow(Math.sqrt(0.0066943799901413165) * Math.sin(lat), 2.0));
        double alt = p / Math.cos(lat) - N;
        if (Math.abs(x) < 1.0 & Math.abs(y) < 1.0) {
            alt = Math.abs(z) - 6356752.314245179;
        }
        return new Position(Math.toDegrees(lon), Math.toDegrees(lat), tools.meters2Feet(alt));
    }

    public Double distance3d(Position other) {
        if (other == null || this.latitude == null || this.longitude == null || this.altitude == null) {
            return null;
        }
        double[] xyz1 = this.toECEF();
        double[] xyz2 = other.toECEF();
        return Math.sqrt(Math.pow(xyz2[0] - xyz1[0], 2.0) + Math.pow(xyz2[1] - xyz1[1], 2.0) + Math.pow(xyz2[2] - xyz1[2], 2.0));
    }

    public boolean isReasonable() {
        return this.reasonable;
    }

    public void setReasonable(boolean reasonable) {
        this.reasonable = reasonable;
    }

    public String toString() {
        return "Position{longitude=" + this.longitude + ", latitude=" + this.latitude + ", altitude=" + this.altitude + ", reasonable=" + this.reasonable + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Position)) {
            return false;
        }
        Position position = (Position)o;
        if (this.reasonable != position.reasonable) {
            return false;
        }
        if (this.longitude != null ? !this.longitude.equals(position.longitude) : position.longitude != null) {
            return false;
        }
        if (this.latitude != null ? !this.latitude.equals(position.latitude) : position.latitude != null) {
            return false;
        }
        return this.altitude != null ? this.altitude.equals(position.altitude) : position.altitude == null;
    }

    public int hashCode() {
        int result = this.longitude != null ? this.longitude.hashCode() : 0;
        result = 31 * result + (this.latitude != null ? this.latitude.hashCode() : 0);
        result = 31 * result + (this.altitude != null ? this.altitude.hashCode() : 0);
        result = 31 * result + (this.reasonable ? 1 : 0);
        return result;
    }
}

