/*
 * Decompiled with CFR 0.152.
 */
package org.opensky.libadsb;

import org.opensky.libadsb.Position;
import org.opensky.libadsb.exceptions.BadFormatException;
import org.opensky.libadsb.exceptions.PositionStraddleError;
import org.opensky.libadsb.msgs.AirbornePositionV0Msg;
import org.opensky.libadsb.msgs.SurfacePositionV0Msg;
import org.opensky.libadsb.tools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PositionDecoder {
    private AirbornePositionV0Msg last_even_airborne;
    private double last_even_airborne_time;
    private AirbornePositionV0Msg last_odd_airborne;
    private double last_odd_airborne_time;
    private SurfacePositionV0Msg last_even_surface;
    private double last_even_surface_time;
    private SurfacePositionV0Msg last_odd_surface;
    private double last_odd_surface_time;
    private Position last_pos;
    private double last_time;
    private int num_reasonable;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final int MAX_DIST_TO_SENDER = 700000;

    public static boolean withinThreshold(double timeDifference, double distance, boolean surface) {
        double x = Math.abs(timeDifference);
        double d = Math.abs(distance);
        if (x < 0.7 && d < 2000.0) {
            return true;
        }
        return d / x < (surface ? 51.44 : 514.4) * 2.5;
    }

    private static boolean withinThreshold(double timeDifference, double distance) {
        return PositionDecoder.withinThreshold(timeDifference, distance, false);
    }

    public static boolean withinReasonableRange(Position receiver, Position sender) {
        return receiver.haversine(sender) <= 700000.0;
    }

    public Position decodePosition(double time, AirbornePositionV0Msg msg) {
        Position ret;
        double last_other_time;
        boolean local = false;
        boolean global = false;
        if (!msg.hasPosition()) {
            return null;
        }
        if (time < this.last_time) {
            this.logger.debug("Position messages should be ordered!");
        }
        if (this.last_pos != null && Math.abs(time - this.last_time) < 640.0) {
            local = true;
        }
        AirbornePositionV0Msg last_other = msg.isOddFormat() ? this.last_even_airborne : this.last_odd_airborne;
        double d = last_other_time = msg.isOddFormat() ? this.last_even_airborne_time : this.last_odd_airborne_time;
        if (last_other != null && Math.abs(time - last_other_time) < 10.0) {
            global = true;
        }
        Position global_pos = null;
        if (global) {
            try {
                global_pos = msg.getGlobalPosition(last_other);
            }
            catch (BadFormatException e) {
                this.logger.debug("Cannot do global CPR due to bad format (icao24: {}).", (Object)tools.toHexString(msg.getIcao24()));
                global = false;
            }
            catch (PositionStraddleError e) {
                this.logger.debug("Position staddle (icao24: {}).", (Object)tools.toHexString(msg.getIcao24()));
                global = false;
            }
            if (global_pos == null) {
                global = false;
            }
        }
        Position local_pos = null;
        if (local && (local_pos = msg.getLocalPosition(this.last_pos)) == null) {
            local = false;
        }
        boolean reasonable = true;
        double distance_threshold = 10.0;
        if (local && global && global_pos.haversine(local_pos) > distance_threshold) {
            this.logger.debug("Local and global differ by {} (icao24: {})", (Object)global_pos.haversine(local_pos), (Object)tools.toHexString(msg.getIcao24()));
            reasonable = false;
        }
        if (global && this.last_pos != null && !PositionDecoder.withinThreshold(time - this.last_time, global_pos.haversine(this.last_pos))) {
            this.logger.debug("'{}' would have been too fast ({} m/s) from other position.", (Object)tools.toHexString(msg.getIcao24()), (Object)(global_pos.haversine(this.last_pos) / Math.abs(time - this.last_time)));
            reasonable = false;
        }
        if (global) {
            try {
                Position other_pos;
                double dist = global_pos.haversine(msg.getLocalPosition(global_pos));
                if (dist > distance_threshold) {
                    reasonable = false;
                    this.logger.debug("Local/Global differ for new message by {} m (icao24: {})", (Object)dist, (Object)tools.toHexString(msg.getIcao24()));
                }
                if ((dist = (other_pos = last_other.getGlobalPosition(msg)).haversine(last_other.getLocalPosition(other_pos)).doubleValue()) > distance_threshold) {
                    reasonable = false;
                    this.logger.debug("Local/Global differ for old message by {} m (icao24: {})", (Object)dist, (Object)tools.toHexString(msg.getIcao24()));
                }
                if (!PositionDecoder.withinThreshold(time - last_other_time, global_pos.haversine(other_pos))) {
                    reasonable = false;
                    this.logger.debug("'{}' would have been too fast ({} m/s) for global.", (Object)tools.toHexString(msg.getIcao24()), (Object)(global_pos.haversine(other_pos) / Math.abs(last_other_time - time)));
                }
            }
            catch (BadFormatException e) {
                reasonable = false;
            }
            catch (PositionStraddleError e) {
                reasonable = false;
            }
        }
        if (local_pos != null && this.last_pos != null && !PositionDecoder.withinThreshold(this.last_time - time, local_pos.haversine(this.last_pos))) {
            this.logger.debug("'{}' would be too fast ({}/{} = {} m/s).", new Object[]{tools.toHexString(msg.getIcao24()), local_pos.haversine(this.last_pos), Math.abs(time - this.last_time), local_pos.haversine(this.last_pos) / Math.abs(time - this.last_time)});
            reasonable = false;
        }
        if (msg.isOddFormat() && msg.hasPosition()) {
            this.last_odd_airborne = msg;
            this.last_odd_airborne_time = time;
        } else if (!msg.isOddFormat() && msg.hasPosition()) {
            this.last_even_airborne = msg;
            this.last_even_airborne_time = time;
        }
        Position position = ret = global ? global_pos : local_pos;
        if (ret != null) {
            if (Math.abs(ret.getLongitude()) > 180.0 || Math.abs(ret.getLatitude()) > 90.0) {
                reasonable = false;
            }
            ret.setReasonable(reasonable);
        }
        this.last_pos = ret;
        this.last_time = time;
        if (!reasonable) {
            this.num_reasonable = 0;
        } else if (this.num_reasonable++ < 2) {
            ret = null;
        }
        return ret;
    }

    public Position decodePosition(double time, Position receiver, AirbornePositionV0Msg msg) {
        Position ret = this.decodePosition(time, msg);
        if (ret != null && receiver != null && !PositionDecoder.withinReasonableRange(receiver, ret)) {
            ret.setReasonable(false);
            this.num_reasonable = 0;
        }
        return ret;
    }

    public Position decodePosition(Position receiver, AirbornePositionV0Msg msg) {
        return this.decodePosition((double)System.currentTimeMillis() / 1000.0, receiver, msg);
    }

    public Position decodePosition(AirbornePositionV0Msg msg) {
        return this.decodePosition((double)System.currentTimeMillis() / 1000.0, msg);
    }

    public Position decodePosition(double time, SurfacePositionV0Msg msg, Position ref) {
        Position ret;
        double last_other_time;
        Position real_ref;
        boolean local = false;
        boolean global = false;
        if (!msg.hasPosition() || this.last_pos == null && ref == null) {
            return null;
        }
        Position position = real_ref = this.last_pos != null ? this.last_pos : ref;
        if (time <= this.last_time) {
            this.logger.debug("Position messages should be ordered!");
        }
        if (this.last_pos != null && Math.abs(time - this.last_time) < 1620.0) {
            local = true;
        }
        SurfacePositionV0Msg last_other = msg.isOddFormat() ? this.last_even_surface : this.last_odd_surface;
        double d = last_other_time = msg.isOddFormat() ? this.last_even_surface_time : this.last_odd_surface_time;
        if (last_other != null) {
            if (last_other.hasGroundSpeed() && last_other.getGroundSpeed() <= 25.0 && msg.hasGroundSpeed() && msg.getGroundSpeed() <= 25.0 && Math.abs(time - last_other_time) <= 50.0) {
                global = true;
            } else if (Math.abs(time - last_other_time) <= 25.0) {
                global = true;
            }
        }
        Position global_pos = null;
        if (global) {
            try {
                global_pos = msg.getGlobalPosition(last_other, real_ref);
            }
            catch (BadFormatException e) {
                this.logger.debug("Cannot do global CPR due to bad format (icao24: {}).", (Object)tools.toHexString(msg.getIcao24()));
                global = false;
            }
            catch (PositionStraddleError e) {
                this.logger.debug("Position staddle (icao24: {}).", (Object)tools.toHexString(msg.getIcao24()));
                global = false;
            }
            if (global_pos == null) {
                global = false;
            }
        }
        Position local_pos = null;
        if (local && (local_pos = msg.getLocalPosition(this.last_pos)) == null) {
            local = false;
        }
        boolean reasonable = true;
        double distance_threshold = 10.0;
        if (local && global && global_pos.haversine(local_pos) > distance_threshold) {
            this.logger.debug("Local and global differ by {} (icao24: {})\n", (Object)global_pos.haversine(local_pos), (Object)tools.toHexString(msg.getIcao24()));
            reasonable = false;
        }
        if (global && this.last_pos != null && !PositionDecoder.withinThreshold(time - this.last_time, global_pos.haversine(this.last_pos), true)) {
            this.logger.debug("'{}' would have been too fast ({} m/s) from other position.\n", (Object)tools.toHexString(msg.getIcao24()), (Object)(global_pos.haversine(this.last_pos) / Math.abs(time - this.last_time)));
            reasonable = false;
        }
        if (global) {
            try {
                Position other_pos;
                double dist = global_pos.haversine(msg.getLocalPosition(global_pos));
                if (dist > distance_threshold) {
                    reasonable = false;
                    this.logger.debug("Local/Global differ for new message by {} m (icao24: {})", (Object)dist, (Object)tools.toHexString(msg.getIcao24()));
                }
                if ((dist = (other_pos = last_other.getGlobalPosition(msg, real_ref)).haversine(last_other.getLocalPosition(other_pos)).doubleValue()) > distance_threshold) {
                    reasonable = false;
                    this.logger.debug("Local/Global differ for old message by {} m (icao24: {})", (Object)dist, (Object)tools.toHexString(msg.getIcao24()));
                }
                if (!PositionDecoder.withinThreshold(time - last_other_time, global_pos.haversine(other_pos), true)) {
                    reasonable = false;
                    this.logger.debug("'{}' would have been too fast ({} m/s) for global.", (Object)tools.toHexString(msg.getIcao24()), (Object)(global_pos.haversine(other_pos) / Math.abs(last_other_time - time)));
                }
            }
            catch (BadFormatException e) {
                reasonable = false;
            }
            catch (PositionStraddleError e) {
                reasonable = false;
            }
        }
        if (local_pos != null && this.last_pos != null && !PositionDecoder.withinThreshold(this.last_time - time, local_pos.haversine(this.last_pos), true)) {
            this.logger.debug("'{}' would be too fast ({}/{} = {} m/s).", new Object[]{tools.toHexString(msg.getIcao24()), local_pos.haversine(this.last_pos), Math.abs(time - this.last_time), local_pos.haversine(this.last_pos) / Math.abs(time - this.last_time)});
            reasonable = false;
        }
        if (msg.isOddFormat() && msg.hasPosition()) {
            this.last_odd_surface = msg;
            this.last_odd_surface_time = time;
        } else if (!msg.isOddFormat() && msg.hasPosition()) {
            this.last_even_surface = msg;
            this.last_even_surface_time = time;
        }
        Position position2 = ret = global ? global_pos : local_pos;
        if (ret != null) {
            if (Math.abs(ret.getLongitude()) > 180.0 || Math.abs(ret.getLatitude()) > 90.0) {
                reasonable = false;
            }
            ret.setReasonable(reasonable);
        }
        this.last_pos = ret;
        this.last_time = time;
        if (!reasonable) {
            this.num_reasonable = 0;
        } else if (this.num_reasonable++ < 2) {
            ret = null;
        }
        return ret;
    }

    public Position decodePosition(double time, SurfacePositionV0Msg msg) {
        if (this.last_pos == null) {
            return null;
        }
        return this.decodePosition(time, msg, this.last_pos);
    }

    public Position decodePosition(SurfacePositionV0Msg msg, Position reference) {
        return this.decodePosition((double)System.currentTimeMillis() / 1000.0, msg, reference);
    }

    public Position decodePosition(double time, Position receiver, SurfacePositionV0Msg msg, Position reference) {
        Position ret = this.decodePosition(time, msg, reference);
        if (ret != null && receiver != null && !PositionDecoder.withinReasonableRange(receiver, ret)) {
            ret.setReasonable(false);
            this.num_reasonable = 0;
        }
        return ret;
    }

    public double getLastUsedTime() {
        return this.last_time;
    }
}

