/*
 * Decompiled with CFR 0.152.
 */
package org.opensky.libadsb.msgs;

import java.io.Serializable;
import org.opensky.libadsb.exceptions.BadFormatException;
import org.opensky.libadsb.exceptions.UnspecifiedFormatError;
import org.opensky.libadsb.msgs.ExtendedSquitter;
import org.opensky.libadsb.msgs.ModeSReply;

public class AirborneOperationalStatusV1Msg
extends ExtendedSquitter
implements Serializable {
    private byte subtype_code;
    private int capability_class_code;
    private int operational_mode_code;
    private byte version;
    private boolean nic_suppl;
    private byte nac_pos;
    private byte geometric_vertical_accuracy;
    private byte sil;
    private boolean nic_trk_hdg;
    private boolean hrd;

    protected AirborneOperationalStatusV1Msg() {
    }

    public AirborneOperationalStatusV1Msg(String raw_message) throws BadFormatException, UnspecifiedFormatError {
        this(new ExtendedSquitter(raw_message));
    }

    public AirborneOperationalStatusV1Msg(byte[] raw_message) throws BadFormatException, UnspecifiedFormatError {
        this(new ExtendedSquitter(raw_message));
    }

    public AirborneOperationalStatusV1Msg(ExtendedSquitter squitter) throws BadFormatException, UnspecifiedFormatError {
        super(squitter);
        this.setType(ModeSReply.subtype.ADSB_AIRBORN_STATUS_V1);
        if (this.getFormatTypeCode() != 31) {
            throw new BadFormatException("Operational status messages must have typecode 31.");
        }
        byte[] msg = this.getMessage();
        this.subtype_code = (byte)(msg[0] & 7);
        if (this.subtype_code > 1) {
            throw new UnspecifiedFormatError("Operational status message subtype " + this.subtype_code + " reserved.");
        }
        this.capability_class_code = msg[1] << 8 | msg[2];
        if (this.subtype_code != 0) {
            throw new BadFormatException("Not an airborne operational status message");
        }
        this.operational_mode_code = msg[3] << 8 | msg[4];
        this.version = (byte)(msg[5] >>> 5 & 7);
        if ((this.capability_class_code & 0xC000) != 0) {
            throw new BadFormatException("Unknown capability class code!");
        }
        this.nic_suppl = (msg[5] & 0x10) != 0;
        this.nac_pos = (byte)(msg[5] & 0xF);
        this.geometric_vertical_accuracy = (byte)(msg[6] >>> 6 & 3);
        this.sil = (byte)(msg[6] >>> 4 & 3);
        this.nic_trk_hdg = (msg[6] & 8) != 0;
        this.hrd = (msg[6] & 4) != 0;
    }

    public boolean hasOperationalTCAS() {
        return (this.capability_class_code & 0x2000) != 0;
    }

    public boolean has1090ESIn() {
        return (this.capability_class_code & 0x1000) != 0;
    }

    public boolean hasAirReferencedVelocity() {
        return (this.capability_class_code & 0x200) != 0;
    }

    public boolean hasTargetStateReport() {
        return (this.capability_class_code & 0x100) != 0;
    }

    public boolean supportsTargetChangeReport() {
        byte target_change_report_capability = (byte)((this.capability_class_code & 0xC0) >>> 6);
        return target_change_report_capability == 1 || target_change_report_capability == 2;
    }

    public boolean hasUATIn() {
        return (this.capability_class_code & 0x20) != 0;
    }

    public boolean hasTCASResolutionAdvisory() {
        return (this.operational_mode_code & 0x2000) != 0;
    }

    public boolean hasActiveIDENTSwitch() {
        return (this.operational_mode_code & 0x1000) != 0;
    }

    public boolean hasSingleAntenna() {
        return (this.operational_mode_code & 0x400) != 0;
    }

    public byte getSystemDesignAssurance() {
        return (byte)((this.operational_mode_code & 0x300) >>> 8);
    }

    public byte getVersion() {
        return this.version;
    }

    public boolean hasNICSupplementA() {
        return this.nic_suppl;
    }

    public byte getNACp() {
        return this.nac_pos;
    }

    public double getPositionUncertainty() {
        switch (this.nac_pos) {
            case 1: {
                return 18520.0;
            }
            case 2: {
                return 7408.0;
            }
            case 3: {
                return 3704.0;
            }
            case 4: {
                return 1852.0;
            }
            case 5: {
                return 926.0;
            }
            case 6: {
                return 555.6;
            }
            case 7: {
                return 185.2;
            }
            case 8: {
                return 92.6;
            }
            case 9: {
                return 30.0;
            }
            case 10: {
                return 10.0;
            }
            case 11: {
                return 3.0;
            }
        }
        return -1.0;
    }

    public int getGeometricVerticalAccuracy() {
        if (this.geometric_vertical_accuracy == 1) {
            return 150;
        }
        if (this.geometric_vertical_accuracy == 2) {
            return 45;
        }
        return -1;
    }

    public byte getGVA() {
        return this.geometric_vertical_accuracy;
    }

    public byte getSIL() {
        return this.sil;
    }

    public boolean getBarometricAltitudeIntegrityCode() {
        return this.nic_trk_hdg;
    }

    public boolean getHorizontalReferenceDirection() {
        return this.hrd;
    }

    @Override
    public String toString() {
        String retstr = "Airborne operational status:\n";
        retstr = retstr + "\tHas TCAS: ";
        retstr = retstr + (this.hasOperationalTCAS() ? "yes" : "no") + "\n";
        retstr = retstr + "\tAir-referenced velocity: ";
        retstr = retstr + (this.hasAirReferencedVelocity() ? "yes" : "no") + "\n";
        retstr = retstr + "\tTarget State Reports: ";
        retstr = retstr + (this.hasTargetStateReport() ? "yes" : "no") + "\n";
        retstr = retstr + "\tTarget Change Reports: ";
        retstr = retstr + (this.supportsTargetChangeReport() ? "yes" : "no") + "\n";
        retstr = retstr + "\tHas 1090ES IN: ";
        retstr = retstr + (this.has1090ESIn() ? "yes" : "no") + "\n";
        retstr = retstr + "\tHas UAT IN: ";
        retstr = retstr + (this.hasUATIn() ? "yes" : "no") + "\n";
        retstr = retstr + "\tUses TCAS: ";
        retstr = retstr + (this.hasTCASResolutionAdvisory() ? "yes" : "no") + "\n";
        retstr = retstr + "\tIDENT Switch on: ";
        retstr = retstr + (this.hasActiveIDENTSwitch() ? "yes" : "no") + "\n";
        retstr = retstr + "\tUses single antenna: ";
        retstr = retstr + (this.hasSingleAntenna() ? "yes" : "no") + "\n";
        retstr = retstr + "\tSystem design assurance: ";
        retstr = retstr + this.getSystemDesignAssurance() + "\n";
        retstr = retstr + "\tADS-B version: " + this.getVersion() + "\n";
        retstr = retstr + "\tNIC supplement A: ";
        retstr = retstr + (this.hasNICSupplementA() ? "true" : "false") + "\n";
        retstr = retstr + "\tPosition NAC: " + this.getNACp() + "\n";
        retstr = retstr + "\tVertical Accuracy: " + this.getGeometricVerticalAccuracy() + "\n";
        retstr = retstr + "\tSource Integrity Level: " + this.getSIL() + "\n";
        retstr = retstr + "\tHorizontal reference: " + this.getHorizontalReferenceDirection();
        return super.toString() + "\n" + retstr;
    }
}

