/*
 * Decompiled with CFR 0.152.
 */
package org.opensky.libadsb.msgs;

import java.io.Serializable;
import org.opensky.libadsb.Position;
import org.opensky.libadsb.exceptions.BadFormatException;
import org.opensky.libadsb.exceptions.PositionStraddleError;
import org.opensky.libadsb.msgs.ExtendedSquitter;
import org.opensky.libadsb.msgs.ModeSReply;
import org.opensky.libadsb.tools;

public class AirbornePositionV0Msg
extends ExtendedSquitter
implements Serializable {
    private static final long serialVersionUID = -1901589500173456758L;
    private boolean horizontal_position_available;
    private boolean altitude_available;
    private byte surveillance_status;
    private boolean nic_suppl_b;
    private short altitude_encoded;
    private boolean time_flag;
    private boolean cpr_format;
    private int cpr_encoded_lat;
    private int cpr_encoded_lon;

    protected AirbornePositionV0Msg() {
    }

    public AirbornePositionV0Msg(String raw_message) throws BadFormatException {
        this(new ExtendedSquitter(raw_message));
    }

    public AirbornePositionV0Msg(byte[] raw_message) throws BadFormatException {
        this(new ExtendedSquitter(raw_message));
    }

    public AirbornePositionV0Msg(ExtendedSquitter squitter) throws BadFormatException {
        super(squitter);
        this.setType(ModeSReply.subtype.ADSB_AIRBORN_POSITION_V0);
        if (!(this.getFormatTypeCode() == 0 || this.getFormatTypeCode() >= 9 && this.getFormatTypeCode() <= 18 || this.getFormatTypeCode() >= 20 && this.getFormatTypeCode() <= 22)) {
            throw new BadFormatException("This is not a position message! Wrong format type code (" + this.getFormatTypeCode() + ").");
        }
        byte[] msg = this.getMessage();
        this.horizontal_position_available = this.getFormatTypeCode() != 0;
        this.surveillance_status = (byte)(msg[0] >>> 1 & 3);
        this.nic_suppl_b = (msg[0] & 1) == 1;
        this.altitude_encoded = (short)((msg[1] << 4 | msg[2] >>> 4 & 0xF) & 0xFFF);
        this.altitude_available = this.altitude_encoded != 0;
        this.time_flag = (msg[2] >>> 3 & 1) == 1;
        this.cpr_format = (msg[2] >>> 2 & 1) == 1;
        this.cpr_encoded_lat = ((msg[2] & 3) << 15 | (msg[3] & 0xFF) << 7 | msg[4] >>> 1 & 0x7F) & 0x1FFFF;
        this.cpr_encoded_lon = ((msg[4] & 1) << 16 | (msg[5] & 0xFF) << 8 | msg[6] & 0xFF) & 0x1FFFF;
    }

    public double getHorizontalContainmentRadiusLimit() {
        switch (this.getFormatTypeCode()) {
            case 0: 
            case 18: 
            case 22: {
                return -1.0;
            }
            case 9: 
            case 20: {
                return 7.5;
            }
            case 10: 
            case 21: {
                return 25.0;
            }
            case 11: {
                return 185.2;
            }
            case 12: {
                return 370.4;
            }
            case 13: {
                return 926.0;
            }
            case 14: {
                return 1852.0;
            }
            case 15: {
                return 3704.0;
            }
            case 16: {
                return 18520.0;
            }
            case 17: {
                return 37040.0;
            }
        }
        return -1.0;
    }

    public byte getNACp() {
        switch (this.getFormatTypeCode()) {
            case 0: 
            case 18: 
            case 22: {
                return 0;
            }
            case 9: 
            case 20: {
                return 11;
            }
            case 10: 
            case 21: {
                return 10;
            }
            case 11: {
                return 8;
            }
            case 12: {
                return 7;
            }
            case 13: {
                return 6;
            }
            case 14: {
                return 5;
            }
            case 15: {
                return 4;
            }
            case 16: 
            case 17: {
                return 1;
            }
        }
        return 0;
    }

    public double getPositionUncertainty() {
        switch (this.getFormatTypeCode()) {
            case 0: 
            case 18: 
            case 22: {
                return -1.0;
            }
            case 9: {
                return 3.0;
            }
            case 10: {
                return 10.0;
            }
            case 11: {
                return 92.6;
            }
            case 12: {
                return 185.2;
            }
            case 13: {
                return 463.0;
            }
            case 14: {
                return 926.0;
            }
            case 15: {
                return 1852.0;
            }
            case 16: {
                return 9260.0;
            }
            case 17: {
                return 18520.0;
            }
        }
        return -1.0;
    }

    public byte getNIC() {
        switch (this.getFormatTypeCode()) {
            case 0: 
            case 18: 
            case 22: {
                return 0;
            }
            case 9: 
            case 20: {
                return 11;
            }
            case 10: 
            case 21: {
                return 10;
            }
            case 11: {
                return 9;
            }
            case 12: {
                return 7;
            }
            case 13: {
                return 6;
            }
            case 14: {
                return 5;
            }
            case 15: {
                return 4;
            }
            case 16: {
                return 3;
            }
            case 17: {
                return 1;
            }
        }
        return 0;
    }

    public byte getSIL() {
        switch (this.getFormatTypeCode()) {
            case 0: 
            case 18: 
            case 22: {
                return 0;
            }
        }
        return 2;
    }

    public boolean hasPosition() {
        return this.horizontal_position_available;
    }

    public boolean hasAltitude() {
        return this.altitude_available;
    }

    public byte getSurveillanceStatus() {
        return this.surveillance_status;
    }

    public String getSurveillanceStatusDescription() {
        String[] desc = new String[]{"No condition information", "Permanent alert (emergency condition)", "Temporary alert (change in Mode A identity code oter than emergency condition)", "SPI condition"};
        return desc[this.surveillance_status];
    }

    public boolean hasSingleAntenna() {
        return this.nic_suppl_b;
    }

    public boolean hasTimeFlag() {
        return this.time_flag;
    }

    public int getCPREncodedLatitude() {
        return this.cpr_encoded_lat;
    }

    public int getCPREncodedLongitude() {
        return this.cpr_encoded_lon;
    }

    public boolean isOddFormat() {
        return this.cpr_format;
    }

    public boolean isBarometricAltitude() {
        return this.getFormatTypeCode() < 20;
    }

    private double NL(double Rlat) {
        if (Rlat == 0.0) {
            return 59.0;
        }
        if (Math.abs(Rlat) == 87.0) {
            return 2.0;
        }
        if (Math.abs(Rlat) > 87.0) {
            return 1.0;
        }
        double tmp = 1.0 - (1.0 - Math.cos(0.10471975511965977)) / Math.pow(Math.cos(Math.PI / 180 * Math.abs(Rlat)), 2.0);
        return Math.floor(Math.PI * 2 / Math.acos(tmp));
    }

    private static double mod(double a, double b) {
        return (a % b + b) % b;
    }

    public Position getGlobalPosition(AirbornePositionV0Msg other) throws BadFormatException, PositionStraddleError {
        double m;
        if (!tools.areEqual(other.getIcao24(), this.getIcao24())) {
            throw new IllegalArgumentException(String.format("Transmitter of other message (%s) not equal to this (%s).", tools.toHexString(other.getIcao24()), tools.toHexString(this.getIcao24())));
        }
        if (other.isOddFormat() == this.isOddFormat()) {
            throw new BadFormatException("Expected " + (this.isOddFormat() ? "even" : "odd") + " message format.", other.toString());
        }
        if (!this.horizontal_position_available || !other.hasPosition()) {
            return null;
        }
        AirbornePositionV0Msg even = this.isOddFormat() ? other : this;
        AirbornePositionV0Msg odd = this.isOddFormat() ? this : other;
        double Dlat0 = 6.0;
        double Dlat1 = 6.101694915254237;
        double j = Math.floor((59.0 * (double)even.getCPREncodedLatitude() - 60.0 * (double)odd.getCPREncodedLatitude()) / 131072.0 + 0.5);
        double Rlat0 = Dlat0 * (AirbornePositionV0Msg.mod(j, 60.0) + (double)even.getCPREncodedLatitude() / 131072.0);
        double Rlat1 = Dlat1 * (AirbornePositionV0Msg.mod(j, 59.0) + (double)odd.getCPREncodedLatitude() / 131072.0);
        if (Rlat0 >= 270.0 && Rlat0 <= 360.0) {
            Rlat0 -= 360.0;
        }
        if (Rlat1 >= 270.0 && Rlat1 <= 360.0) {
            Rlat1 -= 360.0;
        }
        if (this.NL(Rlat0) != this.NL(Rlat1)) {
            throw new PositionStraddleError("The two given position straddle a transition latitude and cannot be decoded. Wait for positions where they are equal.");
        }
        double NL_helper = this.NL(Rlat0);
        double n_helper = Math.max(1.0, NL_helper - (this.isOddFormat() ? 1.0 : 0.0));
        double Dlon = 360.0 / n_helper;
        double Rlon = Dlon * (AirbornePositionV0Msg.mod(m = Math.floor(((double)even.getCPREncodedLongitude() * (NL_helper - 1.0) - (double)odd.getCPREncodedLongitude() * NL_helper) / 131072.0 + 0.5), n_helper) + (double)(this.isOddFormat() ? odd.getCPREncodedLongitude() : even.getCPREncodedLongitude()) / 131072.0);
        if (Rlon < -180.0 && Rlon > -360.0) {
            Rlon += 360.0;
        }
        if (Rlon > 180.0 && Rlon < 360.0) {
            Rlon -= 360.0;
        }
        Integer alt = this.getAltitude();
        return new Position(Rlon, this.isOddFormat() ? Rlat1 : Rlat0, alt != null ? Double.valueOf(alt.doubleValue()) : null);
    }

    public Position getLocalPosition(Position ref) {
        if (!this.horizontal_position_available) {
            return null;
        }
        double Dlat = this.isOddFormat() ? 6.101694915254237 : 6.0;
        double j = Math.floor(ref.getLatitude() / Dlat) + Math.floor(0.5 + AirbornePositionV0Msg.mod(ref.getLatitude(), Dlat) / Dlat - (double)this.getCPREncodedLatitude() / 131072.0);
        double Rlat = Dlat * (j + (double)this.getCPREncodedLatitude() / 131072.0);
        double Dlon = 360.0 / Math.max(1.0, this.NL(Rlat) - (this.isOddFormat() ? 1.0 : 0.0));
        double m = Math.floor(ref.getLongitude() / Dlon) + Math.floor(0.5 + AirbornePositionV0Msg.mod(ref.getLongitude(), Dlon) / Dlon - (double)this.getCPREncodedLongitude() / 131072.0);
        double Rlon = Dlon * (m + (double)this.getCPREncodedLongitude() / 131072.0);
        Integer alt = this.getAltitude();
        return new Position(Rlon, Rlat, alt != null ? Double.valueOf(alt.doubleValue()) : null);
    }

    private static int grayToBin(int gray, int bitlength) {
        int result = 0;
        for (int i = bitlength - 1; i >= 0; --i) {
            result |= (1 << i + 1 & result) >>> 1 ^ 1 << i & gray;
        }
        return result;
    }

    public Integer getAltitude() {
        boolean Qbit;
        if (!this.altitude_available) {
            return null;
        }
        boolean bl = Qbit = (this.altitude_encoded & 0x10) != 0;
        if (Qbit) {
            int N = this.altitude_encoded & 0xF | (this.altitude_encoded & 0xFE0) >>> 1;
            return 25 * N - 1000;
        }
        int C1 = (0x800 & this.altitude_encoded) >>> 11;
        int A1 = (0x400 & this.altitude_encoded) >>> 10;
        int C2 = (0x200 & this.altitude_encoded) >>> 9;
        int A2 = (0x100 & this.altitude_encoded) >>> 8;
        int C4 = (0x80 & this.altitude_encoded) >>> 7;
        int A4 = (0x40 & this.altitude_encoded) >>> 6;
        int B1 = (0x20 & this.altitude_encoded) >>> 5;
        int B2 = (8 & this.altitude_encoded) >>> 3;
        int D2 = (4 & this.altitude_encoded) >>> 2;
        int B4 = (2 & this.altitude_encoded) >>> 1;
        int D4 = 1 & this.altitude_encoded;
        int N500 = AirbornePositionV0Msg.grayToBin(D2 << 7 | D4 << 6 | A1 << 5 | A2 << 4 | A4 << 3 | B1 << 2 | B2 << 1 | B4, 8);
        int N100 = AirbornePositionV0Msg.grayToBin(C1 << 2 | C2 << 1 | C4, 3) - 1;
        if (N100 == 6) {
            N100 = 4;
        }
        if (N500 % 2 != 0) {
            N100 = 4 - N100;
        }
        return -1200 + N500 * 500 + N100 * 100;
    }

    @Override
    public String toString() {
        return super.toString() + "\nPosition:\n\tFormat:\t\t" + (this.isOddFormat() ? "odd" : "even") + "\n\tHas position:\t" + (this.hasPosition() ? "yes" : "no") + "\n\tAltitude:\t" + (this.hasAltitude() ? this.getAltitude() : "unkown");
    }
}

